// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

    /// Common functionality for all hkArray types.
    /// Resizing functions are out of line functions to avoid code bloat.
class HK_EXPORT_COMMON hkArrayUtil
{
public:

    template<typename T> static HK_INLINE void construct(_Out_writes_(n) T* t, int n, hkTrait::TypeIsPod);
    template<typename T> static HK_INLINE void construct(_Out_writes_(n) T* t, int n, hkTrait::TypeIsClass);

    template<typename T, typename U> static HK_INLINE void constructWithCopy(_Out_writes_(n) T* t, int n, const U& tcopy, hkTrait::TypeIsPod);
    template<typename T, typename U> static HK_INLINE void constructWithCopy(_Out_writes_(n) T* t, int n, const U& tcopy, hkTrait::TypeIsClass);

    template<typename T> static HK_INLINE void destruct(_Inout_updates_(n) T* t, int n, hkTrait::TypeIsPod);
    template<typename T> static HK_INLINE void destruct(_Inout_updates_(n) T* t, int n, hkTrait::TypeIsClass);

    template<typename T, typename U> static HK_INLINE void constructWithArray(_Out_writes_(n) T* t, int n, _In_reads_(n) const U* tcopy, hkTrait::TypeIsPod);
    template<typename T, typename U> static HK_INLINE void constructWithArray(_Out_writes_(n) T* t, int n, _In_reads_(n) const U* tcopy, hkTrait::TypeIsClass);

    static hkResult HK_CALL _reserve( hkMemoryAllocator& a, _Out_writes_bytes_(reqElem*sizeElem) void*, int reqElem, int sizeElem);
    static void HK_CALL _reserveMore( hkMemoryAllocator& a, _Inout_ void* array, int sizeElem);
    static void HK_CALL _reduce( hkMemoryAllocator& a, _Inout_updates_(sizeElem*requestedCapacity) void* array, int sizeElem,
        _Out_writes_bytes_opt_(requestedCapacity*sizeElem) char* inplaceMem, int requestedCapacity);
};


#include <Common/Base/Container/Array/hkArrayUtil.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
