// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Fwd/hkcstring.h>
#include <Common/Base/Container/hkContainerAllocators.h>

using namespace std;

// hack to force this to be out of line
hkResult HK_CALL hkArrayUtil::_reserve(hkMemoryAllocator& mem, _Out_writes_bytes_(numElem*sizeElem) void* array, int numElem, int sizeElem)
{
    typedef hkArray<char> hkAnyArray;
    int reqNumBytes;
    // check for negative inputs & overflow
    if (hkCheckMulSizes(numElem, sizeElem, &reqNumBytes).isFailure())
    {
        HK_FATAL_ERROR(0x0, "Array size overflow {}*{}", numElem, sizeElem);
    }

    hkAnyArray* self = reinterpret_cast< hkAnyArray* >(array);
    // This call must increase capacity, but not too much
    if (numElem < self->getCapacity() || numElem > hkAnyArray::CAPACITY_MASK)
    {
        HK_FATAL_ERROR(0x0, "Invalid numElem {}", numElem);
    }
    // We know numElem >= capacity and numElem*sizeElem doesn't overflow.
    // Therefore sizeElem can be safely multiplied with both m_size and m_capacity

    char* p = HK_NULL;
    if( (self->m_capacityAndFlags & hkAnyArray::DONT_DEALLOCATE_FLAG) == 0)
    {
        p = static_cast<char*>( mem.bufRealloc( self->m_data, self->getCapacity()*sizeElem, reqNumBytes) );
    }
    else
    {
        p = static_cast<char*>(mem.bufAlloc(reqNumBytes));
        if(p)
        {
            memcpy(p, self->m_data, self->m_size*sizeElem);
        }
    }

    self->m_data = p;
    self->m_capacityAndFlags = p ? (reqNumBytes / sizeElem) : 0;

    return (p) ? HK_SUCCESS : HK_FAILURE;
}


// hack to force this to be out of line
void hkArrayUtil::_reserveMore(hkMemoryAllocator& mem, void* array, int sizeElem)
{
    typedef hkArray<char> hkAnyArray;
    hkAnyArray* self = reinterpret_cast< hkAnyArray* >(array);
    // size <= capacity and capacity has 2 bits free so this is safe
    HK_COMPILE_TIME_ASSERT((hkAnyArray::CAPACITY_MASK >> 30) == 0);
    int numElem = (self->m_size ? self->m_size * hkAnyArray::RESERVE_GROWTH_FACTOR : 1);
    if (numElem > hkAnyArray::CAPACITY_MASK)
    {
        HK_FATAL_ERROR(0x0, "Invalid numElem {}", numElem);
    }

    int reqNumBytes;
    if (hkCheckMulSizes(numElem, sizeElem, &reqNumBytes).isFailure())
    {
        HK_FATAL_ERROR(0x0, "Array size overflow {}*{}", numElem, sizeElem);
    }

    if( (self->m_capacityAndFlags & hkAnyArray::DONT_DEALLOCATE_FLAG) == 0)
    {
        self->m_data = static_cast<char*>( mem.bufRealloc( self->m_data, self->getCapacity()*sizeElem, reqNumBytes ) );
    }
    else // mem is not from the mem manager
    {
        char* p = static_cast<char*>(mem.bufAlloc(reqNumBytes));
        memcpy(p, self->m_data, self->m_size*sizeElem);
        self->m_data = p;
    }

    self->m_capacityAndFlags = reqNumBytes / sizeElem;
}

// hack to force this to be out of line
void hkArrayUtil::_reduce(hkMemoryAllocator& mem,
    _Inout_updates_(sizeElem*requestedCapacity) void* array, int sizeElem,
    _Out_writes_bytes_opt_(requestedCapacity*sizeElem) char* inplaceMem, int requestedCapacity)
{
    typedef hkArray<char> hkAnyArray;
    if (requestedCapacity > hkAnyArray::CAPACITY_MASK)
    {
        HK_FATAL_ERROR(0x0, "Invalid requestedCapacity {}", requestedCapacity);
    }
    hkAnyArray* self = reinterpret_cast< hkAnyArray* >(array);
    HK_ASSERT(0x5828d5f1, (self->m_capacityAndFlags & hkAnyArray::DONT_DEALLOCATE_FLAG) == 0, "Don't call _reduce if the array is already optimal or preallocated.");

    if ( (HK_NULL != inplaceMem) && (self->m_size < requestedCapacity) )
    {
        // this is the case of an hkInplaceArray
        memcpy(inplaceMem, self->m_data, self->m_size*sizeElem);
        mem.bufFree( self->m_data, self->getCapacity()*sizeElem);
        self->m_data = inplaceMem;
        self->m_capacityAndFlags = requestedCapacity | hkAnyArray::DONT_DEALLOCATE_FLAG;
    }
    else if( requestedCapacity < self->m_size )
    {
        //precondition: both {m_cap,m_size}*sizeElem fits so reqCapacity*sizeElem is safe.
        int reqNumBytes = requestedCapacity * sizeElem; //
        self->m_data = static_cast<char*>(mem.bufRealloc(self->m_data, self->m_capacityAndFlags*sizeElem, reqNumBytes));
        self->m_capacityAndFlags = reqNumBytes / sizeElem;
    }
    else if( requestedCapacity > self->m_size )
    {
        HK_ASSERT(0x5828d5f1, requestedCapacity < (self->m_capacityAndFlags & hkAnyArray::CAPACITY_MASK), "Invalid reduce call");
    }
}

#ifdef HK_MEMORY_TRACKER_ENABLE
// Force registration of hkArray<Opaque> (for deserialization).

namespace hkReflect {
    template Detail::TypeRegNode ReflectionOf< hkArray< Detail::Opaque, hkContainerHeapAllocator > >::typeRegNode;
    template Detail::TypeRegNode ReflectionOf< hkArray< Detail::Opaque, hkContainerDebugAllocator> >::typeRegNode;
    template Detail::TypeRegNode ReflectionOf< hkArray< Detail::Opaque, hkContainerTempAllocator > >::typeRegNode;
}
#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
