// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0



template <typename T>
T& hkArrayBase<T>::operator[] (_In_range_(0, m_size - 1) int i)
{
    // Implicitly tests for i >= 0
    HK_ASSERT_EXPR(0x394e9c6c, static_cast<unsigned>(i), <, static_cast<unsigned>(m_size) );
    return m_data[i];
}

template <typename T>
const T& hkArrayBase<T>::operator[] (_In_range_(0, m_size - 1) int i) const
{
    // Implicitly tests for i >= 0
    HK_ASSERT_EXPR(0x264718f3, static_cast<unsigned>(i), <, static_cast<unsigned>(m_size));
    return m_data[i];
}

template <typename T>
_Check_return_
T& hkArrayBase<T>::front()
{
    HK_ASSERT_NO_MSG(0x52595f9a, m_size );
    return m_data[ 0 ];
}

template <typename T>
_Check_return_
const T& hkArrayBase<T>::front() const
{
    HK_ASSERT_NO_MSG(0x6e984e35, m_size );
    return m_data[ 0 ];
}

template <typename T>
_Check_return_
T& hkArrayBase<T>::back()
{
    HK_ASSERT_NO_MSG(0x52595f9b, m_size );
    return m_data[ m_size - 1 ];
}

template <typename T>
_Check_return_
const T& hkArrayBase<T>::back() const
{
    HK_ASSERT_NO_MSG(0x6e984e36, m_size );
    return m_data[ m_size -1 ];
}

template <typename T>
_Check_return_
int hkArrayBase<T>::getSize() const
{
    return m_size;
}

template <typename T>
_Check_return_
int hkArrayBase<T>::getCapacity() const
{
    return (m_capacityAndFlags & static_cast<int>(CAPACITY_MASK));
}

template <typename T>
_Check_return_
int hkArrayBase<T>::getCapacityAndFlags() const
{
    return m_capacityAndFlags;
}

template <typename T>
_Check_return_
hkBool hkArrayBase<T>::isEmpty() const
{
    return m_size == 0;
}

template <typename T>
hkResult hkArrayBase<T>::_reserveExactly(_Inout_ hkMemoryAllocator& alloc, _In_range_(>=, 0) int n)
{
    const int capacity = getCapacity();
    if(capacity < n)
    {
        return hkArrayUtil::_reserve(alloc, this, n, sizeof(T));
    }

    return HK_SUCCESS;
}

template <typename T>
hkResult hkArrayBase<T>::_reserve(_Inout_ hkMemoryAllocator& alloc, _In_range_(>=, 0) int n)
{
    const int capacity = getCapacity();
    if( capacity < n)
    {
        HK_COMPILE_TIME_ASSERT((CAPACITY_MASK >> 30) == 0);
        HK_COMPILE_TIME_ASSERT(RESERVE_GROWTH_FACTOR == 2); // doubling ok, capacity has 2 bits free
        int autoCap = RESERVE_GROWTH_FACTOR * capacity;
        int newSize = (n < autoCap) ? autoCap : n;
        return hkArrayUtil::_reserve(alloc, this, newSize, sizeof(T));
    }

    return HK_SUCCESS;
}

template <typename T>
HK_INLINE void hkArrayBase<T>::clear()
{
    hkArrayUtil::destruct(m_data, m_size, typename hkTrait::IsPodType<T>::type());
    m_size = 0;
}



template <typename T>
template <typename U>
void HK_CALL hkArrayBase<T>::copy(_Out_writes_all_(n) T* dst, _In_reads_(n) const U* src, _In_range_(>=, 0) int n)
{
    HK_ASSERT_NO_MSG(0x4543e433, reinterpret_cast<const char*>(dst) <= reinterpret_cast<const char*>(src)
        || reinterpret_cast<const char*>(src + n) <= reinterpret_cast<const char*>(dst));
    for(int i = 0; i < n; ++i)
    {
        dst[i] = src[i];
    }
}



template <typename T>
HK_INLINE hkArrayBase<T>::hkArrayBase()
    :   m_data(HK_NULL),
        m_size(0),
        m_capacityAndFlags(DONT_DEALLOCATE_FLAG)
{
}

template <typename T>
template <typename U>
HK_INLINE void hkArrayBase<T>::populateFromData(
    _In_reads_(size) const U* data,
    _In_range_(>= , 0) int size,
    hkTrait::TypeIsPod, hkTrait::TypeIsPod)
{
    copy(m_data, data, size);
}

template <typename T>
template <typename U, typename TTrait, typename UTrait>
HK_INLINE void hkArrayBase<T>::populateFromData(
    _In_reads_(size) const U* data,
    _In_range_(>= , 0) int size,
    TTrait, UTrait)
{
    int oldSize = m_size;
    int newSize = size;
    int copiedSize = newSize > oldSize ? oldSize : newSize;

    copy(m_data, data, copiedSize);
    hkArrayUtil::constructWithArray(m_data + copiedSize, newSize - copiedSize, data + copiedSize, typename hkTrait::IsPodType<T>::type());
}

template <typename T>
template <typename U>
HK_INLINE hkArrayBase<T>& hkArrayBase<T>::copyFromArray(
    _Inout_ hkMemoryAllocator& alloc,
    _In_reads_(size) const U* data,
    _In_range_(>=, 0) int size)
{
    _reserveExactly(alloc, size);
    hkArrayUtil::destruct(m_data + size, m_size - size, typename hkTrait::IsPodType<T>::type());
    populateFromData(data, size, typename hkTrait::IsPodType<T>::type(), typename hkTrait::IsPodType<U>::type());
    m_size = size;
    return *this;
}

template <typename T>
HK_INLINE hkArrayBase<T>::hkArrayBase(
    _In_count_(capacity) T* ptr,
    _In_range_(0, capacity) int size,
    _In_range_(>=, 0) int capacity)
    :   m_data(ptr),
        m_size(size),
        m_capacityAndFlags(capacity | DONT_DEALLOCATE_FLAG)
{
    HK_ASSERT(0x23483be5, size >= 0 && capacity >= 0, "Array size and capacity must be non-negative." );
    HK_ASSERT(0x4234325a, size <= capacity, "The size must be consistent with the capacity as memory will not be allocated in constructor. Use 'setSize' to allocate memory if inplace capacity too small.");
}

template <typename T>
HK_INLINE hkArrayBase<T>::~hkArrayBase()
{
    HK_ASSERT(0x1129f768, hkTrait::IsPodType<T>::result || m_size==0, "Non-POD array elements not destructed");
    HK_ASSERT(0x1129f769, m_capacityAndFlags&DONT_DEALLOCATE_FLAG, "Array memory not freed");
}

template <typename T>
HK_INLINE void hkArrayBase<T>::_clearAndDeallocate(_Inout_ hkMemoryAllocator& alloc)
{
    clear();
    if( (m_capacityAndFlags & DONT_DEALLOCATE_FLAG) == 0 )
    {
        auto* dataPtr = const_cast<typename hkTrait::RemoveConst<T>::type*>(m_data);
        alloc._bufFree<T>(dataPtr, getCapacity());
    }
    m_data = HK_NULL;
    m_capacityAndFlags = DONT_DEALLOCATE_FLAG;
}

#define HK_COMPUTE_OPTIMIZED_CAPACITY( size, numFreeElemsLeft, shrinkExact ) (shrinkExact) ? (size + numFreeElemsLeft) : hkNextPowerOf2(hkLosslessCast<hkUint32>(size + numFreeElemsLeft))

template <typename T>
HK_INLINE void hkArrayBase<T>::_optimizeCapacity(
    _Inout_ hkMemoryAllocator& alloc,
    _In_range_(>=, 0) int numFreeElemsLeft,
    hkBool32 shrinkExact )
{
    int totalCapacity = HK_COMPUTE_OPTIMIZED_CAPACITY(m_size, numFreeElemsLeft, shrinkExact);
    if ( totalCapacity < getCapacity() )
    {
        hkArrayUtil::_reduce( alloc, this, sizeof(T), HK_NULL, totalCapacity );
    }
}

template <typename T>
HK_INLINE void hkArrayBase<T>::removeAt(_In_range_(0, m_size - 1) int index)
{
    // Implicitly tests for index >= 0
    HK_ASSERT_NO_MSG(0x63bab20a, static_cast<unsigned>(index) < static_cast<unsigned>(m_size));

    hkArrayUtil::destruct(hkMemUtil::addressOf(m_data[index]), 1, typename hkTrait::IsPodType<T>::type());
    m_size--;
    if( m_size != index )
    {
        hkMemUtil::memCpyOneAligned<sizeof(T), HK_ALIGN_OF(T)>( m_data + index, m_data + m_size );
    }
}

template <typename T>
HK_INLINE void hkArrayBase<T>::removeAtAndCopy(_In_range_(0, m_size - 1) int index)
{
    // Implicitly tests for index >= 0
    HK_ASSERT_NO_MSG(0x453a6437, static_cast<unsigned>(index) < static_cast<unsigned>(m_size));

    hkArrayUtil::destruct(hkMemUtil::addressOf(m_data[index]), 1, typename hkTrait::IsPodType<T>::type());
    m_size--;
    hkMemUtil::memCpy<HK_ALIGN_OF(T)>(m_data + index, m_data + index + 1, (m_size-index)*sizeof(T));
}

template <typename T>
HK_INLINE void hkArrayBase<T>::removeAtAndCopy(
    _In_range_(0, m_size - 1) int index,
    _In_range_(1, m_size - index) int numToRemove)
{
    HK_ASSERT_NO_MSG(0x453a6436, numToRemove > 0);
    // Implicitly tests index >= 0
    HK_ASSERT_NO_MSG(0x453a6437, static_cast<unsigned>(index + numToRemove) <= static_cast<unsigned>(m_size) );

    hkArrayUtil::destruct(m_data + index, numToRemove, typename hkTrait::IsPodType<T>::type());
    m_size -= numToRemove;
    hkMemUtil::memCpy<HK_ALIGN_OF(T)>(m_data + index, m_data + index + numToRemove, (m_size-index)*sizeof(T));
}

template <typename T>
_Pre_satisfies_(endIdx < 0 || (startIdx <= endIdx && endIdx <= m_size))
_Check_return_
HK_INLINE int hkArrayBase<T>::indexOf(
    const T& t,
    _In_range_(0, m_size - 1) int startIdx,
    int endIdx) const
{
    if( endIdx < 0 )
    {
        endIdx = m_size;
    }
    for(int i = startIdx; i < endIdx; ++i)
    {
        if( m_data[i] == t )
        {
            return i;
        }
    }
    return -1;
}

template <typename T>
_Check_return_
HK_INLINE int hkArrayBase<T>::lastIndexOf(const T& t) const
{
    for(int i = m_size-1; i >=0; --i)
    {
        if( m_data[i] == t )
        {
            return i;
        }
    }
    return -1;
}

template <typename T>
HK_INLINE void hkArrayBase<T>::popBack(_In_range_(0, m_size) int numToRemove)
{
    HK_ASSERT_NO_MSG(0x5b57310e, m_size >= numToRemove );
    hkArrayUtil::destruct(m_data + m_size - numToRemove, numToRemove, typename hkTrait::IsPodType<T>::type());
    m_size -= numToRemove;
}

template <typename T>
HK_INLINE void hkArrayBase<T>::_ensureHasCapacityForOneMore(_Inout_ hkMemoryAllocator& alloc)
{
    if (m_size == getCapacity())
    {
        hkArrayUtil::_reserveMore(alloc, this, sizeof(T));
    }
    _Analysis_assume_(m_size + 1 < (m_capacityAndFlags & CAPACITY_MASK));
}

template <typename T>
HK_INLINE void hkArrayBase<T>::_pushBack(_Inout_ hkMemoryAllocator& alloc, const T& t)
{
    _ensureHasCapacityForOneMore(alloc);
    hkArrayUtil::constructWithCopy<T>(m_data + m_size, 1, t, typename hkTrait::IsPodType<T>::type());
    ++m_size;
}

template <typename T>
HK_INLINE void hkArrayBase<T>::_emplace(_Inout_ hkMemoryAllocator& alloc, _In_range_(0, m_size) int index)
{
    HK_ASSERT_NO_MSG(0xca65dde2, index >= 0 && index <= getSize());
    const int numToMove = m_size - index;

    _ensureHasCapacityForOneMore(alloc);
    hkMemUtil::memMove(m_data + index + 1, m_data + index, numToMove * sizeof(T));
    ::new (reinterpret_cast<hkPlacementNewArg*>(m_data + index)) T();
    ++m_size;
}


template <typename T>
template <typename T1>
HK_INLINE void hkArrayBase<T>::_emplace(_Inout_ hkMemoryAllocator& alloc, _In_range_(0, m_size) int index, T1&& t1)
{
    HK_ASSERT_NO_MSG(0xca65dde3, index >= 0 && index <= getSize());
    const int numToMove = m_size - index;

    _ensureHasCapacityForOneMore(alloc);
    hkMemUtil::memMove(m_data + index + 1, m_data + index, numToMove * sizeof(T));
    ::new (reinterpret_cast<hkPlacementNewArg*>(m_data + index)) T(
        hk::forward<T1>(t1));
    ++m_size;
}

template <typename T>
template <typename T1, typename T2>
HK_INLINE void hkArrayBase<T>::_emplace(_Inout_ hkMemoryAllocator& alloc, _In_range_(0, m_size) int index, T1&& t1, T2&& t2)
{
    HK_ASSERT_NO_MSG(0xca65dde4, index >= 0 && index <= getSize());
    const int numToMove = m_size - index;

    _ensureHasCapacityForOneMore(alloc);
    hkMemUtil::memMove(m_data + index + 1, m_data + index, numToMove * sizeof(T));
    ::new (reinterpret_cast<hkPlacementNewArg*>(m_data + index)) T(
        hk::forward<T1>(t1),
        hk::forward<T2>(t2));
    ++m_size;
}

template <typename T>
template <typename T1, typename T2, typename T3>
HK_INLINE void hkArrayBase<T>::_emplace(_Inout_ hkMemoryAllocator& alloc, _In_range_(0, m_size) int index, T1&& t1, T2&& t2, T3&& t3)
{
    HK_ASSERT_NO_MSG(0xca65dde5, index >= 0 && index <= getSize());
    const int numToMove = m_size - index;

    _ensureHasCapacityForOneMore(alloc);
    hkMemUtil::memMove(m_data + index + 1, m_data + index, numToMove * sizeof(T));
    ::new (reinterpret_cast<hkPlacementNewArg*>(m_data + index)) T(
        hk::forward<T1>(t1),
        hk::forward<T2>(t2),
        hk::forward<T3>(t3));
    ++m_size;
}

template <typename T>
template <typename T1, typename T2, typename T3, typename T4>
HK_INLINE void hkArrayBase<T>::_emplace(_Inout_ hkMemoryAllocator& alloc, _In_range_(0, m_size) int index, T1&& t1, T2&& t2, T3&& t3, T4&& t4)
{
    HK_ASSERT_NO_MSG(0xca65dde6, index >= 0 && index <= getSize());
    const int numToMove = m_size - index;

    _ensureHasCapacityForOneMore(alloc);
    hkMemUtil::memMove(m_data + index + 1, m_data + index, numToMove * sizeof(T));
    ::new (reinterpret_cast<hkPlacementNewArg*>(m_data + index)) T(
        hk::forward<T1>(t1),
        hk::forward<T2>(t2),
        hk::forward<T3>(t3),
        hk::forward<T4>(t4));
    ++m_size;
}

template <typename T>
template <typename T1, typename T2, typename T3, typename T4, typename T5>
HK_INLINE void hkArrayBase<T>::_emplace(_Inout_ hkMemoryAllocator& alloc, _In_range_(0, m_size) int index, T1&& t1, T2&& t2, T3&& t3, T4&& t4, T5&& t5)
{
    HK_ASSERT_NO_MSG(0xca65dde7, index >= 0 && index <= getSize());
    const int numToMove = m_size - index;

    _ensureHasCapacityForOneMore(alloc);
    hkMemUtil::memMove(m_data + index + 1, m_data + index, numToMove * sizeof(T));
    ::new (reinterpret_cast<hkPlacementNewArg*>(m_data + index)) T(
        hk::forward<T1>(t1),
        hk::forward<T2>(t2),
        hk::forward<T3>(t3),
        hk::forward<T4>(t4),
        hk::forward<T5>(t5));
    ++m_size;
}

template <typename T>
template <typename T1, typename T2, typename T3, typename T4, typename T5, typename T6>
HK_INLINE void hkArrayBase<T>::_emplace(_Inout_ hkMemoryAllocator& alloc, _In_range_(0, m_size) int index, T1&& t1, T2&& t2, T3&& t3, T4&& t4, T5&& t5, T6&& t6)
{
    HK_ASSERT_NO_MSG(0xca65dde7, index >= 0 && index <= getSize());
    const int numToMove = m_size - index;

    _ensureHasCapacityForOneMore(alloc);
    hkMemUtil::memMove(m_data + index + 1, m_data + index, numToMove * sizeof(T));
    ::new (reinterpret_cast<hkPlacementNewArg*>(m_data + index)) T(
        hk::forward<T1>(t1),
        hk::forward<T2>(t2),
        hk::forward<T3>(t3),
        hk::forward<T4>(t4),
        hk::forward<T5>(t5),
        hk::forward<T6>(t6));
    ++m_size;
}


template <typename T>
HK_INLINE void hkArrayBase<T>::_emplaceBack(_Inout_ hkMemoryAllocator& alloc)
{
    _ensureHasCapacityForOneMore(alloc);
    ::new (reinterpret_cast<hkPlacementNewArg*>(m_data + m_size)) T;
    ++m_size;
}

template <typename T>
template <typename T1>
HK_INLINE void hkArrayBase<T>::_emplaceBack(_Inout_ hkMemoryAllocator& alloc, T1&& t1)
{
    _ensureHasCapacityForOneMore(alloc);
    ::new (reinterpret_cast<hkPlacementNewArg*>(m_data + m_size)) T(
        hk::forward<T1>(t1));
    ++m_size;
}

template <typename T>
template <typename T1, typename T2>
HK_INLINE void hkArrayBase<T>::_emplaceBack(_Inout_ hkMemoryAllocator& alloc, T1&& t1, T2&& t2)
{
    _ensureHasCapacityForOneMore(alloc);
    ::new (reinterpret_cast<hkPlacementNewArg*>(m_data + m_size)) T(
        hk::forward<T1>(t1),
        hk::forward<T2>(t2));
    ++m_size;
}

template <typename T>
template <typename T1, typename T2, typename T3>
HK_INLINE void hkArrayBase<T>::_emplaceBack(_Inout_ hkMemoryAllocator& alloc, T1&& t1, T2&& t2, T3&& t3)
{
    _ensureHasCapacityForOneMore(alloc);
    ::new (reinterpret_cast<hkPlacementNewArg*>(m_data + m_size)) T(
        hk::forward<T1>(t1),
        hk::forward<T2>(t2),
        hk::forward<T3>(t3));
    ++m_size;
}

template <typename T>
template <typename T1, typename T2, typename T3, typename T4>
HK_INLINE void hkArrayBase<T>::_emplaceBack(_Inout_ hkMemoryAllocator& alloc, T1&& t1, T2&& t2, T3&& t3, T4&& t4)
{
    _ensureHasCapacityForOneMore(alloc);
    ::new (reinterpret_cast<hkPlacementNewArg*>(m_data + m_size)) T(
        hk::forward<T1>(t1),
        hk::forward<T2>(t2),
        hk::forward<T3>(t3),
        hk::forward<T4>(t4));
    ++m_size;
}

template <typename T>
template <typename T1, typename T2, typename T3, typename T4, typename T5>
HK_INLINE void hkArrayBase<T>::_emplaceBack(_Inout_ hkMemoryAllocator& alloc, T1&& t1, T2&& t2, T3&& t3, T4&& t4, T5&& t5)
{
    _ensureHasCapacityForOneMore(alloc);
    ::new (reinterpret_cast<hkPlacementNewArg*>(m_data + m_size)) T(
        hk::forward<T1>(t1),
        hk::forward<T2>(t2),
        hk::forward<T3>(t3),
        hk::forward<T4>(t4),
        hk::forward<T5>(t5));
    ++m_size;
}

template <typename T>
template <typename T1, typename T2, typename T3, typename T4, typename T5, typename T6>
HK_INLINE void hkArrayBase<T>::_emplaceBack(_Inout_ hkMemoryAllocator& alloc, T1&& t1, T2&& t2, T3&& t3, T4&& t4, T5&& t5, T6&& t6)
{
    _ensureHasCapacityForOneMore(alloc);
    ::new (reinterpret_cast<hkPlacementNewArg*>(m_data + m_size)) T(
        hk::forward<T1>(t1),
        hk::forward<T2>(t2),
        hk::forward<T3>(t3),
        hk::forward<T4>(t4),
        hk::forward<T5>(t5),
        hk::forward<T6>(t6));
    ++m_size;
}

template <typename T>
HK_INLINE void hkArrayBase<T>::pushBackUnchecked(const T& t)
{
    HK_ASSERT_NO_MSG(0x3a2b4abb, m_size < getCapacity());
    hkArrayUtil::constructWithCopy<T>(m_data + m_size, 1, t, typename hkTrait::IsPodType<T>::type());
    m_size++;
}

template <typename T>
HK_INLINE void hkArrayBase<T>::pushBackUncheckedAtomic(const T& t)
{
    HK_ASSERT_NO_MSG(0x3a2b4abb, m_size < getCapacity());
    int i = hkAtomic::exchangeAdd(&m_size, 1);
    hkArrayUtil::constructWithCopy<T>(m_data + i, 1, t, typename hkTrait::IsPodType<T>::type());
}

template <typename T>
_Must_inspect_result_
HK_INLINE hkBool hkArrayBase<T>::tryPushBack(const T& t)
{
    if( m_size < getCapacity() )
    {
        hkArrayUtil::constructWithCopy(m_data + m_size, 1, t, typename hkTrait::IsPodType<T>::type());
        m_size++;
        return true;
    }
    else
    {
        return false;
    }
}

template <typename T>
HK_INLINE void hkArrayBase<T>::_setSize(
    _Inout_ hkMemoryAllocator& alloc,
    _In_range_(>=, 0) int n)
{
    _reserve(alloc, n);
    hkArrayUtil::destruct(m_data + n, m_size - n, typename hkTrait::IsPodType<T>::type());
    hkArrayUtil::construct(m_data + m_size, n - m_size, typename hkTrait::IsPodType<T>::type());
    m_size = n;
}

template <typename T>
HK_INLINE void hkArrayBase<T>::_setSize(
    _Inout_ hkMemoryAllocator& alloc,
    _In_range_(>=, 0) int n,
    const T& fill)
{
    _reserve(alloc, n);
    hkArrayUtil::destruct(m_data + n, m_size - n, typename hkTrait::IsPodType<T>::type());
    hkArrayUtil::constructWithCopy(m_data + m_size, n - m_size, fill, typename hkTrait::IsPodType<T>::type());
    m_size = n;
}

template <typename T>
_Must_inspect_result_
HK_INLINE hkResult hkArrayBase<T>::_trySetSize(
    _Inout_ hkMemoryAllocator& alloc,
    _In_range_(>=, 0) int n)
{
    hkResult res = _reserve(alloc, n);
    if (res.isSuccess())
    {
        hkArrayUtil::destruct(m_data + n, m_size - n, typename hkTrait::IsPodType<T>::type());
        hkArrayUtil::construct(m_data + m_size, n - m_size, typename hkTrait::IsPodType<T>::type());
        m_size = n;
    }
    return res;
}

template <typename T>
_Must_inspect_result_
HK_INLINE hkResult hkArrayBase<T>::_trySetSize(
    _Inout_ hkMemoryAllocator& alloc,
    _In_range_(>=, 0) int n,
    const T& fill)
{
    hkResult res = _reserve(alloc, n);
    if (res.isSuccess())
    {
        hkArrayUtil::destruct(m_data + n, m_size - n, typename hkTrait::IsPodType<T>::type());
        hkArrayUtil::constructWithCopy(m_data + m_size, n - m_size, fill, typename hkTrait::IsPodType<T>::type());
        m_size = n;
    }
    return res;
}

template <typename T>
HK_INLINE void hkArrayBase<T>::setSizeUnchecked(_In_range_(>=, 0) int n)
{
    HK_ASSERT_NO_MSG(0x39192e68, n <= getCapacity());
    hkArrayUtil::destruct(m_data + n, m_size - n, typename hkTrait::IsPodType<T>::type());
    hkArrayUtil::construct(m_data + m_size, n - m_size, typename hkTrait::IsPodType<T>::type());
    m_size = n;
}

template <typename T>
HK_INLINE void hkArrayBase<T>::setSizeUnchecked(_In_range_(>=, 0) int n, _In_ const T& fill)
{
    HK_ASSERT_NO_MSG(0x39192e68, n <= getCapacity());
    hkArrayUtil::destruct(m_data + n, m_size - n, typename hkTrait::IsPodType<T>::type());
    hkArrayUtil::constructWithCopy(m_data + m_size, n - m_size, fill, typename hkTrait::IsPodType<T>::type());
    m_size = n;
}

template <typename T>
HK_INLINE T* hkArrayBase<T>::_expandBy(
    _Inout_ hkMemoryAllocator& alloc,
    _In_range_(>=, 0) int n)
{
    int oldsize = m_size;
    _reserve(alloc, m_size + n);
    hkArrayUtil::construct(m_data + m_size, n, typename hkTrait::IsPodType<T>::type());
    m_size += n;
    return m_data+oldsize;
}

template <typename T>
HK_INLINE T* hkArrayBase<T>::_expandBy(
    _Inout_ hkMemoryAllocator& alloc,
    _In_range_(>=, 0) int n,
    const T& fill)
{
    int oldsize = m_size;
    _reserve(alloc, m_size + n);

    hkArrayUtil::constructWithCopy(m_data + m_size, n, fill, typename hkTrait::IsPodType<T>::type());
    m_size += n;
    return m_data+oldsize;
}

template <typename T>
HK_INLINE T& hkArrayBase<T>::_expandOne(_Inout_ hkMemoryAllocator& alloc)
{
    if( m_size == getCapacity() )
    {
        hkArrayUtil::_reserveMore( alloc, this, sizeof(T) );
    }
    _Analysis_assume_(m_size + 1 < (m_capacityAndFlags & CAPACITY_MASK));

    hkArrayUtil::construct(m_data + m_size, 1, typename hkTrait::IsPodType<T>::type());
    return m_data[m_size++];
}

template <typename T>
HK_INLINE T* hkArrayBase<T>::expandByUnchecked(_In_range_(>=, 0) int n)
{
    HK_ON_DEBUG(const int capacity = getCapacity());
    const int oldsize = m_size;

    HK_ASSERT_NO_MSG(0x5b7a4705, n >= 0 && oldsize + n <= capacity);
    _Analysis_assume_(oldsize <= capacity);
    _Analysis_assume_(oldsize + n <= capacity);

    m_size =  oldsize + n;
    hkArrayUtil::construct(m_data + oldsize, n, typename hkTrait::IsPodType<T>::type());
    return m_data+oldsize;
}

template <typename T>
HK_INLINE T* hkArrayBase<T>::expandByUncheckedAtomic(int n)
{
    HK_ASSERT_NO_MSG(0x5b7a4705, n >= 0 && m_size+n <= getCapacity());
    int oldSize = hkAtomic::exchangeAdd(&m_size, n);
    hkArrayUtil::construct(m_data + oldSize, n, typename hkTrait::IsPodType<T>::type());
    return m_data+oldSize;
}

template <typename T>
HK_INLINE void hkArrayBase<T>::_spliceInto(
    _Inout_ hkMemoryAllocator& alloc,
    _In_range_(0, m_size) int index,
    _In_range_(0, m_size - i) int numdel,
    _In_reads_(numtoinsert) const T* p,
    _In_range_(>=, 0) int numtoinsert)
{
    HK_ASSERT_NO_MSG(0x4cbc67c6, index >= 0 && index <= getSize() );
    HK_ASSERT_NO_MSG(0x4cbc67c7, numdel >= 0 && (index+numdel) <= getSize() );
    const int newsize     = numtoinsert + m_size - numdel;
    const int numtomove   = m_size - index - numdel;
    if( newsize > getCapacity() )
    {
        // note double copy from [i:end] not a problem in practice
        _reserve(alloc, newsize);
    }
    hkArrayUtil::destruct(m_data + index, numdel, typename hkTrait::IsPodType<T>::type());
    hkMemUtil::memMove(m_data + index + numtoinsert, m_data + index + numdel, numtomove*sizeof(T));
    hkArrayUtil::constructWithArray(m_data + index, numtoinsert, p, typename hkTrait::IsPodType<T>::type());
    m_size = newsize;
}

template <typename T>
HK_INLINE void hkArrayBase<T>::_insertAt(
    _Inout_ hkMemoryAllocator& alloc,
    _In_range_(0, m_size) int index,
    _In_reads_(numElems) const T* p,
    _In_range_(>=, 0) int numtoinsert)
{
    _spliceInto(alloc, index, 0, p, numtoinsert);
}

template <typename T>
HK_INLINE void hkArrayBase<T>::_append(
    _Inout_ hkMemoryAllocator& alloc,
    _In_reads_(numtoinsert) const T* a,
    _In_range_(>=, 0) int numtoinsert)
{
    const int newsize = m_size + numtoinsert;
    if(newsize > getCapacity())
    {
        _reserve(alloc, newsize);
    }
    hkArrayUtil::constructWithArray(m_data + m_size, numtoinsert, a, typename hkTrait::IsPodType<T>::type());
    m_size = newsize;
}

template <typename T>
HK_INLINE T* hkArrayBase<T>::_expandAt(
    _Inout_ hkMemoryAllocator& alloc,
    _In_range_(0, m_size) int index,
    _In_range_(>=, 0) int numtoinsert)
{
    // Implicitly tests index >= 0
    HK_ASSERT_NO_MSG(0x2723cc08, static_cast<unsigned>(index) <= static_cast<unsigned>(m_size) );

    const int newsize = numtoinsert + m_size;
    const int numtomove = m_size - index;
    if(newsize > getCapacity())
    {
        // note double copy from [i:end] not a problem in practice
        _reserve(alloc, newsize);
    }
    hkMemUtil::memMove(m_data + index + numtoinsert, m_data + index, numtomove*sizeof(T));
    hkArrayUtil::construct(m_data + index, numtoinsert, typename hkTrait::IsPodType<T>::type());
    m_size = newsize;
    return m_data + index;
}

template <typename T>
HK_INLINE void hkArrayBase<T>::_insertAt(
    _Inout_ hkMemoryAllocator& alloc,
    _In_range_(0, m_size) int i,
    const T& t)
{
    _insertAt(alloc, i, hkMemUtil::addressOf(t), 1 );
}

template <typename T>
HK_INLINE void hkArrayBase<T>::removeAllAndCopy(const T& t)
{
    int destination = 0;
    // Do no copying until we've found a t.
    while ( ( destination < m_size ) && ( m_data[destination] != t ) )
    {
        ++destination;
    }
    // If we have found a t, start copying.
    for ( int source = destination; destination < m_size; ++source )
    {
        if ( m_data[source] != t )
        {
            hkMemUtil::memCpyOneAligned<sizeof(T), HK_ALIGN_OF(T)>( m_data + destination, m_data + source );
            ++destination;
        }
        else
        {
            hkArrayUtil::destruct( m_data + source, 1, typename hkTrait::IsPodType<T>::type() );
            --m_size;
        }
    }
}


template <typename T>
_Check_return_
typename hkArrayBase<T>::iterator hkArrayBase<T>::begin()
{
    return m_data;
}

template <typename T>
_Check_return_
typename hkArrayBase<T>::iterator hkArrayBase<T>::end()
{
    return m_data + m_size;
}

template <typename T>
_Check_return_
typename hkArrayBase<T>::const_iterator hkArrayBase<T>::begin() const
{
    return m_data;
}

template <typename T>
_Check_return_
typename hkArrayBase<T>::const_iterator hkArrayBase<T>::end() const
{
    return m_data + m_size;
}

template <typename T>
HK_INLINE typename hkArrayBase<T>::iterator hkArrayBase<T>::erase(_In_ iterator it)
{
    HK_ASSERT_NO_MSG( 0x63bab20b, ( it >= begin() ) && ( it < end() ) );
    const bool isNotLast = ( it + 1 != end() );
    hkArrayUtil::destruct( hkMemUtil::addressOf( *it ), 1, typename hkTrait::IsPodType<T>::type() );
    m_size--;
    if ( isNotLast )
    {
        hkMemUtil::memCpyOneAligned<sizeof( T ), HK_ALIGN_OF( T )>( it, m_data + m_size );
    }
    return it;
}

template <typename T>
HK_INLINE typename hkArrayBase<T>::iterator hkArrayBase<T>::eraseAndCopy(
    _In_ptrdiff_count_(last) iterator first, _In_ iterator last)
{
    HK_ASSERT_NO_MSG( 0x63bab20c, ( first >= begin() ) && ( first < end() ) );
    HK_ASSERT_NO_MSG( 0x63bab20d, ( last >= begin() ) && ( last <= end() ) );
    const int numToMove = hkLosslessCast<int>( end() - last );
    const int numErased = hkLosslessCast<int>( last - first );
    m_size -= numErased;
    hkArrayUtil::destruct( first, numErased, typename hkTrait::IsPodType<T>::type() );
    if ( numToMove > 0 )
    {
        hkMemUtil::memMove( first, last, numToMove * sizeof( T ) );
        return first;
    }
    return end();
}

template <typename T>
void hkArrayBase<T>::_setDataUnchecked(
    _In_count_(capacityAndFlags & CAPACITY_MASK) T *ptr,
    _In_range_(0, capacityAndFlags & CAPACITY_MASK) int size,
    int capacityAndFlags)
{
    m_data = ptr;
    m_size = size;
    m_capacityAndFlags = capacityAndFlags;
}

template <typename T>
void hkArrayBase<T>::_setData(
    _In_count_(capacityAndFlags & CAPACITY_MASK) T *ptr,
    _In_range_(0, capacityAndFlags & CAPACITY_MASK) int size,
    int capacityAndFlags,
    hkTrait::TypeIsPod)
{
    hkArrayBase<T>::_setDataUnchecked(ptr, size, capacityAndFlags);
}

// template <typename T>
// void hkArrayBase<T>::_setData(T *ptr, int size, int capacityAndFlags, hkTypeIsClass)
// {
//  HK_ASSERT(0x6335ef93, 0, "setOwnedData can only be called on POD types");
// }

template <typename T>
void hkArrayBase<T>::setDataAutoFree(_In_count_(capacity) T* ptr, _In_range_(0, capacity) int size, _In_range_(>=, 0) int capacity)
{
    HK_ASSERT_NO_MSG(0x23483be5, size >= 0 );
    HK_ASSERT_NO_MSG(0x23483be5, size <= capacity);
    hkArrayBase<T>::_setData(ptr, size, capacity, typename hkTrait::IsPodType<T>::type());
}

template <typename T>
void hkArrayBase<T>::setDataUserFree(_In_count_(capacity) T *ptr, _In_range_(0, capacity) int size, _In_range_(>=, 0) int capacity)
{
    HK_ASSERT_NO_MSG(0x23483be5, size >= 0 );
    HK_ASSERT_NO_MSG(0x23483be5, size <= capacity);
    const int capacityAndFlags = capacity | DONT_DEALLOCATE_FLAG;
    _Analysis_assume_((capacityAndFlags & CAPACITY_MASK) == capacity);
    hkArrayBase<T>::_setData(ptr, size, capacityAndFlags, typename hkTrait::IsPodType<typename hkTrait::RemoveConst<T>::type>::type());
}

template <typename T>
template <typename U>
hkArrayBase<T>::operator hkArrayView<U>() const
{
    // Trust implicit conversion of hkArrayView<T> => hkArrayView<U>.
    return hkArrayView<T>(m_data, m_size);
}

template <typename T>
_Check_return_
hkArrayView<T> hkArrayBase<T>::view()
{
    return static_cast< hkArrayView<T> >(*this);
}

template <typename T>
_Check_return_
hkArrayView<const T> hkArrayBase<T>::view() const
{
    return static_cast< hkArrayView<const T> >(*this);
}

//
// hkArray
//

template <typename T, typename Allocator>
HK_INLINE hkArray<T,Allocator>::~hkArray()
{
    clearAndDeallocate();
}

template <typename T>
HK_INLINE void hkArrayBase<T>::_reserveInitial(_Inout_ hkMemoryAllocator& a, _In_range_(>=, 0) int n)
{
    const int size = n;
    T* p = n ? a._bufAlloc<T>(n) : HK_NULL;
    int cap = n ? n : hkArrayBase<T>::DONT_DEALLOCATE_FLAG;
    hkArrayBase<T>::_setDataUnchecked(p, size, cap);
}

template <typename T, typename Allocator>
HK_INLINE hkArray<T,Allocator>::hkArray(_In_range_(>=, 0) int n)
: hkArrayBase<T>()
{
    hkArrayBase<T>::_reserveInitial(Allocator().get(this), n);
    hkArrayUtil::construct(this->m_data, n, typename hkTrait::IsPodType<T>::type());
}

template <typename T, typename Allocator>
HK_INLINE hkArray<T,Allocator>::hkArray(_In_range_(>=, 0) int n, const T& t)
: hkArrayBase<T>()
{
    hkArrayBase<T>::_reserveInitial(Allocator().get(this), n);
    hkArrayUtil::constructWithCopy(this->m_data, n, t, typename hkTrait::IsPodType<T>::type());
}

template <typename T, typename Allocator>
template<typename Container>
HK_INLINE hkArray<T, Allocator>::hkArray(const Container& arr, typename hkTrait::EnableIf<hkArrayDetail::HasContainerAPI<Container>::result, Container>::Type*)
    : hkArrayBase<T>()
{
    const int n = arr.getSize();
    hkArrayBase<T>::_reserveInitial(Allocator().get(this), n);
    hkArrayUtil::constructWithArray(this->m_data, n, arr.begin(), typename hkTrait::IsPodType<T>::type());
}

template <typename T, typename Allocator>
HK_INLINE hkArray<T, Allocator>::hkArray(const hkArray<T, Allocator>& arr)
    : hkArrayBase<T>()
{
    const int n = arr.getSize();
    hkArrayBase<T>::_reserveInitial(Allocator().get(this), n);
    hkArrayUtil::constructWithArray(this->m_data, n, arr.begin(), typename hkTrait::IsPodType<T>::type());
}

template <typename T, typename Allocator>
HK_INLINE hkArray<T, Allocator>& hkArray<T, Allocator>::operator= (const hkArray<T, Allocator>& arr)
{
    hkArrayBase<T>::copyFromArray(Allocator().get(this), arr.begin(), arr.getSize());
    return *this;
}

template <typename T, typename Allocator>
template <typename Container>
HK_INLINE typename hkTrait::EnableIf<hkArrayDetail::HasContainerAPI<Container>::result, hkArray<T, Allocator>&>::Type hkArray<T, Allocator>::operator= (const Container& a)
{
    hkArrayBase<T>::copyFromArray(Allocator().get(this), a.begin(), a.getSize());
    return *this;
}

template <typename T, typename Allocator>
HK_INLINE void hkArray<T,Allocator>::swap(_Inout_ hkArray<T,Allocator>& a)
{
    HK_ASSERT_NO_MSG( 0xf032e612, 0==(hkArrayBase<T>::m_capacityAndFlags&hkArrayBase<T>::DONT_DEALLOCATE_FLAG) || hkArrayBase<T>::m_data == HK_NULL );
    HK_ASSERT_NO_MSG( 0xf032e613, 0==(a.m_capacityAndFlags&hkArrayBase<T>::DONT_DEALLOCATE_FLAG) || a.m_data == HK_NULL );

    T* d = hkArrayBase<T>::m_data; // swap data
    hkArrayBase<T>::m_data = a.m_data;
    a.m_data = d;
    int s = hkArrayBase<T>::m_size; // swap size
    hkArrayBase<T>::m_size = a.m_size;
    a.m_size = s;
    int c = hkArrayBase<T>::m_capacityAndFlags; // swap cap
    hkArrayBase<T>::m_capacityAndFlags = a.m_capacityAndFlags;
    a.m_capacityAndFlags = c;
}

template <typename T, typename Allocator>
HK_INLINE T& hkArray<T, Allocator>::emplace(_In_range_(0, m_size) int index)
{
    hkArrayBase<T>::_emplace(Allocator().get(this), index);
    return hkArrayBase<T>::m_data[index];
}

template <typename T, typename Allocator>
template <typename T1>
HK_INLINE T& hkArray<T, Allocator>::emplace(_In_range_(0, m_size) int index, T1&& t1)
{
    hkArrayBase<T>::_emplace(Allocator().get(this),
        index,
        hk::forward<T1>(t1));
    return hkArrayBase<T>::m_data[index];
}

template <typename T, typename Allocator>
template <typename T1, typename T2>
HK_INLINE T& hkArray<T, Allocator>::emplace(_In_range_(0, m_size) int index, T1&& t1, T2&& t2)
{
    hkArrayBase<T>::_emplace(Allocator().get(this),
        index,
        hk::forward<T1>(t1),
        hk::forward<T2>(t2));
    return hkArrayBase<T>::m_data[index];
}

template <typename T, typename Allocator>
template <typename T1, typename T2, typename T3>
HK_INLINE T& hkArray<T, Allocator>::emplace(_In_range_(0, m_size) int index, T1&& t1, T2&& t2, T3&& t3)
{
    hkArrayBase<T>::_emplace(Allocator().get(this),
        index,
        hk::forward<T1>(t1),
        hk::forward<T2>(t2),
        hk::forward<T3>(t3));
    return hkArrayBase<T>::m_data[index];
}

template <typename T, typename Allocator>
template <typename T1, typename T2, typename T3, typename T4>
HK_INLINE T& hkArray<T, Allocator>::emplace(_In_range_(0, m_size) int index, T1&& t1, T2&& t2, T3&& t3, T4&& t4)
{
    hkArrayBase<T>::_emplace(Allocator().get(this),
        index,
        hk::forward<T1>(t1),
        hk::forward<T2>(t2),
        hk::forward<T3>(t3),
        hk::forward<T4>(t4));
    return hkArrayBase<T>::m_data[index];
}

template <typename T, typename Allocator>
template <typename T1, typename T2, typename T3, typename T4, typename T5>
HK_INLINE T& hkArray<T, Allocator>::emplace(_In_range_(0, m_size) int index, T1&& t1, T2&& t2, T3&& t3, T4&& t4, T5&& t5)
{
    hkArrayBase<T>::_emplace(Allocator().get(this),
        index,
        hk::forward<T1>(t1),
        hk::forward<T2>(t2),
        hk::forward<T3>(t3),
        hk::forward<T4>(t4),
        hk::forward<T5>(t5));
    return hkArrayBase<T>::m_data[index];
}

template <typename T, typename Allocator>
template <typename T1, typename T2, typename T3, typename T4, typename T5, typename T6>
HK_INLINE T& hkArray<T, Allocator>::emplace(_In_range_(0, m_size) int index, T1&& t1, T2&& t2, T3&& t3, T4&& t4, T5&& t5, T6&& t6)
{
    hkArrayBase<T>::_emplace(Allocator().get(this),
        index,
        hk::forward<T1>(t1),
        hk::forward<T2>(t2),
        hk::forward<T3>(t3),
        hk::forward<T4>(t4),
        hk::forward<T5>(t5),
        hk::forward<T6>(t6));
    return hkArrayBase<T>::m_data[index];
}

template <typename T, typename Allocator>
HK_INLINE T& hkArray<T, Allocator>::emplaceBack()
{
    hkArrayBase<T>::_emplaceBack(Allocator().get(this));
    return this->back();
}

template <typename T, typename Allocator>
template <typename T1>
HK_INLINE T& hkArray<T, Allocator>::emplaceBack(T1&& t1)
{
    hkArrayBase<T>::_emplaceBack(Allocator().get(this),
        hk::forward<T1>(t1));
    return this->back();
}

template <typename T, typename Allocator>
template <typename T1, typename T2>
HK_INLINE T& hkArray<T, Allocator>::emplaceBack(T1&& t1, T2&& t2)
{
    hkArrayBase<T>::_emplaceBack(Allocator().get(this),
        hk::forward<T1>(t1),
        hk::forward<T2>(t2));
    return this->back();
}

template <typename T, typename Allocator>
template <typename T1, typename T2, typename T3>
HK_INLINE T& hkArray<T, Allocator>::emplaceBack(T1&& t1, T2&& t2, T3&& t3)
{
    hkArrayBase<T>::_emplaceBack(Allocator().get(this),
        hk::forward<T1>(t1),
        hk::forward<T2>(t2),
        hk::forward<T3>(t3));
    return this->back();
}

template <typename T, typename Allocator>
template <typename T1, typename T2, typename T3, typename T4>
HK_INLINE T& hkArray<T, Allocator>::emplaceBack(T1&& t1, T2&& t2, T3&& t3, T4&& t4)
{
    hkArrayBase<T>::_emplaceBack(Allocator().get(this),
        hk::forward<T1>(t1),
        hk::forward<T2>(t2),
        hk::forward<T3>(t3),
        hk::forward<T4>(t4));
    return this->back();
}

template <typename T, typename Allocator>
template <typename T1, typename T2, typename T3, typename T4, typename T5>
HK_INLINE T& hkArray<T, Allocator>::emplaceBack(T1&& t1, T2&& t2, T3&& t3, T4&& t4, T5&& t5)
{
    hkArrayBase<T>::_emplaceBack(Allocator().get(this),
        hk::forward<T1>(t1),
        hk::forward<T2>(t2),
        hk::forward<T3>(t3),
        hk::forward<T4>(t4),
        hk::forward<T5>(t5));
    return this->back();
}

template <typename T, typename Allocator>
template <typename T1, typename T2, typename T3, typename T4, typename T5, typename T6>
HK_INLINE T& hkArray<T, Allocator>::emplaceBack(T1&& t1, T2&& t2, T3&& t3, T4&& t4, T5&& t5, T6&& t6)
{
    hkArrayBase<T>::_emplaceBack(Allocator().get( this ),
        hk::forward<T1>(t1),
        hk::forward<T2>(t2),
        hk::forward<T3>(t3),
        hk::forward<T4>(t4),
        hk::forward<T5>(t5),
        hk::forward<T6>(t6));
    return this->back();
}

//
// Inplace array
//

#ifdef HK_DEBUG
#define HK_INPLACE_ARRAY_ALIGNMENT_CHECK() \
    static const int alignment = HK_ALIGN_OF(T); \
    HK_ASSERT_NO_MSG(0x50f11f10, (reinterpret_cast<hkUlong>(m_storage.get()) & (alignment-1)) == 0);
#else
#define HK_INPLACE_ARRAY_ALIGNMENT_CHECK()
#endif

template <typename T, unsigned N, typename Allocator>
HK_INLINE hkInplaceArray<T,N,Allocator>::hkInplaceArray()
    : hkArray<T,Allocator>(reinterpret_cast<T*>(&m_storage), 0, N)
{
    HK_INPLACE_ARRAY_ALIGNMENT_CHECK();
}

template <typename T, unsigned N, typename Allocator>
HK_INLINE hkInplaceArray<T,N,Allocator>::hkInplaceArray(_In_range_(>=, 0) int size)
    : hkArray<T,Allocator>(reinterpret_cast<T*>(&m_storage), 0, N)
{
    this->setSize(size);
    HK_INPLACE_ARRAY_ALIGNMENT_CHECK();
}

template <typename T, unsigned N, typename Allocator>
HK_INLINE hkInplaceArray<T,N,Allocator>::hkInplaceArray(const hkInplaceArray<T,N,Allocator>& a)
    : hkArray<T,Allocator>(reinterpret_cast<T*>(&m_storage), 0, N)
{
    *this = a;
    HK_INPLACE_ARRAY_ALIGNMENT_CHECK();
}


template <typename T, unsigned N, typename Allocator>
HK_INLINE hkInplaceArray<T,N,Allocator>::hkInplaceArray( const hkArrayBase<T>& a )
    : hkArray<T, Allocator>(reinterpret_cast<T*>(&m_storage), 0, N)
{
    *this = a;
    HK_INPLACE_ARRAY_ALIGNMENT_CHECK();
}

template <typename T, unsigned N, typename Allocator>
HK_INLINE hkInplaceArray<T,N,Allocator>::hkInplaceArray( hkArrayView<const T> a )
    : hkArray<T, Allocator>(reinterpret_cast<T*>(&m_storage), 0, N)
{
    *this = a;
    HK_INPLACE_ARRAY_ALIGNMENT_CHECK();
}

template <typename T, unsigned N, typename Allocator>
HK_INLINE void hkInplaceArray<T, N, Allocator>::optimizeCapacity(_In_range_(>=, 0) int numFreeElemsLeft, hkBool32 shrinkExact)
{
    if( (this->m_capacityAndFlags & hkArray<T,Allocator>::DONT_DEALLOCATE_FLAG) == 0)
    {
        int totalCapacity = HK_COMPUTE_OPTIMIZED_CAPACITY(this->m_size, numFreeElemsLeft, shrinkExact);
        if( totalCapacity < int(N) )
        {
            // reducing to a capacity < N, we can copy back to local storage
            hkArrayUtil::_reduce( typename hkArray<T,Allocator>::allocator_type().get(this), this, sizeof(T), (char*)(m_storage.get()), N );
        }
        else if( totalCapacity < this->getCapacity() )
        {
            hkArrayUtil::_reduce( typename hkArray<T,Allocator>::allocator_type().get(this), this, sizeof(T), HK_NULL, totalCapacity );
        }
    }
}

template <typename T, unsigned N, typename Allocator>
hkArray<T,Allocator>& hkInplaceArray<T,N,Allocator>::operator= (const hkArrayBase<T>& a)
{
    return hkArray<T,Allocator>::operator=(a);
}

template <typename T, unsigned N, typename Allocator>
hkArray<T,Allocator>& hkInplaceArray<T,N,Allocator>::operator= (const hkInplaceArray<T,N,Allocator>& a)
{
    return hkArray<T,Allocator>::operator=(a);
}

template <typename T, unsigned N, typename Allocator>
hkArray<T, Allocator>& hkInplaceArray<T,N,Allocator>::operator=(hkArrayView<const T> a)
{
    return hkArray<T, Allocator>::operator=(a);
}

template <typename T, unsigned N, typename Allocator>
_Check_return_
hkBool hkInplaceArray<T,N,Allocator>::wasReallocated() const
{
    return this->m_data != m_storage.get();
}

template <typename T, unsigned N, typename Allocator>
_Check_return_
int hkInplaceArray<T,N,Allocator>::stillInplaceUsingMask() const
{
    return hkArray<T,Allocator>::m_capacityAndFlags & hkArrayBase<T>::DONT_DEALLOCATE_FLAG;
}

//
// Inplace array 16
//

template <typename T, unsigned N, typename Allocator>
hkArray<T>& hkInplaceArrayAligned16<T,N, Allocator>::operator= (const hkArrayBase<T>& a)
{
    return hkArray<T, Allocator>::operator=(a);
}

template <typename T, unsigned N, typename Allocator>
_Check_return_
hkBool hkInplaceArrayAligned16<T,N, Allocator>::wasReallocated() const
{
    return hkUlong(this->m_data) != hkUlong(m_storage);
}

template <typename T, unsigned N, typename Allocator>
hkArray<T>& hkInplaceArrayAligned16<T,N, Allocator>::operator= (const hkInplaceArrayAligned16<T,N>& a)
{
    return hkArray<T, Allocator>::operator=(a);
}

template <typename T, unsigned N, typename Allocator>
HK_INLINE hkInplaceArrayAligned16<T,N, Allocator>::hkInplaceArrayAligned16(int size)
    : hkArray<T, Allocator>( (T*)&m_storage[0], size, N)
{
}

template <typename T, unsigned N, typename Allocator>
_Check_return_
int hkInplaceArrayAligned16<T,N, Allocator>::stillInplaceUsingMask() const
{
    return hkArray<T>::m_capacityAndFlags & hkArrayBase<T>::DONT_DEALLOCATE_FLAG;
}
#undef HK_COMPUTE_OPTIMIZED_CAPACITY

namespace hkReflect
{
    namespace Tracker
    {
#if defined(HK_MEMORY_TRACKER_ENABLE)
        HK_EXPORT_COMMON void HK_CALL hkArrayHandlerInternal(const hkReflect::Var& var, hkMemoryTrackerSnapshot& snapshot, int elemSize);

        template <int ELEM_SIZE>
        struct hkArrayHandlerHelper
        {
            static void HK_CALL func(const hkReflect::Var& var, hkMemoryTrackerSnapshot& snapshot)
            {
                hkArrayHandlerInternal(var, snapshot, ELEM_SIZE);
            }
        };

        template <>
        struct hkArrayHandlerHelper<0>
        {
            static void HK_CALL func(const hkReflect::Var& var, hkMemoryTrackerSnapshot& snapshot) {}
        };

        // The Type of T might not have a size opt so we take it from the template argument.
        // Note: this requires the definition of T to be visible to the memory tracker reflection. If this line causes
        // a compile error, apply hk::MemoryTracker(opaque=true) to the hkArray field which is causing the instantiation.
        template <typename T, typename A>
        struct hkArrayHandler : public hkArrayHandlerHelper< hkContainerAllocatorIsTracked<A>::result ? sizeof(T) : 0 > {};
#else
        template <typename T, typename A>
        struct hkArrayHandler { static void HK_CALL func(const hkReflect::Var& var, hkMemoryTrackerSnapshot& snapshot) {} };
#endif
    }

#if defined(HK_MEMORY_TRACKER_ENABLE)
    template< typename T, typename A >
    struct ReflectionOf< Detail::MarkAsOpaque< hkArray<T, A> > >
        : public ReflectionOf< hkArray< Detail::Opaqueize<T>, A > > {};

    namespace Detail
    {
        template <>
        struct HK_EXPORT_COMMON HandleHelper< hkArray<void*> >
        {
            static const hkUint16 trackerHandle;
            static const TrackerRegNode trackerRegNode;
        };
        template <typename T>
        struct HandleHelper< hkArray<T*> > : public HandleHelper< hkArray<void*> > {};
    }
#else
    template< typename T, typename A >
    struct ReflectionOf< Detail::MarkAsOpaque< hkArray<T, A> > > : public ReflectionOf < hkArray< Detail::Opaque, A > >
    {
    };
#endif
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
