// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/Config/hkProductFeatures.h>
#include <Common/Base/Reflect/Version/hkReflectPatchRegistry.h>
#include <Common/Compat/hkHavokVersions.h>
#include <Common/Base/Config/hkOptionalComponent.h>
#include <Common/Base/Reflect/Version/hkPatchesRegNode.h>
#include <Common/Base/Serialize/Format/Compat/hkCompatFormats.h>
#include <Common/Base/Object/hkSingleton.h>

#if defined(HK_REGISTER_PATCHES_CHANGED_FEATURES)
#   error hkRegisterPatches.cxx should not be included before hkProductFeatures.cxx in the same file as it changes the product set
#endif

// Disable unused serialization features for security reasons.
#if defined(HK_NONSDK_BUILD)

#   define HK_EXCLUDE_FEATURE_CompatFormats
#   define HK_EXCLUDE_FEATURE_hkReadFormatXmlTagfile


//#   define HK_EXCLUDE_FEATURE_RegisterVersionPatches
//#   define HK_EXCLUDE_LIBRARY_hkCompat
//#   define HK_EXCLUDE_FEATURE_hkFormatYamlFile

#endif

// HK_SERIALIZE_MIN_COMPATIBLE_VERSION can be used to define which is the oldest
// compatible version of Havok assets. Removing compatibility with older versions
// that will never be used in a given project can cause a significant code size
// reduction. The list of supported versions is given in
// Common/Compat/Deprecated/Compat/hkCompatVersions.h.
// The minimum compatible version is specified using just the release number:
// to have compatibility at most with version 650b1 the user should use
// #define HK_SERIALIZE_MIN_COMPATIBLE_VERSION 650b1.
#ifndef HK_SERIALIZE_MIN_COMPATIBLE_VERSION
// If HK_SERIALIZE_MIN_COMPATIBLE_VERSION is not defined, use all versions (300 being the first Havok version).
#   if defined(HK_SERIALIZE_LATEST_VERSION_ONLY)
#       define HK_SERIALIZE_MIN_COMPATIBLE_VERSION_INTERNAL_VALUE (HK_HAVOK_VERSION_Current - 1)
#   else
#       define HK_SERIALIZE_MIN_COMPATIBLE_VERSION_INTERNAL_VALUE HK_HAVOK_VERSION_300
#   endif
#else
#   define HK_SERIALIZE_MIN_COMPATIBLE_VERSION_INTERNAL_VALUE HK_HAVOK_VERSION(HK_SERIALIZE_MIN_COMPATIBLE_VERSION)
#endif

#if !defined(HK_EXCLUDE_FEATURE_RegisterVersionPatches)
#   define HK_REGISTER_PATCHES_FROM_KEYCODES
#   include <Common/Compat/Patches/hkRegisterPatches.cxx>
#   undef HK_REGISTER_PATCHES_FROM_KEYCODES
#endif

#if defined(HK_REGISTER_CLASS_PREFIX)
#   define REGISTER_NAME__(x) x##registerClasses
#   define REGISTER_NAME(x) REGISTER_NAME__(x)
    hkUlong HK_CALL REGISTER_NAME(HK_REGISTER_CLASS_PREFIX)();
#else
    hkUlong HK_CALL registerClasses();
#endif

// Automatically exclude hkReadFormatBinaryTagfile2014 if:
//  - HK_EXCLUDE_FEATURE_CompatFormats already defined, or
//  - HK_SERIALIZE_MIN_COMPATIBLE_VERSION_INTERNAL_VALUE high enough
// Automatically exclude CompatFormats (all other legacy formats) if:
//  - Not supported on this platform, or
//  - HK_SERIALIZE_MIN_COMPATIBLE_VERSION_INTERNAL_VALUE high enough
#if defined(HK_EXCLUDE_FEATURE_CompatFormats)
#   define HK_EXCLUDE_FEATURE_hkReadFormatBinaryTagfile2014
#elif HK_SERIALIZE_MIN_COMPATIBLE_VERSION_INTERNAL_VALUE > HK_HAVOK_VERSION_201420r1
#   define HK_EXCLUDE_FEATURE_CompatFormats
#   define HK_EXCLUDE_FEATURE_hkReadFormatBinaryTagfile2014
#elif !defined(HK_PLATFORM_WIN32) || defined(HK_PLATFORM_WINRT) || defined(HK_PLATFORM_DURANGO)
#   define HK_EXCLUDE_FEATURE_CompatFormats
#endif

#if !defined(HK_EXCLUDE_FEATURE_CompatFormats) && (!defined(HK_DYNAMIC_DLL) || HK_DLL_BUILD == HK_COMMON_BUILD)
    HK_SINGLETON_IMPLEMENTATION(hkCompatFormats);
#elif !defined(HK_DYNAMIC_DLL)
    // Implement it but set it to null, any attempt to use it will fail
    HK_SINGLETON_MANUAL_IMPLEMENTATION(hkCompatFormats, HK_NULL, &hkSingletonUtil::quit<hkCompatFormats>);
#endif

namespace HK_UNITY_ANONYMOUS_NAMESPACE
{
    hkBool hkProductFeatures_initialized = false;
}

void HK_CALL hkProductFeatures::initialize()
{
    HK_UNITY_USING_ANONYMOUS_NAMESPACE;
    if (hkProductFeatures_initialized)
    {
        return;
    }
    hkProductFeatures_initialized = true;

//
// Common
//

// Versioning
#if !defined(HK_EXCLUDE_FEATURE_RegisterVersionPatches)
    HK_OPTIONAL_COMPONENT_REQUEST(hkPatcher);
#endif
#if !defined(HK_EXCLUDE_LIBRARY_hkCompat)
    HK_OPTIONAL_COMPONENT_REQUEST(hkCompatPatcher);
#endif

// Legacy file formats
#if !defined(HK_EXCLUDE_FEATURE_hkReadFormatBinaryTagfile2014)
    HK_OPTIONAL_COMPONENT_REQUEST(hkReadFormatBinaryTagfile2014);
#endif
#if !defined(HK_EXCLUDE_FEATURE_CompatFormats)
    HK_OPTIONAL_COMPONENT_REQUEST(hkReadFormatBinaryPackfile2014);
    HK_OPTIONAL_COMPONENT_REQUEST(hkReadFormatXmlTagfile2014);
    HK_OPTIONAL_COMPONENT_REQUEST(hkReadFormatXmlPackfile2010);
#endif

// Binary tagfile format    
#if !defined(HK_EXCLUDE_FEATURE_hkFormatBinaryTagfile)
#   if !defined(HK_EXCLUDE_FEATURE_hkReadFormatBinaryTagfile)
        HK_OPTIONAL_COMPONENT_REQUEST(hkReadFormatBinaryTagfile);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkWriteFormatBinaryTagfile)
        HK_OPTIONAL_COMPONENT_REQUEST(hkWriteFormatBinaryTagfile);
#   endif
#endif

// XML tagfile format
#if !defined(HK_EXCLUDE_FEATURE_hkFormatXmlTagfile)
#   if !defined(HK_EXCLUDE_FEATURE_hkReadFormatXmlTagfile)
        HK_OPTIONAL_COMPONENT_REQUEST(hkReadFormatXmlTagfile);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkWriteFormatXmlTagfile)
        HK_OPTIONAL_COMPONENT_REQUEST(hkWriteFormatXmlTagfile);
#   endif
#endif

#if defined(HK_BUILDING_WITH_ENGINE) && !defined(HK_DYNAMIC_DLL)

    // YAML file format
    #if !defined(HK_EXCLUDE_FEATURE_hkFormatYamlFile)
    #   if !defined(HK_EXCLUDE_FEATURE_hkReadFormatYamlFile)
            HK_OPTIONAL_COMPONENT_REQUEST(hkReadFormatYamlFile);
    #   endif
    #   if !defined(HK_EXCLUDE_FEATURE_hkWriteFormatYamlFile)
            HK_OPTIONAL_COMPONENT_REQUEST(hkWriteFormatYamlFile);
    #   endif
    #endif

    // Compressed tagfile format
    #if !defined(HK_EXCLUDE_FEATURE_hkFormatCompressedTagfile)
    #   if !defined(HK_EXCLUDE_FEATURE_hkReadFormatCompressedTagfile)
            HK_OPTIONAL_COMPONENT_REQUEST(hkReadFormatCompressedTagfile);
    #   endif
    #   if !defined(HK_EXCLUDE_FEATURE_hkWriteFormatCompressedTagfile)
            HK_OPTIONAL_COMPONENT_REQUEST(hkWriteFormatCompressedTagfile);
    #   endif
    #endif

#endif

//
// Physics
//
#ifdef HK_FEATURE_PRODUCT_PHYSICS
#   if !defined(HK_EXCLUDE_FEATURE_PhysicsRuntime)
#       if !defined(HK_EXCLUDE_FEATURE_hknpHybridBroadPhase)
            HK_OPTIONAL_COMPONENT_REQUEST(hknpOptionalComponent_HybridBroadPhase);
#       endif
#       if !defined(HK_EXCLUDE_FEATURE_hknpWideBroadPhase)
            HK_OPTIONAL_COMPONENT_REQUEST(hknpOptionalComponent_WideBroadPhase);
#       endif
#   endif
#endif

//
// Physics2012
//
#ifdef HK_FEATURE_PRODUCT_PHYSICS_2012
    #if !defined(HK_EXCLUDE_FEATURE_Physics2012Runtime)
        #if !defined(HK_EXCLUDE_FEATURE_hkpHeightField)
            HK_OPTIONAL_COMPONENT_REQUEST(hkpHeightFieldAgent);
        #endif

        #if !defined(HK_EXCLUDE_FEATURE_hkpSimulation)
            HK_OPTIONAL_COMPONENT_REQUEST(hkpSimulation);
        #endif

        #if !defined(HK_EXCLUDE_FEATURE_hkpContinuousSimulation)
            HK_OPTIONAL_COMPONENT_REQUEST(hkpContinuousSimulation);
        #endif

        #if (HK_CONFIG_THREAD != HK_CONFIG_SINGLE_THREADED)
            #if !defined(HK_EXCLUDE_FEATURE_hkpMultiThreadedSimulation)
                HK_OPTIONAL_COMPONENT_REQUEST(hkpMultiThreadedSimulation);
            #endif
        #endif

        #if !defined(HK_EXCLUDE_FEATURE_hkpAccurateInertiaTensorComputer)
            HK_OPTIONAL_COMPONENT_REQUEST(hkpAccurateInertiaTensorComputer);
        #endif

        #if !defined(HK_EXCLUDE_FEATURE_hkp3AxisSweep)
            HK_OPTIONAL_COMPONENT_REQUEST(hkp3AxisSweep);
        #endif

        #if !defined(HK_EXCLUDE_FEATURE_hkpTreeBroadPhase)
            HK_OPTIONAL_COMPONENT_REQUEST(hkpTreeBroadPhase);
        #endif

        #if !defined(HK_EXCLUDE_FEATURE_hkpTreeBroadPhase32)
            HK_OPTIONAL_COMPONENT_REQUEST(hkpTreeBroadPhase32);
        #endif

        #if defined(HK_EXCLUDE_FEATURE_hkpSampledHeightFieldDdaRayCast) && defined (HK_EXCLUDE_FEATURE_hkpSampledHeightFieldCoarseTreeRayCast)
            // Do nothing, the function pointers are set to null.
        #elif defined(HK_EXCLUDE_FEATURE_hkpSampledHeightFieldDdaRayCast)
            HK_OPTIONAL_COMPONENT_REQUEST(hkpSampledHeightFieldShape_CoarseCast);
        #elif defined(HK_EXCLUDE_FEATURE_hkpSampledHeightFieldCoarseTreeRayCast)
            HK_OPTIONAL_COMPONENT_REQUEST(hkpSampledHeightFieldShape_DdaCast);
        #else
            HK_OPTIONAL_COMPONENT_REQUEST(hkpSampledHeightField_AllCasts);
        #endif
    #endif
#endif // HK_FEATURE_PRODUCT_PHYSICS_2012

//
// Destruction2012
//
#if defined(HK_FEATURE_PRODUCT_DESTRUCTION_2012) && !defined(HK_EXCLUDE_FEATURE_DestructionRuntime)
    extern void HK_CALL registerDestructionRuntime();
    registerDestructionRuntime();
#endif

//
// Destruction
//

#if defined(HK_FEATURE_PRODUCT_DESTRUCTION)
#   if defined(HK_EXCLUDE_FEATURE_hkndAssetProcessing)
#       define HK_EXCLUDE_FEATURE_hkndConvexDecompositionAction_execute
#       define HK_EXCLUDE_FEATURE_hkndConvexHullAction_execute
#       define HK_EXCLUDE_FEATURE_hkndDecalMapAction_execute
#       define HK_EXCLUDE_FEATURE_hkndDecorateFractureFaceAction_execute
#       define HK_EXCLUDE_FEATURE_hkndDecorateFractureFaceAction_syncDecorationData
#       define HK_EXCLUDE_FEATURE_hkndExplosionForceAction_execute
#       define HK_EXCLUDE_FEATURE_hkndFlattenHierarchyAction_execute
#       define HK_EXCLUDE_FEATURE_hkndGlueFixedPiecesAction_execute
#       define HK_EXCLUDE_FEATURE_hkndIntegrityAnalyzerAction_execute
#       define HK_EXCLUDE_FEATURE_hkndMeshSimplifierAction_execute
#       define HK_EXCLUDE_FEATURE_hkndPrepareForDynamicFractureAction_execute
#       define HK_EXCLUDE_FEATURE_hkndRemoveDebrisAction_execute
#       define HK_EXCLUDE_FEATURE_hkndRemoveWeakConnectionsAction_execute
#       define HK_EXCLUDE_FEATURE_hkndSetRigidBodyPropertiesAction_execute
#       define HK_EXCLUDE_FEATURE_hkndShareVerticesAction_execute
#       define HK_EXCLUDE_FEATURE_hkndShockWaveAction_execute
#       define HK_EXCLUDE_FEATURE_hkndSplitByPhysicsIslandsAction_execute
#       define HK_EXCLUDE_FEATURE_hkndDebrisFractureInfo_execute
#       define HK_EXCLUDE_FEATURE_hkndDecorateCornerInfo_execute
#       define HK_EXCLUDE_FEATURE_hkndDecorateFractureFaceInfo_execute
#       define HK_EXCLUDE_FEATURE_hkndMeshOptimizerInfo_execute
#       define HK_EXCLUDE_FEATURE_hkndBuildingProcessor_execute
#       define HK_EXCLUDE_FEATURE_hkndDeformationProcessor_execute
#       define HK_EXCLUDE_FEATURE_hkndFlexibleJointProcessor_execute
#       define HK_EXCLUDE_FEATURE_hkndWoodProcessor_execute
#       define HK_EXCLUDE_FEATURE_hkndCutOutFracture_execute
#       define HK_EXCLUDE_FEATURE_hkndDecomposeFracture_execute
#       define HK_EXCLUDE_FEATURE_hkndImageBasedFracture_execute
#       define HK_EXCLUDE_FEATURE_hkndPieFracture_execute
#       define HK_EXCLUDE_FEATURE_hkndRandomSplitFracture_execute
#       define HK_EXCLUDE_FEATURE_hkndSliceFracture_execute
#       define HK_EXCLUDE_FEATURE_hkndSplitInHalfFracture_execute
#       define HK_EXCLUDE_FEATURE_hkndVoronoiFracture_execute
#       define HK_EXCLUDE_FEATURE_hkndVoronoiFracture_getCutouts
#       define HK_EXCLUDE_FEATURE_hkndWoodFracture_execute
#   endif

    // Actions
#   if !defined(HK_EXCLUDE_FEATURE_hkndConvexDecompositionAction_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndConvexDecompositionAction_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndConvexHullAction_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndConvexHullAction_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndDecalMapAction_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndDecalMapAction_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndDecorateFractureFaceAction_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndDecorateFractureFaceAction_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndDecorateFractureFaceAction_syncDecorationData)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndDecorateFractureFaceAction_syncDecorationData);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndExplosionForceAction_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndExplosionForceAction_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndFlattenHierarchyAction_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndFlattenHierarchyAction_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndGlueFixedPiecesAction_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndGlueFixedPiecesAction_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndIntegrityAnalyzerAction_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndIntegrityAnalyzerAction_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndMeshSimplifierAction_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndMeshSimplifierAction_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndPrepareForDynamicFractureAction_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndPrepareForDynamicFractureAction_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndRemoveDebrisAction_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndRemoveDebrisAction_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndRemoveWeakConnectionsAction_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndRemoveWeakConnectionsAction_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndSetRigidBodyPropertiesAction_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndSetRigidBodyPropertiesAction_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndShareVerticesAction_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndShareVerticesAction_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndShockWaveAction_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndShockWaveAction_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndSplitByPhysicsIslandsAction_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndSplitByPhysicsIslandsAction_buildTaskGraph);
#   endif

    // Infos
#   if !defined(HK_EXCLUDE_FEATURE_hkndDebrisFractureInfo_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndDebrisFractureInfo_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndDecorateCornerInfo_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndDecorateCornerInfo_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndDecorateFractureFaceInfo_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndDecorateFractureFaceInfo_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndMeshOptimizerInfo_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndMeshOptimizerInfo_buildTaskGraph);
#   endif

    // Controllers
#   if !defined(HK_EXCLUDE_FEATURE_hkndBuildingProcessor_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndBuildingProcessor_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndFlexibleJointProcessor_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndFlexibleJointProcessor_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndDeformationProcessor_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndDeformationProcessor_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndWoodProcessor_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndWoodProcessor_buildTaskGraph);
#   endif

    // Fractures
#   if !defined(HK_EXCLUDE_FEATURE_hkndCutOutFracture_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndCutOutFracture_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndDebrisFracture_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndDebrisFracture_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndDecomposeFracture_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndDecomposeFracture_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndParticleEffectFracture_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndParticleEffectFracture_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndImageBasedFracture_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndImageBasedFracture_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndPieFracture_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndPieFracture_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndRandomSplitFracture_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndRandomSplitFracture_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndSliceFracture_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndSliceFracture_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndSplitInHalfFracture_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndSplitInHalfFracture_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndVoronoiFracture_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndVoronoiFracture_buildTaskGraph);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndVoronoiFracture_getCutouts)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndVoronoiFracture_getCutouts);
#   endif
#   if !defined(HK_EXCLUDE_FEATURE_hkndWoodFracture_execute)
        HK_OPTIONAL_COMPONENT_REQUEST(hkndWoodFracture_buildTaskGraph);
#   endif
#endif

    volatile hkUlong x = registerClasses();
    (void)x;
}

// Generate class registration. Use default classes file if no custom class file is provided
#if !defined(HK_CLASSES_FILE)
    #define HK_CLASSES_FILE <Common/Base/ClassLists/hkKeyCodeClassLists.cxx>
#endif
#include <Common/Base/ClassLists/hkRegisterClasses.cxx>

// Set up the deprecated serialization and versioning system.
// You can replace HK_COMPAT_FILE with your own file that contains
// only the versioning steps you need.

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
