// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

// Build configuration settings:
//
// These are compile time settings for the libraries.
// Changing these values with compiled libs will not work.


// Build number and version number:
//
// The version number must match that of the Havok libraries in use,
// and is of the form YEAR.RELEASE.MINOR.
//
// The build number is a unique identifier. It is for informative
// reasons only - different builds will work with each other as long
// as the version number is the same.

#pragma once

#define HAVOK_VERSION_MAJOR 2017
#define HAVOK_VERSION_MINOR 2
#define HAVOK_SDK_VERSION_POINT 0 // Reported SDK version, DLL versions etc.
#define HAVOK_REFLECTION_VERSION_POINT 0 // Serialization manifest, AssetCC, HKX file version
#define HAVOK_VDB_VERSION_POINT 0 // VDB protocol version point

// Release id must be less than 3 chars to fit in binary packfile header.
// Use the following ids:
// alpha -> "aN", beta -> "bN", release -> "rN" and internal -> "$$"
#define HAVOK_VERSION_RELEASE "r1"

#define HAVOK_SDK_VERSION ((10000*HAVOK_VERSION_MAJOR) + (100*HAVOK_VERSION_MINOR) + (HAVOK_SDK_VERSION_POINT)) // e.g. 20100100
#define HAVOK_REFLECTION_VERSION ((10000*HAVOK_VERSION_MAJOR) + (100*HAVOK_VERSION_MINOR) + (HAVOK_REFLECTION_VERSION_POINT)) // e.g. 20100100
#define HAVOK_VDB_VERSION ((1000*(HAVOK_VERSION_MAJOR-2000)) + (100*HAVOK_VERSION_MINOR) + (HAVOK_VDB_VERSION_POINT)) // e.g. 10100

#if HAVOK_REFLECTION_VERSION > HAVOK_SDK_VERSION
#error "Havok REFLECTION version cannot exceed SDK version"
#endif

// HAVOK version string
// temporary definitions
#define HK_STRING0 "0"
#define HK_STRING1 "1"
#define HK_STRING2 "2"
#define HK_STRING3 "3"
#define HK_STRING4 "4"
#define HK_STRING5 "5"
#define HK_STRING6 "6"
#define HK_STRING7 "7"
#define HK_STRING8 "8"
#define HK_STRING9 "9"
#define HK_STRING2017 "2017"

#define HK_NUM_TO_STR(NUM) HK_STRING##NUM
#define HAVOK_SDK_VERSION_STRING_SPEC(MAJOR,MINOR,POINT,RELEASE) HK_NUM_TO_STR(MAJOR) "." HK_NUM_TO_STR(MINOR) "." HK_NUM_TO_STR(POINT) "-" RELEASE

#define HAVOK_SDK_VERSION_NUM_STRING        HAVOK_SDK_VERSION_STRING_SPEC(HAVOK_VERSION_MAJOR, HAVOK_VERSION_MINOR, HAVOK_SDK_VERSION_POINT, HAVOK_VERSION_RELEASE)
#define HAVOK_SDK_VERSION_STRING            "hk_" HAVOK_SDK_VERSION_NUM_STRING

#define HAVOK_REFLECTION_VERSION_NUM_STRING HAVOK_SDK_VERSION_STRING_SPEC(HAVOK_VERSION_MAJOR, HAVOK_VERSION_MINOR, HAVOK_REFLECTION_VERSION_POINT, HAVOK_VERSION_RELEASE) // e.g. "2010.1.0-r1"
#define HAVOK_REFLECTION_VERSION_STRING     "hk_" HAVOK_REFLECTION_VERSION_NUM_STRING // e.g. "hk_2010.1.0-r1"

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
