// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
// Build configuration settings
// These are compile time settings for the libraries.
// Changing these values with compiled libs will not work,

// If this setting is changed you must rebuild all Havok libs

// EQSELECT: HK_CONFIG_THREAD, Choose to enable or disable simd instructions:
// This determines whether or not we use simd instructions.

#pragma once

#define HK_CONFIG_SINGLE_THREADED 1
#define HK_CONFIG_MULTI_THREADED  2

#if !defined(HKBASE_HKBASEDEFS_H)
#   error Common/Base/hkBase.h needs to be included before this file
#endif

#if defined(HK_PLATFORM_WIIU)
#   include <Common/Base/Config/hkConfigWiiU.h>
#endif

#ifndef HK_CONFIG_THREAD

    // ia32 / x6, incl WinRT
#   if defined(HK_PLATFORM_WIN32)
#       define HK_CONFIG_THREAD HK_CONFIG_MULTI_THREADED

    // PSP(R) (PlayStation(R)Portable)
#   elif defined(HK_PLATFORM_PSP)
#       define HK_CONFIG_THREAD HK_CONFIG_SINGLE_THREADED

    // Linux
#   elif defined(HK_PLATFORM_LINUX)
#       define HK_CONFIG_THREAD HK_CONFIG_MULTI_THREADED

    // Tizen
#   elif defined(HK_PLATFORM_TIZEN)
#       define HK_CONFIG_THREAD HK_CONFIG_MULTI_THREADED

    // Mac
#   elif defined(HK_PLATFORM_MAC)
#       define HK_CONFIG_THREAD HK_CONFIG_MULTI_THREADED

#   elif defined(HK_PLATFORM_IOS) // no point on current gen single core iphone etc (but will work if you want)
        #if defined(HK_ARCH_ARM_V7) || defined(HK_ARCH_ARM_V8) || defined(HK_PLATFORM_IOS_SIM)
            #define HK_CONFIG_THREAD HK_CONFIG_MULTI_THREADED
        #else // V6 had no dual cores really
            #define HK_CONFIG_THREAD HK_CONFIG_SINGLE_THREADED
        #endif

    // Android
#   elif defined(HK_PLATFORM_ANDROID)
        #if defined(HK_ARCH_ARM_V7) || defined(HK_ARCH_ARM_V8) || defined(HK_ARCH_IA32)
            #define HK_CONFIG_THREAD HK_CONFIG_MULTI_THREADED
        #else // V6 had no dual cores really
            #define HK_CONFIG_THREAD HK_CONFIG_SINGLE_THREADED
        #endif

    // CTR
#   elif defined(HK_PLATFORM_CTR)
#       define HK_CONFIG_THREAD HK_CONFIG_SINGLE_THREADED

    // PS VITA
#   elif defined(HK_PLATFORM_PSVITA)
#       define HK_CONFIG_THREAD HK_CONFIG_MULTI_THREADED

    // PlayStation(R)4
#   elif defined(HK_PLATFORM_PS4)
#       define HK_CONFIG_THREAD HK_CONFIG_MULTI_THREADED

#   elif defined(HK_PLATFORM_NX)
#       define HK_CONFIG_THREAD HK_CONFIG_MULTI_THREADED

#   else
#       error Unknown Platform
#   endif

#else // ifndef HK_CONFIG_THREAD

#   if (HK_CONFIG_THREAD != HK_CONFIG_MULTI_THREADED) && (HK_CONFIG_THREAD != HK_CONFIG_SINGLE_THREADED)
#       error invalid config thread option
#   endif

#endif // ifndef HK_CONFIG_THREAD

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
