// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
// Build configuration settings
// These are compile time settings for the libraries.
// Changing these values with compiled libs will not work,

// If this setting is changed you must rebuild all Havok libs

// EQSELECT: HK_CONFIG_SIMD, Choose to enable or disable simd instructions:
// This determines whether or not we use simd instructions.

#pragma once

#define HK_CONFIG_SIMD_ENABLED 1 // Enabled
#define HK_CONFIG_SIMD_DISABLED 2 // Disabled

#if !defined(HKBASE_HKBASETYPES_H)
#   error hkbase/hkBase.h needs to be included before this file
#endif

// Uncomment the following line to force a FPU build
//#define HK_CONFIG_SIMD HK_CONFIG_SIMD_DISABLED


#if defined(HK_PLATFORM_WIIU)
#   include <Common/Base/Config/hkConfigWiiU.h>
#endif


#ifndef HK_CONFIG_SIMD

    // win32
#   if defined(HK_PLATFORM_WIN32)
#       if defined (HK_ARCH_ARM)
            
#           define HK_CONFIG_SIMD HK_CONFIG_SIMD_DISABLED
#       elif defined (HK_ARCH_X64)
#           define HK_CONFIG_SIMD HK_CONFIG_SIMD_ENABLED
#       elif defined(HK_PLATFORM_SIM)
#           define HK_CONFIG_SIMD HK_CONFIG_SIMD_ENABLED
#       else
            // x86
#           define HK_CONFIG_SIMD HK_CONFIG_SIMD_ENABLED
#       endif

#   elif defined(HK_PLATFORM_NACL)
#       define HK_CONFIG_SIMD HK_CONFIG_SIMD_DISABLED

    // Linux
#   elif defined(HK_PLATFORM_LINUX) && !defined(HK_PLATFORM_TIZEN)
#      error No SIMD config selected. Please add -DHK_CONFIG_SIMD=1 (SIMD enabled) or -DHK_CONFIG_SIMD=2 (SIMD disabled) to compiler options in makefile.

    // AMD x64
#   elif defined(HK_ARCH_X64) && !defined(HK_PLATFORM_MAC386) && !defined(HK_PLATFORM_MAC64) && !defined(HK_PLATFORM_NX)
#       define HK_CONFIG_SIMD HK_CONFIG_SIMD_ENABLED

    // PSP(R) (PlayStation(R)Portable)
#   elif defined(HK_PLATFORM_PSP)
#       define HK_CONFIG_SIMD HK_CONFIG_SIMD_DISABLED

    // Mac
#   elif defined(HK_PLATFORM_MACPPC)
#       define HK_CONFIG_SIMD HK_CONFIG_SIMD_DISABLED

#   elif defined(HK_PLATFORM_MAC386) || defined(HK_PLATFORM_MAC64)
#       define HK_CONFIG_SIMD HK_CONFIG_SIMD_ENABLED

#   elif defined(HK_PLATFORM_IOS)
#       ifdef HK_COMPILER_HAS_INTRINSICS_NEON // ARMv7 (Cortex A8, Cortex A9 etc)
#           define HK_CONFIG_SIMD HK_CONFIG_SIMD_ENABLED //HK_CONFIG_SIMD_ENABLED
#       else // ARMv6 etc
#           define HK_CONFIG_SIMD HK_CONFIG_SIMD_DISABLED
#       endif

    // Android
#   elif defined(HK_PLATFORM_ANDROID)
#       ifdef HK_ARCH_ARM
#           ifdef HK_COMPILER_HAS_INTRINSICS_NEON // ARMv7 (Cortex A8, Cortex A9 etc)
#               define HK_CONFIG_SIMD HK_CONFIG_SIMD_ENABLED
#           else // ARMv6 etc
#               define HK_CONFIG_SIMD HK_CONFIG_SIMD_DISABLED
#           endif
#       else
#           define HK_CONFIG_SIMD HK_CONFIG_SIMD_ENABLED  // Always define for Android x86
#       endif

#   elif defined(HK_PLATFORM_TIZEN)
#       define HK_CONFIG_SIMD HK_CONFIG_SIMD_DISABLED

    // CTR
#   elif defined(HK_PLATFORM_CTR)
#       define HK_CONFIG_SIMD HK_CONFIG_SIMD_DISABLED

    // PS VITA
#   elif defined(HK_PLATFORM_PSVITA)
#       define HK_CONFIG_SIMD HK_CONFIG_SIMD_ENABLED

    // PlayStation(R)4
#   elif defined(HK_PLATFORM_PS4)
#       define HK_CONFIG_SIMD HK_CONFIG_SIMD_ENABLED

#   elif defined(HK_PLATFORM_NX)
#       if defined(HK_PLATFORM_NX_WIN32) || defined(HK_PLATFORM_NX_X64)
#           define HK_CONFIG_SIMD HK_CONFIG_SIMD_DISABLED
#       else
#           define HK_CONFIG_SIMD HK_CONFIG_SIMD_ENABLED
#       endif
#   else

#       error Unknown Platform
#       define HK_CONFIG_SIMD HK_CONFIG_SIMD_DISABLED
#   endif
#else // ifndef HK_CONFIG_SIMD
#   if (HK_CONFIG_SIMD != HK_CONFIG_SIMD_ENABLED) && (HK_CONFIG_SIMD != HK_CONFIG_SIMD_DISABLED)
#       error invalid config simd option
#   endif
#endif // ifndef HK_CONFIG_SIMD

// HK_SSE_VERSION
// 0x20 = SSE2
// 0x30 = SSE3
// 0x31 = SSSE3
// 0x40 = SSE4 (AES)
// 0x41 = SSE4.1
// 0x42 = SSE4.2
// 0x50 = AVX
// 0x51 = FMA
#if !defined(HK_SSE_VERSION)
#   if defined(HK_PLATFORM_PS4)
#       define HK_SSE_VERSION 0x42
#   elif defined(HK_PLATFORM_DURANGO)
#       define HK_SSE_VERSION 0x42 //0x50
#   elif defined(HK_PLATFORM_ANDROID) && !defined(HK_ARCH_ARM)
#       define HK_SSE_VERSION 0x31
#   else
#       define HK_SSE_VERSION 0x20  
#   endif
#endif

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
