// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

class HK_EXPORT_COMMON hkRadixSort
{
public:

    HK_CLASSALIGN(struct, 4) SortData16
    {
        HK_DECLARE_POD_TYPE();
        typedef hkUint16 KeyType;
        union
        {
            hkUint16 m_key;
            hkUint8 m_keys[2];
        };
        hkUint16 m_userData;
        friend hkBool32 operator < (const SortData16& a, const SortData16& b) { return a.m_key < b.m_key; }
    };

    template<typename UserDataT>
    HK_CLASSALIGN(struct, 4) SortData32T
    {
        HK_DECLARE_POD_TYPE();
        typedef UserDataT UserDataType;
        typedef hkUint32 KeyType;
        union
        {
            hkUint32 m_key;
            hkUint8 m_keys[4];
        };
        UserDataT m_userData;
        friend hkBool32 operator < (const SortData32T& a, const SortData32T& b) { return a.m_key < b.m_key; }
    };
    typedef SortData32T<hkUint32> SortData32;

    HK_CLASSALIGN(struct, 8) SortData64
    {
        HK_DECLARE_POD_TYPE();
        typedef hkUint64 KeyType;
        union
        {
            hkUint64 m_key;
            hkUint8 m_keys[8];
        };
        hkUint32 m_userData;
        friend hkBool32 operator < (const SortData64& a, const SortData64& b) { return a.m_key < b.m_key; }
    };

    /// sort data according to m_key
    /// buffer needs to be of same size as data
    static void HK_CALL sort16(_Inout_updates_(numData) SortData16* data, int numData, _Inout_updates_(numData) SortData16* buffer);

    /// sort data according to m_key
    /// buffer needs to be of same size as data
    template<typename UserDataT>
    static void HK_CALL sort32T(_Inout_updates_(numData) SortData32T<UserDataT>* data, int numData, _Inout_updates_(numData) SortData32T<UserDataT>* buffer);

    /// sort data according to m_key
    /// buffer needs to be of same size as data
    static void HK_CALL sort32(_Inout_updates_(numData) SortData32* data, int numData, _Inout_updates_(numData) SortData32* buffer) { sort32T<SortData32::UserDataType>(data, numData, buffer); }

    /// sort data according to m_key
    /// buffer needs to be of same size as data
    static void HK_CALL sort64(_Inout_updates_(numData) SortData64* data, int numData, _Inout_updates_(numData) SortData64* buffer);

    template<typename SortData>
    static void HK_CALL sort(_Inout_updates_(numData) SortData* data, int numData, _Inout_updates_(numData) SortData* buffer);

    /// Detector for a sort data based on the key size
    template <int KeySize>  struct Detector {};
};

template <> struct hkRadixSort::Detector<2>
{
    typedef hkRadixSort::SortData16 SortData;
};

template <> struct hkRadixSort::Detector<4>
{
    typedef hkRadixSort::SortData32 SortData;
};

template <> struct hkRadixSort::Detector<8>
{
    typedef hkRadixSort::SortData64 SortData;
};

template<> void HK_CALL hkRadixSort::sort<hkRadixSort::SortData16>(_Inout_updates_(numObjects) hkRadixSort::SortData16* data, int numObjects, _Inout_updates_(numObjects) hkRadixSort::SortData16* buffer);
template<> void HK_CALL hkRadixSort::sort<hkRadixSort::SortData32>(_Inout_updates_(numObjects) hkRadixSort::SortData32* data, int numObjects, _Inout_updates_(numObjects) hkRadixSort::SortData32* buffer);
template<> void HK_CALL hkRadixSort::sort<hkRadixSort::SortData64>(_Inout_updates_(numObjects) hkRadixSort::SortData64* data, int numObjects, _Inout_updates_(numObjects) hkRadixSort::SortData64* buffer);

#include <Common/Base/Algorithm/Sort/hkRadixSort.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
