// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Algorithm/Sort/hkSort.h>

#include <Common/Base/Types/Geometry/Aabb/hkAabb.h>

namespace hkAlgorithm
{
    namespace Morton
    {
        /// Data range.
        typedef hkArrayView<hkVector4> DataRange;

        /// Inplace sorting of points along a space filling Z-curve (see https://en.wikipedia.org/wiki/Z-order_curve ).
        /// Notes:
        /// - Complexity is O( N * log(N) ).
        /// - All points components are left unchanged.
        /// - Process sub-ranges of size greater than \a mtThreshold on worker threads using hkConcurrency::async.
        HK_EXPORT_COMMON void sort( const hkArrayView<hkVector4>& points, int mtThreshold = 0x7fffffff );

        /// Experimental
        HK_EXPORT_COMMON void sort2( const hkArrayView<hkVector4>& points, const hkArrayView<hkVector4>& buffer );


        HK_EXPORT_COMMON void split( const hkArrayView<hkVector4>& points, int minNumElements, hkArrayView<hkVector4>& leftOut, hkArrayView<hkVector4>& rightOut );

        // slower reference version, will be removed soon.
        HK_EXPORT_COMMON void sortDeprecated( const hkArrayView<hkVector4>& points, int mtThreshold = 0x7fffffff );


    }
}

#include <Common/Base/Algorithm/Sort/hkMortonSort.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
