// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Algorithm/PseudoRandom/hkPseudoRandomGenerator.h>

//
//  Get random real in range [0,1] using getRand32()

hkPseudoRandomGenerator::hkPseudoRandomGenerator( hkReflect::BypassCtorFlag ) HK_ATTR( hk::Reflect( false ) )
{
}


hkUint32 hkPseudoRandomGenerator::getRandChar(int x)
{
    HK_ASSERT_NO_MSG(0x777504aa, x > 0 && x <= 256);
    m_current = 1664525L * m_current + 1013904223L;

    hkUint32 temp = m_current;
    temp >>= 13;
    temp = temp % x;

    return temp;
}

hkUint32 hkPseudoRandomGenerator::getRandInt16(int x)
{
    HK_ASSERT_NO_MSG(0x777504ab, x > 0 && x <= 65536);
    m_current = 1664525L * m_current + 1013904223L;

    hkUint32 temp = m_current;
    temp >>= 11;
    temp = temp % x;

    return temp;
}

int  hkPseudoRandomGenerator::getRandRangeInt(int start, int end)
{
    HK_ASSERT_NO_MSG(0x10dff4c1, end > start);
    // if the the integer range would be unlimited the expression "randomNumber % 3" would generate
    // a uniformly distributed sequence of numbers 1,2,3. But as integers have a limit, this is not the
    // case. Think about the integer range being divided in buckets [0,1,2],[3,4,5],...,[max-2, max-1, max]
    // It can happen that the very last bucket does not contain 3 elements. It may contain 2 or only 1 element.
    // This results in a non uniform distribution. So the basic idea is, that every time we hit the "bad" bucket
    // we simply re-roll and try again with the next random number.
    hkUint32 bucketSize = (hkUint32)(end - start);
    hkUint32 randomNumber, inBucketOffset, bucketStart;

    do
    {
        randomNumber = getRand32();
        randomNumber = hkEndian::swap(randomNumber); // Bit N follows a period that repeats at least every 2^N calls, use the higher bits
        inBucketOffset = randomNumber % bucketSize;
        bucketStart = randomNumber - inBucketOffset;
    } while (bucketStart > (0xFFFFFFFF - (bucketSize - 1)));

    int result = (int)(start + inBucketOffset);
    HK_ASSERT_NO_MSG(0x7335c796, result >= start && result < end);
    return result;
}

hkReal hkPseudoRandomGenerator::getRandReal01()
{
    const hkReal v = getRand32()*( 1.0f / 0xffffffff);
    return v;
}

void hkPseudoRandomGenerator::getRandomRotation( hkRotation& rotOut )
{
    hkVector4 v;
    v(0) = getRandReal11();
    v(1) = getRandReal11();
    v(2) = getRandReal11();
    v(3) = getRandReal11();
    v.normalize<4>();
    hkQuaternion q;
    q.m_vec = v;
    rotOut.set( q );
}

void hkPseudoRandomGenerator::getRandomRotation( hkQuaternion& rotOut )
{
    hkVector4 v;
    v(0) = getRandReal11();
    v(1) = getRandReal11();
    v(2) = getRandReal11();
    v(3) = getRandReal11();
    v.normalize<4>();
    rotOut.m_vec = v;
}

        /// sets xyzw randomly between -1 and 1
void hkPseudoRandomGenerator::getRandomVector11( hkVector4& vecOut )
{
    vecOut(0) = getRandReal11();
    vecOut(1) = getRandReal11();
    vecOut(2) = getRandReal11();
    vecOut(3) = getRandReal11();
}

        /// sets xyzw randomly between -maxValue and maxValue
void hkPseudoRandomGenerator::getRandomVectorRange( hkReal maxValue, hkVector4& vecOut )
{
    vecOut(0) = maxValue * getRandReal11();
    vecOut(1) = maxValue * getRandReal11();
    vecOut(2) = maxValue * getRandReal11();
    vecOut(3) = maxValue * getRandReal11();
}


    /// sets xyzw randomly between 0 and 1
void hkPseudoRandomGenerator::getRandomVector01( hkVector4& vecOut )
{
    vecOut(0) = getRandReal01();
    vecOut(1) = getRandReal01();
    vecOut(2) = getRandReal01();
    vecOut(3) = getRandReal01();
}

void hkPseudoRandomGenerator::getRandomVectorRange( hkVector4Parameter min, hkVector4Parameter max, hkVector4& vecOut)
{
    hkVector4 t; getRandomVector01(t);
    hkVector4 delta; delta.setSub(max, min);
    vecOut.setAddMul(min, delta, t);
}

void hkPseudoRandomGenerator::getRandomPointInTriangle( hkVector4Parameter A, hkVector4Parameter B, hkVector4Parameter C, hkVector4& vecOut)
{
    // Use barycentric. http://www.cgafaq.info/wiki/Random_Point_In_Triangle or http://www.exaflop.org/docs/cgafaq/cga6.html
    hkSimdReal x = hkSimdReal::fromFloat( getRandReal01() );
    hkSimdReal y = hkSimdReal::fromFloat( getRandReal01() );
    hkVector4Comparison xPlusY_gt_1 = (x+y).greater(hkSimdReal_1);

    x.setSelect(xPlusY_gt_1, hkSimdReal_1 - x, x);
    y.setSelect(xPlusY_gt_1, hkSimdReal_1 - y, y);

    hkVector4 p;
    p.setMul( (hkSimdReal_1 - x - y), A);
    p.addMul(x, B);
    p.addMul(y, C);

    vecOut = p;
}

void hkPseudoRandomGenerator::randomizeMemory( _Out_writes_bytes_all_(numBytes) void* data, int numBytes )
{
    hkUchar* d = (hkUchar*)data;
    for (int i =0; i < numBytes; i++ )
    {
        d[i] = hkUchar(getRandChar(256));
    }
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
