// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

// this: #include <Common/Base/Algorithm/PseudoRandom/hkMT19937RandomGenerator.h>

/// This class implements a simple Mersenne Twister pseudo-random number generator.
/// Specifically this implements the Mersenne Twister 19937 with 32-bit word length.
/// It generates random values approximately uniformely distributed in the interval [0, 2^32-1].
/// It has a very long period of randomness, and it has very well distributed over the interval.
/// This is a high quality random number generator and thus a bit more expensive than the simple
/// hkPseudoRandomGenerator.
/// Depending on what operation is performed on the returned value, the uniform distribution property
/// could be lost. Specifically the rand()%X operation to crop the interval between 0 and X-1 _doesn't_
/// preserve the uniform distribution.
class HK_EXPORT_COMMON hkMT19937RandomGenerator
{
    public:
        HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR(HK_MEMORY_CLASS_BASE, hkMT19937RandomGenerator);

        /// The random engine will not be usable until initialize is called with a given seed.
        hkMT19937RandomGenerator();

        /// Destructor to cleanup the state.
        ~hkMT19937RandomGenerator();

        /// Sets the seed and initializes the engine (effectively resetting the generator).
        /// This is a relatively expensive process, the status of the generator is fully initialized and
        /// reinitialized when exhausted during generation. In the case of the MT19937 generator the status
        /// is basically 624 32 bit words.
        void initialize(hkUint32 seed);

        /// Gets a new random value (thus updating the state of the generator).
        hkUint32 getRand();

        /// Gets a new random value between 0 and the specified maximum. If the maximum
        /// is a power of 2, the method will eventually produce all possible floats in
        /// that range. It is effectively uniform and unbiased.
        hkFloat32 getRandFloat32(hkFloat32 max);

        void writeState(class hkStreamWriter & writer) const;
        void readState(class hkStreamReader & reader);

    protected:
        /// Every 624 random numbers, this MT generator needs to regenerate the state numbers.
        void generateNumbers();

        hkUint16 m_index;
        hkUint32* m_state;

    private:
        // Hidden constructors and operators.
        hkMT19937RandomGenerator(const hkMT19937RandomGenerator& rhs);
        hkMT19937RandomGenerator& operator=(const hkMT19937RandomGenerator& rhs);
};

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
