// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

namespace hkAlgorithm
{
    namespace Detail
    {
        template <hkUint32 id, typename T>
        HK_INLINE int indexOf(const T* begin, const T* end, T searchElem, hkAsyncHeartbeat::Heartbeat& heartbeat);

        template <int size> HK_INLINE int indexOfPod(const void* begin, const void* end, const void* elem, hkAsyncHeartbeat::Heartbeat& heartbeat);
        template <> HK_INLINE int indexOfPod<1>(const void* begin, const void* end, const void* elem, hkAsyncHeartbeat::Heartbeat& heartbeat);
        template <> HK_INLINE int indexOfPod<2>(const void* begin, const void* end, const void* elem, hkAsyncHeartbeat::Heartbeat& heartbeat);
        template <> HK_INLINE int indexOfPod<4>(const void* begin, const void* end, const void* elem, hkAsyncHeartbeat::Heartbeat& heartbeat);
        template <> HK_INLINE int indexOfPod<8>(const void* begin, const void* end, const void* elem, hkAsyncHeartbeat::Heartbeat& heartbeat);
    }
}

template<hkUint32 id, typename T, typename L>
void HK_CALL hkAlgorithm::quickSort(T *pArr, int iSize, hkAsyncHeartbeat::Heartbeat& heartbeat, L cmpLess)
{
    if ( iSize > 1 )
    {
        int low = 0;
        int high = iSize - 1;
        quickSortRecursive<id, T, L>( pArr, low, high, cmpLess, heartbeat);
    }
}

template<hkUint32 id, typename T, typename L>
void HK_CALL hkAlgorithm::quickSortRecursive( T *pArr, int d, int h, L cmpLess, hkAsyncHeartbeat::Heartbeat& heartbeat)
{
    int i, j;
#ifndef HK_ARCH_ARM
    HK_ALIGN16( T str );
#else
    T str;
#endif
    begin:
    i = h;
    j = d;

    str = pArr[ ( d + h ) >> 1 ];

    do
    {
        {
            int startJ = j;
            heartbeat.beginLoop<id>();
            while(cmpLess(pArr[ j ], str)) { j++; }
            heartbeat.endLoop<id>(j - startJ);
        }

        {
            int startI = i;
            heartbeat.beginLoop<id>();
            while(cmpLess(str, pArr[ i ])) { i--; }
            heartbeat.endLoop<id>(startI - i);
        }


        if ( i >= j )
        {
            if ( i != j )
            {
                T& pi_tmp = pArr[ i ];
                T& pj_tmp = pArr[ j ];
#ifndef HK_ARCH_ARM
                hkAlgorithm::swapAligned16( pi_tmp, pj_tmp );
#else
                hkAlgorithm::swap( pi_tmp, pj_tmp );
#endif
                heartbeat.tick<id + 1>();
            }

            i--;
            j++;
        }
    } while ( j <= i );

    if ( d < i )
    {
        quickSortRecursive<id, T, L>( pArr, d, i, cmpLess, heartbeat);
    }

    if ( j < h )
    {
        d = j;
        goto begin;
    }
}

template <hkUint32 id, typename T>
HK_INLINE int hkAlgorithm::Detail::indexOf(const T* begin, const T* end, T searchElem, hkAsyncHeartbeat::Heartbeat& heartbeat)
{
    auto blockBegin = begin;
    int idxBlocks = 0;

    int numElemsPerIt = heartbeat.beginLoop<id>();
    while(blockBegin < end)
    {
        auto blockEnd = hkMath::min2(blockBegin + numElemsPerIt, end);
        int idx = 0;
        for(auto it = blockBegin; it != blockEnd; ++it)
        {
            if(*it == searchElem)
            {
                heartbeat.endLoop<id>(idx);
                return idxBlocks + idx;
            }

            idx++;
        }

        blockBegin = blockEnd;
        idxBlocks += idx;
        heartbeat.loopTick<id>(idx);
    }

    heartbeat.endLoop<id>();
    return -1;
}

template <>
HK_INLINE int hkAlgorithm::Detail::indexOfPod<1>(const void* begin, const void* end, const void* elem, hkAsyncHeartbeat::Heartbeat& heartbeat)
{
    hkAsyncHeartbeat::Scope heartbeatScope(heartbeat, 0x7d62f6fc,
        hkAsyncHeartbeat::HeartbeatFile::BASE, "hkAlgorithm::indexOf");
    return indexOf<0xdfe7f1f1, hkUint8>(
        reinterpret_cast<const hkUint8*>(begin),
        reinterpret_cast<const hkUint8*>(end),
        *reinterpret_cast<const hkUint8*>(elem),
        heartbeat);
}

template <>
HK_INLINE int hkAlgorithm::Detail::indexOfPod<2>(const void* begin, const void* end, const void* elem, hkAsyncHeartbeat::Heartbeat& heartbeat)
{
    hkAsyncHeartbeat::Scope heartbeatScope(heartbeat, 0x7d62f6fc,
        hkAsyncHeartbeat::HeartbeatFile::BASE, "hkAlgorithm::indexOf");
    return indexOf<0xc7612dd8, hkUint16>(
        reinterpret_cast<const hkUint16*>(begin),
        reinterpret_cast<const hkUint16*>(end),
        *reinterpret_cast<const hkUint16*>(elem),
        heartbeat);
}

template <>
HK_INLINE int hkAlgorithm::Detail::indexOfPod<4>(const void* begin, const void* end, const void* elem, hkAsyncHeartbeat::Heartbeat& heartbeat)
{
    hkAsyncHeartbeat::Scope heartbeatScope(heartbeat, 0x7d62f6fc,
        hkAsyncHeartbeat::HeartbeatFile::BASE, "hkAlgorithm::indexOf");
    return indexOf<0x44226751, hkUint32>(
        reinterpret_cast<const hkUint32*>(begin),
        reinterpret_cast<const hkUint32*>(end),
        *reinterpret_cast<const hkUint32*>(elem),
        heartbeat);
}

template <>
HK_INLINE int hkAlgorithm::Detail::indexOfPod<8>(const void* begin, const void* end, const void* elem, hkAsyncHeartbeat::Heartbeat& heartbeat)
{
    hkAsyncHeartbeat::Scope heartbeatScope(heartbeat, 0x7d62f6fc,
        hkAsyncHeartbeat::HeartbeatFile::BASE, "hkAlgorithm::indexOf");
    return indexOf<0x07ad4090, hkUint64>(
        reinterpret_cast<const hkUint64*>(begin),
        reinterpret_cast<const hkUint64*>(end),
        *reinterpret_cast<const hkUint64*>(elem),
        heartbeat);
}

template <typename T>
HK_INLINE int hkAlgorithm::indexOf(hkArrayView<const T> elems, T searchElem, hkAsyncHeartbeat::Heartbeat& heartbeat)
{
    static_assert(hkTrait::IsPodType<T>::result, "indexOf only implemented for POD types.");
    return Detail::indexOfPod<sizeof(T)>(elems.begin(), elems.end(), &searchElem, heartbeat);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
