// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBaseHeartbeat.h>
#include <Common/Base/Container/String/hkString.h>
#include <Common/Base/Algorithm/Sort/hkSort.h>

namespace hkAlgorithm
{
    /// Set n bytes of dst to c.
    HK_EXPORT_COMMON void HK_CALL memSet(void* dst, const int c, int n, hkAsyncHeartbeat::Heartbeat& heartbeat);

    /// Copy n bytes of src into dst.
    HK_EXPORT_COMMON void HK_CALL memCpy(void* dst, const void* src, int n, hkAsyncHeartbeat::Heartbeat& heartbeat);

    HK_INLINE void memSet(void* dst, const int c, int n, hkAsyncHeartbeat::NullHeartbeat& heartbeat) { hkString::memSet(dst, c, n); }

    HK_INLINE void memCpy(void* dst, const void* src, int n, hkAsyncHeartbeat::NullHeartbeat& heartbeat) { hkString::memCpy(dst, src, n); }

    /// Quick sort. You supply the functor, see hkAlgorithm::less for an example functor.
    template<hkUint32 id, typename T, typename L>
    HK_INLINE void HK_CALL quickSort(T *pArr, int iSize, hkAsyncHeartbeat::Heartbeat& heartbeat, L cmpLess);

    template<hkUint32 id, typename T, typename L>
    HK_INLINE void HK_CALL quickSort(T *pArr, int iSize, hkAsyncHeartbeat::NullHeartbeat& heartbeat, L cmpLess) { quickSort(pArr, iSize, cmpLess); }

    /// Quick sort for the elements of the specified array.
    ///
    /// \param *pArr        A pointer to the data to sort.
    /// \param iSize        The size of the array pointed to by *pArr.
    ///
    template<hkUint32 id, typename T>
    HK_INLINE void HK_CALL quickSort(T *pArr, int iSize, hkAsyncHeartbeat::Heartbeat& heartbeat ) { quickSort<id, T>( pArr, iSize, heartbeat, less<T>() ); }

    template<hkUint32 id, typename T>
    HK_INLINE   void HK_CALL quickSort(T *pArr, int iSize, hkAsyncHeartbeat::NullHeartbeat& heartbeat ) { quickSort(pArr, iSize); }

    template<hkUint32 id, typename T, typename L >
    void HK_CALL quickSortRecursive(T *pArr, int d, int h, L cmpLess, hkAsyncHeartbeat::Heartbeat& heartbeat);

    /// Returns the index of the first occurrence of t, or -1 if not found.
    template <typename T>
    HK_INLINE int indexOf(hkArrayView<const T> elems, T searchElem, hkAsyncHeartbeat::Heartbeat& heartbeat);

    /// Returns the index of the first occurrence of t, or -1 if not found.
    template <typename T>
    HK_INLINE int indexOf(hkArrayView<const T> elems, T searchElem, hkAsyncHeartbeat::NullHeartbeat& heartbeat) { return elems.indexOf(searchElem); }
}

#include <Common/Base/Algorithm/Heartbeat/hkHeartbeatAlgos.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
