// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Algorithm/Heartbeat/hkHeartbeatAlgos.h>

void hkAlgorithm::memSet(void* dst, const int c, int n, hkAsyncHeartbeat::Heartbeat& heartbeat)
{
    
    
    

    heartbeat.beginScope(0x581dfa44, hkAsyncHeartbeat::HeartbeatFile::BASE, "hkAlgorithm::memSet");

    void* end = hkAddByteOffset(dst, n);

    const int numBytesPerIt = heartbeat.beginLoop<0xabf0c649>();
    void* blockBegin = dst;
    while(true)
    {
        void* blockEnd = hkAddByteOffset(blockBegin, numBytesPerIt);
        if(blockEnd > end)
        {
            break;
        }

        hkString::memSet(blockBegin, c, numBytesPerIt);
        blockBegin = blockEnd;

        heartbeat.loopTick<0xabf0c649>(numBytesPerIt);
    }

    hkUint32 tailSize = (hkUint32)hkGetByteOffsetInt(blockBegin, end);
    hkString::memSet(blockBegin, c, tailSize);
    heartbeat.endLoop<0xabf0c649>(tailSize);

    heartbeat.endScope();
}

void hkAlgorithm::memCpy(void* dst, const void* src, int n, hkAsyncHeartbeat::Heartbeat& heartbeat)
{
    HK_ASSERT(0x11ad5c17, hkMath::max2(hkUlong(dst), hkUlong(src)) >= (n + hkMath::min2(hkUlong(dst), hkUlong(src))),
        "The ranges passed to hkAlgorithm::memCpy must not overlap.");

    
    
    

    heartbeat.beginScope(0xa05bb07c, hkAsyncHeartbeat::HeartbeatFile::BASE, "hkAlgorithm::memCpy");

    void* dstEnd = hkAddByteOffset(dst, n);

    const int numBytesPerIt = heartbeat.beginLoop<0x8a9331c2>();
    void* dstBlockBegin = dst;
    const void* srcBlockBegin = src;
    while(true)
    {
        void* dstBlockEnd = hkAddByteOffset(dstBlockBegin, numBytesPerIt);
        if(dstBlockEnd > dstEnd)
        {
            break;
        }

        hkString::memCpy(dstBlockBegin, srcBlockBegin, numBytesPerIt);
        dstBlockBegin = dstBlockEnd;
        srcBlockBegin = hkAddByteOffset(srcBlockBegin, numBytesPerIt);

        heartbeat.loopTick<0x8a9331c2>(numBytesPerIt);
    }

    hkUint32 tailSize = (hkUint32)hkGetByteOffsetInt(dstBlockBegin, dstEnd);
    hkString::memCpy(dstBlockBegin, srcBlockBegin, tailSize);
    heartbeat.endLoop<0x8a9331c2>(tailSize);

    heartbeat.endScope();
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
