// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#include <Common/Base/hkBase.h>
#include <Common/Base/Algorithm/Hash/hkHash.h>

// See http://isthe.com/chongo/tech/comp/fnv/
hkUint32 hkHash::computeFNV1Hash32(_In_z_ const char* str)
{
    HK_ASSERT_NO_MSG(0x22d19d6d, str);

    const hkUint32 offsetBasis = 2166136261u;
    const hkUint32 prime = 16777619u;

    hkUint32 h = offsetBasis;
    for (hkLong i = 0; str[i] != '\0'; ++i)
    {
        h = prime * (h ^ str[i]);
    }

    return h;
}

// See http://isthe.com/chongo/tech/comp/fnv/
hkUint32 hkHash::computeFNV1Hash32(_In_reads_(len) const char* str, hkLong len)
{
    HK_ASSERT_NO_MSG(0x50fec38d, str);

    const hkUint32 offsetBasis = 2166136261u;
    const hkUint32 prime = 16777619u;

    hkUint32 h = offsetBasis;
    for (hkLong i = 0; i < len; ++i)
    {
        h = prime * (h ^ str[i]);
    }

    return h;
}

// See http://isthe.com/chongo/tech/comp/fnv/
hkUint64 hkHash::appendFNV1Hash64(hkUint64 h, _In_z_ const char* extraData)
{
    HK_ASSERT_NO_MSG(0x50fec39f, extraData);

    const hkUint64 prime = 1099511628211ull;

    for (int i = 0; extraData[i] != '\0'; ++i)
    {
        h = prime * (h ^ extraData[i]);
    }

    return h;
}

hkUint64 hkHash::computeFNV1Hash64(_In_z_ const char* str)
{
    const hkUint64 offsetBasis = 14695981039346656037ull;
    return appendFNV1Hash64(offsetBasis, str);
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
