// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0


namespace hkHash
{
    hkUint32 combineHashValues(hkUint32 h0, hkUint32 h1)
    {
        // See boost::hash_combine.
        return h0 ^ (h1 + 0x9e3779b9 + (h0 << 6) + (h1 >> 2));
    }

    // Ensure the distinct integral C types (short, int, long, long long, and their unsigned equivalents) divert to the correct overload according to size.
    template<int SIZE> struct IntTypeHash {};

    template<> struct IntTypeHash<4>
    {
        HK_INLINE static hkUint32 hash(hkUint32 i)
        {
            // Knuth's multiplicative hash.
            // The endian swap ensures that upper bits contribute.
            return hkEndian::swap(i * 2654435761U);
        }
    };

    template<> struct IntTypeHash<8>
    {
        HK_INLINE static hkUint32 hash(hkUint64 i)
        {
            // Ensure that upper and lower bits contribute.
            return combineHashValues(IntTypeHash<4>::hash(hkUint32(i >> 32)), IntTypeHash<4>::hash(hkUint32(i)));
        }
    };

    template<> struct IntTypeHash<2>
    {
        HK_INLINE static hkUint32 hash(hkUint16 i)
        {
            return IntTypeHash<4>::hash(i);
        }
    };

    /// Call the version which takes an unsigned value of the same size.
    template<typename T>
    HK_INLINE hkUint32 intTypeHash(T i) { return IntTypeHash<sizeof(T)>::hash(i); }

}

hkUint32 hkHash::hkHashValue(short i) { return intTypeHash(i); }
hkUint32 hkHash::hkHashValue(int i) { return intTypeHash(i); }
hkUint32 hkHash::hkHashValue(long i) { return intTypeHash(i); }
hkUint32 hkHash::hkHashValue(long long i) { return intTypeHash(i); }
hkUint32 hkHash::hkHashValue(unsigned short i) { return intTypeHash(i); }
hkUint32 hkHash::hkHashValue(unsigned i) { return intTypeHash(i); }
hkUint32 hkHash::hkHashValue(unsigned long i) { return intTypeHash(i); }
hkUint32 hkHash::hkHashValue(unsigned long long i) { return intTypeHash(i); }
hkUint32 hkHash::hkHashValue(_In_ const void* p) { return hkHashValue(reinterpret_cast<hkUlong>(p)); }
hkUint32 hkHash::hkHashValue(_In_z_ const char* str) { return str ? computeFNV1Hash32(str) : hkUint32(-1); }


template<typename R>
hkUint32 hkHash::hkHashValue(R(*ptr)()) { return hkHashValue(reinterpret_cast<hkUlong>(ptr)); }
template<typename R, typename P0>
hkUint32 hkHash::hkHashValue(R(*ptr)(P0)) { return hkHashValue(reinterpret_cast<hkUlong>(ptr)); }
template<typename R, typename P0, typename P1>
hkUint32 hkHash::hkHashValue(R(*ptr)(P0, P1)) { return hkHashValue(reinterpret_cast<hkUlong>(ptr)); }
template<typename R, typename P0, typename P1, typename P2>
hkUint32 hkHash::hkHashValue(R(*ptr)(P0, P1, P2)) { return hkHashValue(reinterpret_cast<hkUlong>(ptr)); }
template<typename R, typename P0, typename P1, typename P2, typename P3>
hkUint32 hkHash::hkHashValue(R(*ptr)(P0, P1, P2, P3)) { return hkHashValue(reinterpret_cast<hkUlong>(ptr)); }
template<typename R, typename P0, typename P1, typename P2, typename P3, typename P4>
hkUint32 hkHash::hkHashValue(R(*ptr)(P0, P1, P2, P3, P4)) { return hkHashValue(reinterpret_cast<hkUlong>(ptr)); }
template<typename R, typename P0, typename P1, typename P2, typename P3, typename P4, typename P5>
hkUint32 hkHash::hkHashValue(R(*ptr)(P0, P1, P2, P3, P4, P5)) { return hkHashValue(reinterpret_cast<hkUlong>(ptr)); }

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
