// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

#include <Common/Base/Algorithm/Sort/hkSort.h>

namespace hkAlgorithm
{
    // A few simple functions to help with finding the "best" element of an array
    // The evaluation and comparison functions are fully general, but some common implementations are provided as well

    //
    // Finding the index of the minimum/maximum
    //

    /// Returns the index that gives the minimum value for evalFunc
    template< typename T, typename EvalFunc, typename CompFunc >
    int HK_CALL findMinimumIndex(_In_reads_(N) const T *pArr, int N, const EvalFunc& evalFunc, CompFunc compFunc);

    /// Returns the index that gives the maximum value for evalFunc
    template< typename T, typename EvalFunc >
    int HK_CALL findMinimumIndex(_In_reads_(N) const T *pArr, int N, const EvalFunc& evalFunc);

    /// Returns the index that gives the minimum value (using compFunc for comparison) for evalFunc
    template< typename T, typename EvalFunc >
    int HK_CALL findMaximumIndex(_In_reads_(N) const T *pArr, int N, const EvalFunc& evalFunc);


    //
    // Finding the index and value of the minimum/maximum
    //

        /// Returns the index that gives the minimum value for evalFunc, and saves the value in valOut
    template< typename T, typename V, typename EvalFunc >
    int HK_CALL findMinimumIndexAndValue(_In_reads_(N) const T *pArr, int N, _Out_ V& valOut, const EvalFunc& evalFunc);

    /// Returns the index that gives the maximum value for evalFunc, and saves the value in valOut
    template< typename T, typename V, typename EvalFunc >
    int HK_CALL findMaximumIndexAndValue(_In_reads_(N) const T *pArr, int N, _Out_ V& valOut, const EvalFunc& evalFunc);

    /// Returns the index that gives the minimum value (using compFunc for comparison) for evalFunc, and saves the value in valOut
    template< typename T, typename V, typename EvalFunc, typename CompFunc >
    int HK_CALL findMinimumIndexAndValue(_In_reads_(N) const T *pArr, int N, _Out_ V& valOut, const EvalFunc& evalFunc, CompFunc compFunc);

    //
    // Helper struct
    //
    template< typename T, typename V, typename EvalFunc, typename CompareLess>
    struct _FindMinimumImpl
    {
    public:
        HK_INLINE _FindMinimumImpl(_In_reads_(n) const T* a, int n, const EvalFunc& evalFunc, CompareLess less);

        int m_bestIndex;
        V m_bestValue;
    };

}

#include <Common/Base/Algorithm/FindIndex/hkFindIndex.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
