// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT    : COMMON
// VISIBILITY : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

#pragma once

namespace hkAlgorithm
{
    // A few simple functions to help with finding elements of an array.
    // Generally in sync with STL <algorithm>.

    //
    // Finding an element
    //

        /// Find the first element which validates the given predicate.
        /// The predicate is a functor or lambda with the signature 'bool(T&)' where T
        /// is the type returned by dereferencing the Iterator type.
        /// Example:
        ///   auto it = findIf( array.begin(), array.end(), [value]( const T& item ) { return item.m_field == value; } );
    template <typename Iterator, typename UnaryPredicate>
    Iterator HK_CALL findIf( Iterator begin, Iterator end, UnaryPredicate pred );

        /// Overload for hkArrayView.
    template <typename T, typename UnaryPredicate>
    HK_ALWAYS_INLINE typename hkArrayView<T>::iterator HK_CALL findIf( hkArrayView<T> view, UnaryPredicate pred )
    {
        return findIf( view.begin(), view.end(), pred );
    }
}

#include <Common/Base/Algorithm/Find/hkFind.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
