// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0

inline hk_size_t HK_CALL hkBufferCompression::compressBuffer(_In_reads_bytes_(inlen) const void* in, hk_size_t inlen, _Out_writes_(outlen) void* out, hk_size_t outlen, hkBool fastest)
{
    HK_ASSERT(0x47b7e947, in != nullptr, "Invalid input buffer");
    HK_ASSERT(0x47d7e890, out != nullptr, "Invalid output buffer");

    hk_size_t compressedSize;
    if (fastest)
    {
        compressedSize = hashCompress(in, inlen, out, outlen);
    }
    else
    {
        compressedSize = suffixTreeCompress(in, inlen, out, outlen);
    }

#ifdef HK_DEBUG_SLOW
    if (compressedSize)
    {
        hkUchar* block = hkMemTempBlockAlloc<hkUchar>((int)inlen);
        void* buf = block;
        hkResult res = decompressBuffer(out, compressedSize, buf, inlen);
            HK_ASSERT_NO_MSG(0x62d1b071, res.isSuccess());
        HK_ASSERT_NO_MSG(0x528d911b, block + int(inlen) == buf);
        HK_ASSERT_NO_MSG(0x597ae5e1, hkString::memCmp(block, in, (int)inlen) == 0);
        hkMemTempBlockFree(block, (int)inlen);
    }
#endif

    return compressedSize;
}

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
