// TKBMS v1.0 -----------------------------------------------------
//
// PLATFORM   : ALL
// PRODUCT   : COMMON
// VISIBILITY   : PUBLIC
//
// ------------------------------------------------------TKBMS v1.0
#pragma once

/// These are low-level compression routines for single buffers.
/// For a more user-friendly interface, see hkCompression.h.
/// For a streaming interface, see hkCompressedStreamReader and hkCompressedStreamWriter.
namespace hkBufferCompression
{
    /// Decompress "inlen" bytes starting at "in" into the buffer of "outlen" bytes starting at "out".
    /// out_start is modified to point one-past-the-last byte written.
    HK_EXPORT_COMMON hkResult HK_CALL decompressBuffer(_In_reads_bytes_(inlen) const void* in, hk_size_t inlen, _Outref_result_bytebuffer_(outlen) void*& out, hk_size_t outlen);

    /// Compress "inlen" bytes starting at "in" into the buffer of "outlen" bytes starting at "out".
    /// If there was not enough room in the output buffer for the compressed data, returns 0.
    /// Otherwise returns the number of bytes of output produced.
    /// "fastest" selects between the hash compression algorithm (reasonable compression ratio, quite fast) and the
    /// suffix-tree compression algorithm (produces optimal compressed streams, slow).
    /// Decompression speed is not affected by this parameter.
    inline hk_size_t HK_CALL compressBuffer(_In_reads_bytes_(inlen) const void* in, hk_size_t inlen, _Out_writes_(outlen) void* out, hk_size_t outlen, hkBool fastest = true);

    /// Compress using a hashing tree. This gives good compression at reasonable speed.
    HK_EXPORT_COMMON hk_size_t HK_CALL hashCompress(_In_reads_bytes_(inlen) const void* in, hk_size_t inlen, _Out_writes_(outlen) void* outbuf, hk_size_t outlen);

    /// Compress using a suffix tree. This gives optimal compression in exchange for
    /// memory and speed.
    HK_EXPORT_COMMON hk_size_t HK_CALL suffixTreeCompress(_In_reads_bytes_(length) const void* data, hk_size_t length, _Out_writes_(outlength) void* outbuf, hk_size_t outlength);
}

#include <Common/Base/Algorithm/Compression/hkBufferCompression.inl>

/*
 * Havok SDK - Base file, BUILD(#20180110)
 * 
 * Confidential Information of Microsoft Corporation.
 * Not for disclosure or distribution without Microsoft's prior written
 * consent.  This software contains code, techniques and know-how which
 * is confidential and proprietary to Microsoft.  Product and Trade Secret
 * source code contains trade secrets of Microsoft.  Havok Software (C)
 * Copyright 1999-2018 Microsoft Corporation.
 * All Rights Reserved. Use of this software is subject to the
 * terms of an end user license agreement.
 * 
 * The Havok Logo, and the Havok buzzsaw logo are trademarks of Microsoft.
 * Title, ownership rights, and intellectual property rights in the Havok
 * software remain in Microsoft and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and
 * indicates acceptance of the End User licence Agreement for this
 * product. A copy of the license is included with this software and is
 * also available from Havok Support.
 * 
 */
