"""
Generate deterministic guid's from a string
"""
import string

def getGuidFromHash(string):
    """
    Returns a GUID based on strings hash function value (str.__hash__())
    """
    uniqueId = hex(abs(string.__hash__())).upper()[2:]
    guid = []
    for idx, ch in enumerate("????????-????-4???-????-????????????"):
        if ch == "?":
            ch = uniqueId[idx % len(uniqueId)]
        guid.append(ch)
    # GUIDs need to be uppercase
    guidString = ''.join(guid).upper()
    return guidString
