DEPSFILE = $(wildcard Makefile.deps)
INTERNALFILE = $(wildcard $(MAKE_DIR)/../ReleaseSystem/build.py)
ifneq "$(INTERNALFILE)" ""
INTERNAL_BUILD = 1
ERROR_STR = Example usage: make TARGET=ps3 COMPILER=gcc project
else
INTERNAL_BUILD = 0
ERROR_STR = Example usage: make TARGET=ps3 COMPILER=gcc COMPILER_VERSION=4-1-1 project
DEPSFILE =
endif

ifeq "$(origin TARGET)" "undefined"
$(error $(ERROR_STR))
endif

REPORT_SOURCE_ERROR = (>&2 echo "ERROR: " $< ; (exit 1))
REPORT_TARGET_ERROR = (>&2 echo "ERROR: " $@ ; (exit 1))

# os-specific
ifeq "$(basename $(SHELL))" "/bin/sh"
	MKDIRS = mkdir -p $@
	RM_CLEAN = rm -r -f $(MODULE_OBJDIR) $(TARGET_PATH) *.ii *.s
	RM = rm -r -f
	NULL_CMD = true
	MV := mv -f
	CP := cp -f --preserve=all
	PATHSWAP = $(1)
	RM_TARGET = rm -r -f $@
else
	CMD = cmd /C
	MKDIRS = $(CMD) "if not exist $(patsubst %\,%,$(subst /,\,$@)) mkdir $(patsubst %\,%,$(subst /,\,$@))"
	RM_CLEAN = -$(CMD) "del /S /F /Q $(subst /,\, $(MODULE_OBJDIR) $(TARGET_PATH)) *.ii *.s"
	RM = del /S /Q /F
	NULL_CMD = rem
	MV := copy /Y
	CP := copy /Y
	PATHSWAP = $(subst /,\,$(1))
	RM_TARGET = -$(CMD) "if exist $(patsubst %\,%,$(subst /,\,$@)) del /S /Q /F $(patsubst %\,%,$(subst /,\,$@)) > nul"
endif

ifeq "$(VERBOSE)" "0"
	ECHO := @echo
	QUIET := @
	MAKE += --no-print-directory
else
	ECHO := @$(NULL_CMD)
	QUIET :=
endif

PYTHON_INTERPRETER := python

.PHONY: help
help:
	@echo ""
ifeq "$(INTERNAL_BUILD)" "1"
	@echo $(TARGET) - $(COMPILER)
	@echo ""
endif
	@echo "Options:"
	@echo "--------"
	@echo "    project            : this project only, does not check libraries"
	@echo "    recursive          : this project and prerequisite libs"
	@echo "    clean              : cleans this project only"
	@echo "    cleanrecursive     : cleans this project and prerequisite libs"
	@echo "    cleanlibs          : cleans projects lib or .exe only"
	@echo "    cleanlibsrecursive : cleans this projects .exe and prerequisite libs"

.PHONY: project
project : build

FILELIST_ARGS :=
ifneq "$(VARIANT)" ""
	FILELIST_ARGS := $(FILELIST_ARGS)_$(VARIANT)
endif

include $(TARGET)_$(COMPILER)$(FILELIST_ARGS).filelist

#Define output and build directories if they haven't already been specified by the user
LIBDIR ?= $(TOPDIR)/Lib
OBJDIR ?= $(TOPDIR)/Obj

SRCDIR := $(TOPDIR)/Source

TARGET_VARIANT = $(VARIANT_$(TARGET)-$(COMPILER))
MODULE_OBJDIR = $(OBJDIR)/$(TARGET_VARIANT)/$(MODULE_NAME)
MODULE_LIBDIR = $(LIBDIR)/$(TARGET_VARIANT)

ifeq "$(COMPILER)" "ghs"
	START_LIB_GROUP =
	END_LIB_GROUP =
else
    ifeq "$(TARGET)" "nacl32"
		START_LIB_GROUP = --start-group
		END_LIB_GROUP = --end-group
	else
		ifeq "$(TARGET)" "nacl64"
			START_LIB_GROUP = --start-group
			END_LIB_GROUP = --end-group
		else
			START_LIB_GROUP = -Wl,--start-group
			END_LIB_GROUP = -Wl,--end-group
		endif
	endif
endif

ifneq "$(TARGET)" "ctr"
	LIBPATHOPT = -L
	LIBPREFIXOPT = -l
	LIBPOSTFIXOPT =
else
	LIBPATHOPT := --userlibpath=
	LIBPREFIXOPT =
	LIBPOSTFIXOPT = .a
	START_LIB_GROUP =
	END_LIB_GROUP =
endif

LIBPREFIX = lib
LIBEXT = .a

include $(MAKE_DIR)/$(TARGET)-$(COMPILER).mk

ifeq "$(INTERNAL_BUILD)" "1"
ifeq "$(COMPILER)" "gcc-dontmatch"
DEPENDOPTIONS = -MMD
else
DEPENDOPTIONS =
include $(DEPSFILE)
endif
endif
ifeq "$(origin COMPILER)" "undefined"
$(error $(ERROR_STR))
endif

include $(MAKE_DIR)/HavokScriptGlobals.mk

# Reduce the list of dependencies to those that are present locally:
ifeq "$(INTERNAL_BUILD)" "0"
	# DEP_EXISTS includes variant handling:
	# e.g. dep = ../../../../Source/Behavior/Behavior.BehaviorScriptDisabled (i.e. a variant of Source/Behavior/Behavior called BehaviorScriptDisabled)
	#      basename(dep) = ../../../../Source/Behavior/Behavior
	#      subst(basename(dep), dep, wildcard(basename(dep))) = check for the variant's root dir and if it exists keep the variant, not its dir, in the dependencies list
	# TODO: DEP_EXISTS would be better if it checked the specific makefile needed to build the current variant, rather than just the directory that contains that makefile.
	DEP_EXISTS = $(subst $(basename $(dep)),$(dep),$(wildcard $(basename $(dep))))
	DEPENDENCIES_$(TARGET)-$(COMPILER) := $(foreach dep,$(DEPENDENCIES_$(TARGET)-$(COMPILER)),$(DEP_EXISTS))
endif

OPT_SIZE_OBJSUFFIX := $(OBJSUFFIX)_os
FORCEDFULLDEBUG_OBJSUFFIX := $(OBJSUFFIX)_ffd

OBJECTS                 := $(addprefix $(MODULE_OBJDIR)/, $(addsuffix $(OBJSUFFIX),                 $(notdir $(basename $(SOURCE)))))
OPT_FOR_SIZE_OBJECTS    := $(addprefix $(MODULE_OBJDIR)/, $(addsuffix $(OPT_SIZE_OBJSUFFIX),        $(notdir $(basename $(OPT_FOR_SIZE_SOURCE)))))
FORCEDFULLDEBUG_OBJECTS := $(addprefix $(MODULE_OBJDIR)/, $(addsuffix $(FORCEDFULLDEBUG_OBJSUFFIX), $(notdir $(basename $(FORCEDFULLDEBUG_SOURCE)))))

OUR_LIBS                 := $(addprefix $(MODULE_LIBDIR)/, $(addprefix $(LIBPREFIX), $(addsuffix $(LIBEXT), $(notdir $(basename $(LIBS_$(TARGET)-$(COMPILER)))))))

OBJ_DIRS        := $(sort $(dir $(OBJECTS) $(OPT_FOR_SIZE_OBJECTS) $(FORCEDFULLDEBUG_OBJECTS)))
LIBRARY_PATH    := $(MODULE_LIBDIR)/$(LIBPREFIX)$(MODULE_NAME)$(LIBSUFFIX)

# WARINING: Don't change this patterns without updating moduleInfo.getTargetName also.
ifeq "$(OUTPUT_DIR)" ""
	EXECUTABLE_PATH := $(EXEPREFIX)$(MODULE_NAME)_$(TARGET)_$(COMPILER)$(MAKEFILE_ARGS)_$(HK_LINK_TYPE)$(EXESUFFIX)
else
	OUTPUT_DIR := $(OUTPUT_DIR)/$(HK_LINK_TYPE)
	EXECUTABLE_PATH := $(OUTPUT_DIR)/$(EXEPREFIX)$(MODULE_NAME)_$(TARGET)_$(COMPILER)$(MAKEFILE_ARGS)_$(HK_LINK_TYPE)$(EXESUFFIX)
endif

# The list of object files is saved to a file due to cmdline size limits in the default build envs
OBJECTS_LIST_FOR_AR = @$(TARGET)_$(COMPILER)$(MAKEFILE_ARGS)_$(HK_LINK_TYPE).obj_filelist
OBJECTS_LIST_FOR_LINK = @$(TARGET)_$(COMPILER)$(MAKEFILE_ARGS)_$(HK_LINK_TYPE).obj_filelist

# Temporary fix for link error on ps3-snc - should fix properly
ifeq "$(COMPILER)" "snc"
	OBJECTS_LIST_FOR_AR = $(OBJECTS)
endif

VPATH = $(addsuffix :,$(sort $(dir $(SOURCE) $(OPT_FOR_SIZE_SOURCE) $(FORCEDFULLDEBUG_SOURCE))))

ifeq "$(MODULE_TYPE)" "lib"
	TARGET_PATH := $(LIBRARY_PATH)
else
	TARGET_PATH := $(EXECUTABLE_PATH)
endif

.PHONY: make_objdirs
make_objdirs : $(OBJ_DIRS)

$(OBJ_DIRS) :
	$(QUIET)$(MKDIRS)

.PHONY: make_libdirs
make_libdirs : $(MODULE_LIBDIR)

$(MODULE_LIBDIR) :
	$(QUIET)$(MKDIRS)


.PHONY: link
link: $(TARGET_PATH)

.PHONY: build
build : make_libdirs make_objdirs $(filelist)
	$(QUIET)$(MAKE) -k -r link

.PHONY: clean
clean :
	$(QUIET)$(RM_CLEAN)

.PHONY: cleanlibs
cleanlibs :
	rm -r -f $(TARGET_PATH)

-include $(MODULE_OBJDIR)/*.d

$(MODULE_OBJDIR)/%.o : %.cpp
	$(ECHO) $(PLATFORM_NAME) $(notdir $(TARGET_PATH)) ":" $(notdir $<)
	$(QUIET)$(CXX) $(DEPENDOPTIONS) $(STANDARD_CXXFLAGS) $(CXXFLAGS_$(TARGET)-$(COMPILER)) $(DEFINES) $(DEFINES_$(TARGET)-$(COMPILER)) $(SCRIPT_DEFINES) $(INCLUDES) $(INCLUDES_$(TARGET)-$(COMPILER)) -o $@ -c $< || $(REPORT_SOURCE_ERROR)

$(MODULE_OBJDIR)/%.o : %.c
	$(ECHO) $(PLATFORM_NAME) $(notdir $(TARGET_PATH)) ":" $(notdir $<)
	$(QUIET)$(CC) $(DEPENDOPTIONS) $(STANDARD_CXXFLAGS) $(CXXFLAGS_$(TARGET)-$(COMPILER)) $(DEFINES) $(DEFINES_$(TARGET)-$(COMPILER)) $(INCLUDES) $(INCLUDES_$(TARGET)-$(COMPILER)) -o $@ -c $< || $(REPORT_SOURCE_ERROR)

$(MODULE_OBJDIR)/%.o_os : %.cpp
	$(ECHO) "OPT_SIZE" $(PLATFORM_NAME) $(notdir $(TARGET_PATH)) ":" $(notdir $<)
	$(QUIET)$(CXX) $(DEPENDOPTIONS) $(OPT_SIZE_CXXFLAGS) $(CXXFLAGS_$(TARGET)-$(COMPILER)) $(DEFINES) $(DEFINES_$(TARGET)-$(COMPILER)) $(SCRIPT_DEFINES) $(INCLUDES) $(INCLUDES_$(TARGET)-$(COMPILER)) -o $@ -c $< || $(REPORT_SOURCE_ERROR)

$(MODULE_OBJDIR)/%.o_ffd: %.cpp ForceFFDRecompile
	$(ECHO) "FULLDEBUG: " $(notdir $<)
	$(QUIET)$(CXX) $(FORCEDFULLDEBUG_CXXFLAGS) $(CXXFLAGS_$(TARGET)-$(COMPILER)) $(DEFINES) $(DEFINES_$(TARGET)-$(COMPILER)) $(SCRIPT_DEFINES) $(INCLUDES) $(INCLUDES_$(TARGET)-$(COMPILER)) -o $@ -c $< || $(REPORT_SOURCE_ERROR)

$(MODULE_OBJDIR)/%.o : %.dsm
	$(QUIET)$(ECHO) $(notdir $<)
ifeq "$(origin USERPROFILE)" "undefined"
	$(QUIET)$(CXX) -E -xc $< | $(AS) $(SCE_INCLUDES) -o $@
else
	$(QUIET)$(CMD) "$(subst /,\,$(CXX)) -E -xc $< | $(subst /,\,$(AS)) $(SCE_INCLUDES) -o $@"
endif

ForceFFDRecompile:

$(LIBRARY_PATH) : $(OBJECTS) $(OPT_FOR_SIZE_OBJECTS) $(FORCEDFULLDEBUG_OBJECTS)
	$(ECHO) $(PLATFORM_NAME) $(notdir $@) ":" Linking library...
	$(QUIET)$(RM_TARGET)
	$(QUIET)$(AR) $@ $(OBJECTS_LIST_FOR_AR) $(OPT_FOR_SIZE_OBJECTS) $(FORCEDFULLDEBUG_OBJECTS) || $(REPORT_TARGET_ERROR)

$(OUTPUT_DIR):
	$(QUIET)$(MKDIRS)

$(EXECUTABLE_PATH) : $(OBJECTS) $(OPT_FOR_SIZE_OBJECTS) $(FORCEDFULLDEBUG_OBJECTS) $(COMPILED_LIBS_$(TARGET)-$(COMPILER)) $(OUR_LIBS) $(OUTPUT_DIR)
	$(ECHO) $(PLATFORM_NAME) $(notdir $@) ":" Linking executable...
	$(QUIET)$(LINK_LIB)
	$(QUIET)$(LINK_EXE_PRE)
	$(QUIET)$(LD) -o $@ $(LDFLAGS) $(LDFLAGS_$(TARGET)-$(COMPILER)) \
		$(LIBPATH_$(TARGET)-$(COMPILER)) $(LIBPATHOPT)$(MODULE_LIBDIR) $(LIBPATH) \
		$(LINKER_SCRIPT) \
		$(START_LIB_GROUP) $(OBJECTS_LIST_FOR_LINK) $(FORCEDFULLDEBUG_OBJECTS) $(OPT_FOR_SIZE_OBJECTS) $(LINK_SPECIALS) \
		$(addsuffix $(LIBPOSTFIXOPT), $(addprefix $(LIBPREFIXOPT),$(LIBS_$(TARGET)-$(COMPILER)))) \
                $(addsuffix $(LIBPOSTFIXOPT), $(addprefix $(LIBPREFIXOPT),$(OTHER_LIBS_$(TARGET)-$(COMPILER)))) \
		$(COMPILED_LIBS_$(TARGET)-$(COMPILER)) $(EXTRA_LIBS) $(END_LIB_GROUP) $(addprefix $(LIBPREFIXOPT),$(POST_GROUP_LIBS)) $(POST_LIB_GROUP_LDFLAGS) || $(REPORT_TARGET_ERROR)

ifdef LINK_REPLACE_HBR
	$(ECHO) "Running replace_hbr.pl"
	-$(QUIET)$(LINK_REPLACE_HBR) $(notdir $@)
endif
ifdef LINK_MAKE_SELF
	$(ECHO) $(PLATFORM_NAME) "Making self"
	$(QUIET)$(LINK_MAKE_SELF) $@ $(addsuffix .self, $(basename $@))
endif
ifdef LINK_MAKE_CCI
	$(ECHO) $(PLATFORM_NAME) "Making Rom (CCI)"
	$(QUIET)$(LINK_MAKE_CCI) $@ -rsf ctr.rsf -desc "$(CTRSDK_ROOT)/resources/specfiles/Application.desc" -o $(addsuffix .cci, $(basename $@)) -f card
endif
ifdef LINK_COPY_SELF_TO_DEMOS_DIR
	$(QUIET)$(CP) $@ $(call PATHSWAP, $(TOPDIR)/demo/demos)
	$(QUIET)$(CP) $(addsuffix .self, $(basename $@)) $(call PATHSWAP, $(TOPDIR)/demo/demos)
endif
ifdef LINK_MAKE_PRX
	$(ECHO) $(PLATFORM_NAME) "making prx"
	$(QUIET)$(LINK_MAKE_PRX) $@ -r $(addsuffix .prx, $(basename $(MODULE_NAME)$(EXESUFFIX)))
	$(QUIET)$(CP) $(addsuffix .prx, $(basename $(MODULE_NAME)$(EXESUFFIX))) $(addsuffix .prx, $(basename $@))
endif

# For Android we can optionally invoke makeandroidpackage.bat to sign and deploy the generated exectutable
# We don't want to do this for every module so first we check if a batch file exists in the current module
ifdef LINK_MAKE_APK
ifneq ($(strip $(ANDROIDBATCHFILE)),)
	$(ECHO) $(PLATFORM_NAME) "Making Package (APK, debug signed)"
	$(QUIET)$(LINK_MAKE_APK) $@ $(basename $@) $(EXEPREFIX)$(MODULE_NAME)$(EXESUFFIX) $(INSTALL_APK)
endif # End ANDROIDBATCHFILE exists check
endif # End check if LINK_MAKE_APK defined

ifdef LINK_EXE_POST
	$(ECHO) "Running post-build command"
	$(QUIET)$(LINK_EXE_POST)
endif
ifdef POST_BUILD_STEPS
	$(QUIET)$(POST_BUILD_STEPS)
endif

symbols:
	$(NM) -S  -n $(EXECUTABLE_PATH) >$(EXECUTABLE_PATH).symbols
	$(NM) -S  -n $(EXECUTABLE_PATH) >$(EXECUTABLE_PATH).symsort --size-sort

.PHONY: recursive
recursive : make_libdirs make_objdirs $(addsuffix .recurse, $(DEPENDENCIES_$(TARGET)-$(COMPILER))) $(filelist)
	$(QUIET)$(MAKE) -k -r link

.PHONY: cleanrecursive
cleanrecursive : $(addsuffix .cleanrecursive, $(DEPENDENCIES_$(TARGET)-$(COMPILER))) clean

.PHONY: cleanlibsrecursive
cleanlibsrecursive : $(addsuffix .cleanlibsrecursive, $(DEPENDENCIES_$(TARGET)-$(COMPILER))) cleanlibs

# $@ = a recursive dependency, e.g. ../../../../Source/Behavior/Behavior.BehaviorScriptDisabled.recurse
# The ".BehaviorScriptDisabled" part, indicating a variant, may or may not be present:
#     $(basename $(basename $@)) -> ../../../../Source/Behavior/Behavior whether the dependency is a variant or not.
#     $(subst .,,$(suffix $(basename $@))) -> either nothing or the variant name (e.g. VARIANT:=BehaviorScriptDisabled)
# When called recursively the VARIANT argument is used for both the compiler variant (e.g. noSimd) and module variant (see above)
# We set up FULL_VARIANT to be '_'.join([compilerVariant, moduleVariant]).

# We need a variable equalling ' ', below works because += always space separates the value of the variable with the appended text
space :=
space +=

# joins the elements of $2 using the seperator $1, e.g.
# 	$(call join-with,-,this is a list) -> this-is-a-list
# 	$(call join-with,-,oneelement) -> oneelement
join-with = $(subst $(space),$1,$(strip $2))

FULL_VARIANT = $(call join-with,_, $(VARIANT) $(subst .,,$(suffix $(basename $@))))  # join using '_' as sep

%.recurse:
	$(QUIET)$(MAKE) -k -r -C $(basename $(basename $@)) VARIANT:=$(FULL_VARIANT) project

%.cleanrecursive:
	$(QUIET)$(MAKE) -k -C $(basename $(basename $@)) VARIANT:=$(FULL_VARIANT) clean

%.cleanlibsrecursive:
	$(QUIET)$(MAKE) -k -C $(basename $(basename $@)) VARIANT:=$(FULL_VARIANT) cleanlibs

# Indentation is significant to make when the indented block lies within a rule context.
# The following (handy) assignment allows indentation to follow by terminating the cleanlibsrecursive rule context.
ifeq "$(INTERNAL_BUILD)" "1"
	ifndef DEPENDOPTIONS
		include $(DEPSFILE)
	endif
endif
