#
# Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
# prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
# Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
#
#! /usr/bin/env python

###
### This script contains a list of python classes used to represents
### elements in the reflection database.
###

import xml.dom.minidom
import os
import re
import util


overridetypeMacros = {"hkZeroPtr":"hkZero<void*>",
                      "hkZeroPtrArray":"hkZero<hkArray<void*>>"}


class domElemError(Exception):
    def __init__(self, msg):
        Exception.__init__(self, msg)
#
## Utility methods
#
def dump(o):
    ret = []
    for k in dir(o):
        ret.append("%s : %s" % (k, getattr(o,k)))
    return "\n".join(ret)
def all_slot_names(klass):
    todo = [klass]
    cl = [klass]
    while len(todo):
        k = todo.pop()
        cl.extend( list(k.__bases__) )
        todo.extend( list(k.__bases__) )
    for k in cl:
        if hasattr(k,"__slots__"):
            for s in k.__slots__:
                yield s
def slot_values_as_keywords(o):
    return ",".join( ["%s=%s" % (a, str(getattr(o,a))) for a in all_slot_names(o.__class__) if getattr(o,a) ] )

#
## Schema representation as python objects
#

class Object(object):
    __slots__= ("name","comment")

    def __init__(self):
        self.name = ""
        self.comment = []

class EnumItem(Object):
    __slots__ = ("value", "initializer", "description")
    def __init__(self):
        Object.__init__(self)
        self.value = None # integer value
        self.initializer = "" # string value e.g. "0x5" or "FOO_8"
        self.description = ""

class Enum(Object):
    __slots__ = ("description", "item", "scope", "defineflags", "reflected")
    def __init__(self):
        Object.__init__(self)
        self.description = ""
        self.item = []
        self.scope = None
        self.defineflags = False
        self.reflected = True
    def full_scope(self,separator="::"):
        r = []
        s = self.scope
        while s:
            r.append( s.name )
            s = s.scope
        r.reverse()
        return separator.join(r)

class TaggedUnion(Enum):
    def __init__(self):
        Enum.__init__(self)

class TaggedUnionItem(EnumItem):
    __slots__ = ("klass",)
    def __init__(self):
        EnumItem.__init__(self)
        self.klass = None

class Class(Object):
    __slots__ = ("abstract", "vtable", "description", "reflected",
                 "parent", "interface", "enum", "_class", "member",
                 "method", "fromheader", "scope", "typedef", "memory_declaration",
                 "serializable", "attributes", "defineattribute", "version",
                 "memberprefix", "tracked_member", "location", "override_name")
    def __init__(self):
        Object.__init__(self)
        self.abstract = False
        self.vtable = False
        self.description = ""
        self.reflected = False
        self.parent = None
        self.interface = []
        self.enum = []
        self._class = []
        self.member = []
        self.method = []
        self.fromheader = False
        self.scope = None
        self.typedef = {}
        self.memory_declaration = None
        self.serializable = True
        self.attributes = {}
        self.defineattribute = False
        self.version = 0
        self.memberprefix = "m_"
        self.tracked_member = []
        self.location = None
        self.override_name = None

    def full_scope(self,separator="::"):
        assert separator == "::"
        assert type(self.scope) == type("")
        return self.scope + self.name

class Interface(Object):
    __slots__ = ()
    def __init__(self):
        Object.__init__(self)

class Member(Object):
    __slots__ = (
        "declaredtype", "overridetype", "embedtype", "overrideoffset", 
        "type", "description", "visibility",
        "default", "absmin", "absmax", "softmin", "softmax", "owned",
        "flags", "align", "sourcecode", "reflected", "serialized", "attributes",
        "memory_tracked", "has_memberprefix")
    def __init__(self):
        Object.__init__(self)
        self.declaredtype = None
        self.overridetype = None
        self.embedtype = None
        self.overrideoffset = None
        self.type = ""
        self.description = ""
        self.visibility = ""
        self.default = None
        self.absmin = None
        self.absmax = None
        self.softmin = None
        self.softmax = None
        self.owned = True
        self.flags = ""
        self.align = 0
        self.sourcecode = ""
        self.reflected = True
        self.serialized = True
        self.attributes = {}
        self.memory_tracked = True
        self.has_memberprefix = True

class Parameter(Object):
    __slots__ = ("type", "description", "default")
    def __init__(self):
        Object.__init__(self)
        self.description = ""
        self.type = None
        self.default = None

class Method(Object):
    __slots__ = ("description", "visibility", "inline", "static",
                 "virtual", "purevirtual", "const", "returns", "parameter")
    def __init__(self):
        Object.__init__(self)
        self.description = ""
        self.visibility = ""
        self.inline = True
        self.static = False
        self.virtual = False
        self.purevirtual = False
        self.const = False
        self.returns = ""
        self.parameter = []

class File(Object):
    __slots__ = (
                 "product", "platform", "visibility",
                 "overridedestination", "includeheaders",
                 "enum", "struct", "_class", "taggedunion")
    def __init__(self):
        Object.__init__(self)
        self._class = []
        self.enum = []
        self.struct = []
        self.product = ""
        self.platform = ""
        self.visibility = ""
        self.overridedestination = ""
        self.includeheaders = ""
        self.taggedunion = []

    def mergeWith(self, file):
        self.product = util.mergeTags(self.product, file.product)
        self.platform = util.mergeTags(self.platform, file.platform)
        self._class.extend(file._class)
        self.enum.extend(file.enum)
        self.struct.extend(file.struct)
        self.taggedunion.extend(file.taggedunion)
    def destinationFilename(self, filepath, newextenstion):
        stem, ext = os.path.splitext( filepath )
        if self.overridedestination:
            head, tail = os.path.split( stem )
            stem = os.path.normpath( os.path.join(head, self.overridedestination, tail) )
        return (stem + newextenstion).replace("\\","/")

class Document(Object):
    __slots__ = ("file", "origfilename", "localfilename", "basefilename", "pchfile")
    def __init__(self, pathname, project_dir = None):
        Object.__init__(self)
        self.file = None
        self.origfilename = pathname # unchanged, passed to ctor
        self.localfilename = pathname # relative to include path
        self.basefilename = os.path.basename(pathname) # base file name
        self.pchfile = ""
        # try to canonicalize the filename and find the pch and relative include
        realname = []
        leading = os.path.abspath(pathname)
        while len(leading) and leading not in (os.path.sep, os.path.altsep):
            leading, tail = os.path.split( leading )
            if tail:
                realname.insert(0, tail)
            else: # Handle drive names split("c:\\") -> "c:\\", "".
                # We dont want missing settings.build warnings when the customer is rebuilding havokassembly.
                # To avoid this we check for the existence of build.py, and do not warn if this is a release build.
                if os.path.exists('../../Build/ReleaseSystem/build.py'):
                    print "Couldn't find reflectionSettings.cache in a parent of", pathname
                break

            if project_dir:
                reflectionSettingsFile = os.path.join(project_dir, 'reflectionSettings.cache')
            else:
                reflectionSettingsFile = os.path.join(leading, 'reflectionSettings.cache')

            if os.path.exists(reflectionSettingsFile):
                # We need to explicitly remove all '\r' characters otherwise eval fails on linux.
                reflectionSettings = eval(open(reflectionSettingsFile).read().replace('\r\n','\n' ))
                if 'setPchFile' in reflectionSettings:
                    self.pchfile = reflectionSettings['setPchFile'][0]
                for includePath in reflectionSettings['addIncludePath']:
                    separatedIncludePath = includePath.lower().replace("\\", "/") # make it case-insensitive
                    # Don't modify paths that are already absolute
                    if separatedIncludePath.find(":/") == -1 and not separatedIncludePath.startswith("/"):
                        separatedIncludePath = "/" + separatedIncludePath
                    if not separatedIncludePath.endswith("/"):
                        separatedIncludePath = separatedIncludePath + "/"
                    index = leading.lower().replace("\\", "/").rfind(separatedIncludePath)
                    if index > -1:
                        e = index + len(separatedIncludePath)
                        self.localfilename = os.path.join( leading[e:] , *realname )
                        return

                self.localfilename = os.path.join( os.path.basename(leading) , *realname )
                break

#
# Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
# 
# Confidential Information of Havok.  (C) Copyright 1999-2014
# Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
# Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
# rights, and intellectual property rights in the Havok software remain in
# Havok and/or its suppliers.
# 
# Use of this software for evaluation purposes is subject to and indicates
# acceptance of the End User licence Agreement for this product. A copy of
# the license is included with this software and is also available at www.havok.com/tryhavok.
# 
#