#
# Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
# prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
# Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
#
"""
Set package relative paths
"""

import os
import inspect

SCRIPT_DIR = os.path.abspath(os.path.dirname(inspect.getfile(inspect.currentframe())))
# NOTE: When moving the package or using this file to initialize a new package.
# Adjust the number of os.pardir instances here if needed.
RSYS_ROOT = os.path.normpath(os.path.join(SCRIPT_DIR, os.pardir, "ReleaseSystem"))

__path__ = [SCRIPT_DIR, os.path.join(RSYS_ROOT, "BuildSystem", "Init")]

import initUtils

HAVOK_ROOT = initUtils.getHavokRoot(RSYS_ROOT)
#
# Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
# 
# Confidential Information of Havok.  (C) Copyright 1999-2014
# Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
# Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
# rights, and intellectual property rights in the Havok software remain in
# Havok and/or its suppliers.
# 
# Use of this software for evaluation purposes is subject to and indicates
# acceptance of the End User licence Agreement for this product. A copy of
# the license is included with this software and is also available at www.havok.com/tryhavok.
# 
#