/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HKCD_VERTEX_H
#define HKCD_VERTEX_H


	/// A class holding a position and a 16-bit id in the .w component.
class HK_EXPORT_COMMON hkcdVertex : public hkVector4
{
	public:

		HK_DECLARE_NONVIRTUAL_CLASS_ALLOCATOR( HK_MEMORY_CLASS_COLLIDE, hkcdVertex );
		HK_DECLARE_POD_TYPE();

		HK_FORCE_INLINE const hkcdVertex& operator=( const hkcdVertex& p ) { assign(p); return *this; }

			/// Overwrite self with an hkVector4
		HK_FORCE_INLINE void assign( hkVector4Parameter p ) { m_quad = p.m_quad; }

			/// Extract the 16 bit id from the .w component.
		HK_FORCE_INLINE int getId() const { return getInt16W(); }
};

#endif // HKCD_VERTEX_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
