/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
#ifndef HK_SERIALIZE_VERSIONUTIL_H
#define HK_SERIALIZE_VERSIONUTIL_H

class hkClassNameRegistry;
class hkPackfileReader;

/// Versioning utility functions and structures.
namespace hkVersionUtil
{
		/// Get the current SDK version as written in packfiles.
	HK_EXPORT_COMMON const char* HK_CALL getCurrentVersion();

		/// Copies the old named member to the new named member.
		/// The members must have identical sizes.
	HK_EXPORT_COMMON void HK_CALL renameMember( hkVariant& oldObj, const char* oldName, hkVariant& newObj, const char* newName );

		/// Copy defaults for new members.
		/// For each member in newClass which is not in oldClass and which
		/// has a specified default, copy it in into obj.
	HK_EXPORT_COMMON void HK_CALL copyDefaults( void* obj, const hkClass& oldClass, const hkClass& newClass );

		/// Utility function to recompute member offsets.
	HK_EXPORT_COMMON void HK_CALL recomputeClassMemberOffsets( hkClass*const* classes, int classVersion );
}

#endif // HK_SERIALIZE_VERSIONUTIL_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
