/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

// Physics specific product patches applied to release 2013_3.
// This file is #included by hknpPatches_2013_3.cpp

HK_PATCH_BEGIN("hknpVehicleRayCastWheelCollide", 0, "hknpVehicleRayCastWheelCollide", 1)
	HK_PATCH_MEMBER_REMOVED("wheelCollisionFilterInfo", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hknpBodyQuality", 0, "hknpBodyQuality", 1)
	HK_PATCH_MEMBER_REMOVED("liveJacobianDistanceThreshold", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("liveJacobianAngleThreshold", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("contactCachingRelativeMovementThreshold", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hknpWorldCinfo", 3, "hknpWorldCinfo", 4)
	HK_PATCH_MEMBER_ADDED_BYTE("enableContactCaching", 1)
	HK_PATCH_MEMBER_ADDED_BYTE("enableWeldingForDefaultObjects", 0)
	HK_PATCH_MEMBER_ADDED_BYTE("enableWeldingForCriticalObjects", 0)
	HK_PATCH_MEMBER_ADDED_INT("contactSolverType", 0)
	HK_PATCH_MEMBER_ADDED_BYTE("applyUnitScaleToStaticConstants", 1)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpLodShapeLevelOfDetailInfo", 0)
	HK_PATCH_MEMBER_ADDED("maxDistance", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("maxShrink", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpLodShape", 1)
	HK_PATCH_PARENT_SET(HK_NULL, "hknpCompositeShape")
	HK_PATCH_MEMBER_ADDED("numLevelsOfDetail", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("infos", TYPE_TUPLE_STRUCT, "hknpLodShapeLevelOfDetailInfo", 8)
	HK_PATCH_MEMBER_ADDED("shapes", TYPE_TUPLE_OBJECT, "hknpShape", 8)
	HK_PATCH_MEMBER_ADDED("shapesMemorySizes", TYPE_TUPLE_INT, HK_NULL, 8)
	HK_PATCH_MEMBER_ADDED("indexCurrentShapeOnSpu", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("currentShapePpuAddress", TYPE_OBJECT, "hknpShape", 0)
	HK_PATCH_MEMBER_ADDED("maximumAabb", TYPE_STRUCT, "hkAabb", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkAabb", 0)
	HK_PATCH_DEPENDS("hknpLodShapeLevelOfDetailInfo", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hknpShape", 2)
	HK_PATCH_DEPENDS("hknpCompositeShape", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpDecoratorShape", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hknpShape")
	HK_PATCH_MEMBER_ADDED("coreShape", TYPE_OBJECT, "hknpShape", 0)
	HK_PATCH_MEMBER_ADDED("coreShapeSize", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hknpShape", 2)
HK_PATCH_END()

HK_PATCH_BEGIN("hknpScaledConvexShapeBase", 1, "hknpScaledConvexShapeBase", 2)
	HK_PATCH_PARENT_SET("hknpShape", "hknpDecoratorShape")
	HK_PATCH_FUNCTION(hknpScaledConvexShapeBase_1_to_2)
	HK_PATCH_MEMBER_REMOVED("childShape", TYPE_OBJECT, "hknpConvexShape", 0)
	HK_PATCH_MEMBER_REMOVED("childShapeSize", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hknpVehicleFrictionStatusAxisStatus", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("forward_slip_velocity", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("side_slip_velocity", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("skid_energy_density", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("side_force", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("delayed_forward_impulse", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("sideRhs", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("forwardRhs", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("relativeSideForce", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("relativeForwardForce", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hknpVehicleFrictionDescriptionAxisDescription", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("frictionCircleYtab", TYPE_VEC_16, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("xStep", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("xStart", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("wheelSurfaceInertia", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("wheelSurfaceInertiaInv", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("wheelChassisMassRatio", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("wheelRadius", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("wheelRadiusInv", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("wheelDownForceFactor", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("wheelDownForceSumFactor", TYPE_REAL, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hknpVehicleFrictionStatus", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("axis", TYPE_TUPLE_STRUCT, "hknpVehicleFrictionStatusAxisStatus", 2)
	HK_PATCH_DEPENDS("hknpVehicleFrictionStatusAxisStatus", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hknpVehicleFrictionDescription", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_MEMBER_REMOVED("wheelDistance", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("chassisMassInv", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("axleDescr", TYPE_TUPLE_STRUCT, "hknpVehicleFrictionDescriptionAxisDescription", 2)
	HK_PATCH_DEPENDS("hknpVehicleFrictionDescriptionAxisDescription", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hknpGroupCollisionFilter", 0, "hknpGroupCollisionFilter", 1)
	HK_PATCH_MEMBER_ADDED("newCollisionLookupTable", TYPE_TUPLE_INT, HK_NULL, 64)
	HK_PATCH_FUNCTION(hknpGroupCollisionFilter_0_to_1)
	HK_PATCH_MEMBER_REMOVED("collisionLookupTable", TYPE_TUPLE_INT, HK_NULL, 32)
	HK_PATCH_MEMBER_RENAMED("newCollisionLookupTable", "collisionLookupTable")
HK_PATCH_END()

HK_PATCH_BEGIN("hknpCharacterRigidBodyCinfo", 1, "hknpCharacterRigidBodyCinfo", 2)
	HK_PATCH_MEMBER_ADDED_BYTE("additionMode", 2)
	HK_PATCH_MEMBER_RENAMED("additionFlags", "old_additionFlags")
	HK_PATCH_MEMBER_ADDED_BYTE("additionFlags", 0)
	HK_PATCH_FUNCTION(hknpCharacterRigidBodyCinfo_1_to_2)
	HK_PATCH_MEMBER_REMOVED("old_additionFlags", TYPE_BYTE, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hknpCompressedMeshShape", 4, "hknpCompressedMeshShape", 5)
	HK_PATCH_MEMBER_RENAMED("triangleIsInternal", "triangleIsInterior")
HK_PATCH_END()

HK_PATCH_BEGIN("hknpWorldCinfo", 4, "hknpWorldCinfo", 5)
	HK_PATCH_MEMBER_ADDED_BYTE("deleteCachesOnDeactivation", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hknpCentrifugalForceAction", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_PARENT_SET("hknpUnaryAction", HK_NULL)
	HK_PATCH_DEPENDS("hknpUnaryAction", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hknpAction", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hknpSpringAction", 0, HK_NULL, HK_CLASS_REMOVED)
	HK_PATCH_PARENT_SET("hknpBinaryAction", HK_NULL)
	HK_PATCH_MEMBER_REMOVED("lastForce", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("positionAinA", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("positionBinB", TYPE_VEC_4, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("restLength", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("strength", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("damping", TYPE_REAL, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("onCompression", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("onExtension", TYPE_BYTE, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hknpAction", 0)
	HK_PATCH_DEPENDS("hknpBinaryAction", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hknpBodyCinfo", 1, "hknpBodyCinfo", 2)
	HK_PATCH_MEMBER_ADDED("userData", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hknpConstraintCinfo", 1, "hknpConstraintCinfo", 2)
	HK_PATCH_MEMBER_REMOVED("additionalRuntimeSize", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hknpUnaryAction", 0, "hknpUnaryAction", 1)
	HK_PATCH_MEMBER_REMOVED("body", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("bodyId", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hknpBinaryAction", 0, "hknpBinaryAction", 1)
	HK_PATCH_MEMBER_REMOVED("bodyA", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("bodyB", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("bodyIdA", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_ADDED("bodyIdB", TYPE_INT, HK_NULL, 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpArrayAction", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hknpAction")
	HK_PATCH_MEMBER_ADDED("bodyIds", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hknpAction", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hknpCharacterProxyCinfo", 0, "hknpCharacterProxyCinfo", 1)
	HK_PATCH_MEMBER_ADDED_INT("userData", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpGroupCollisionFilterBasehknpGroupCollisionFilterTypesConfig55516", 0)
    HK_PATCH_PARENT_SET(HK_NULL, "hknpCollisionFilter")
    HK_PATCH_MEMBER_ADDED("nextFreeSystemGroup", TYPE_INT, HK_NULL, 0)
    HK_PATCH_MEMBER_ADDED("collisionLookupTable", TYPE_TUPLE_INT, HK_NULL, 32)
    HK_PATCH_DEPENDS("hkBaseObject", 0)
    HK_PATCH_DEPENDS("hknpCollisionFilter", 0)
    HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hknpGroupCollisionFilter", 1, "hknpGroupCollisionFilter", 2)
	HK_PATCH_MEMBER_RENAMED("nextFreeSystemGroup", "old_nextFreeSystemGroup")
	HK_PATCH_MEMBER_RENAMED("collisionLookupTable", "old_collisionLookupTable")
	HK_PATCH_PARENT_SET("hknpCollisionFilter", "hknpGroupCollisionFilterBasehknpGroupCollisionFilterTypesConfig55516")
	HK_PATCH_FUNCTION(hknpGroupCollisionFilter_1_to_2)
	HK_PATCH_MEMBER_REMOVED("old_nextFreeSystemGroup", TYPE_INT, HK_NULL, 0)
	HK_PATCH_MEMBER_REMOVED("old_collisionLookupTable", TYPE_TUPLE_INT, HK_NULL, 32)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpShapeKeyMask", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkBaseObject")
	HK_PATCH_DEPENDS("hkBaseObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpMaskedShapeMaskWrapper", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hknpShapeKeyMask")
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hknpShapeKeyMask", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpMaskedShape", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hknpDecoratorShape")
	HK_PATCH_MEMBER_ADDED("mask", TYPE_OBJECT, "hknpShapeKeyMask", 0)
	HK_PATCH_MEMBER_ADDED("maskWrapper", TYPE_STRUCT, "hknpMaskedShapeMaskWrapper", 0)
	HK_PATCH_MEMBER_ADDED("maskSize", TYPE_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hknpMaskedShapeMaskWrapper", 0)
	HK_PATCH_DEPENDS("hknpDecoratorShape", 0)
	HK_PATCH_DEPENDS("hknpShape", 2)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hknpShapeKeyMask", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpCompoundShapeKeyMask", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hknpShapeKeyMask")
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hknpShapeKeyMask", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpStaticCompoundShapeKeyMask", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hknpCompoundShapeInternalsKeyMask")
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hknpCompoundShapeInternalsKeyMask", 0)
	HK_PATCH_DEPENDS("hknpCompoundShapeKeyMask", 0)
	HK_PATCH_DEPENDS("hknpShapeKeyMask", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpStaticCompoundShapeInternals", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hknpStaticCompoundShape")
	HK_PATCH_DEPENDS("hknpCompoundShape", 2)
	HK_PATCH_DEPENDS("hknpStaticCompoundShape", 1)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hknpShape", 2)
	HK_PATCH_DEPENDS("hknpCompositeShape", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpCompoundShapeInternalsKeyMask", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hknpCompoundShapeKeyMask")
	HK_PATCH_MEMBER_ADDED("shape", TYPE_OBJECT, "hknpCompoundShape", 0)
	HK_PATCH_MEMBER_ADDED("instanceMasks", TYPE_ARRAY_OBJECT, "hknpShapeKeyMask", 0)
	HK_PATCH_MEMBER_ADDED("filter", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hknpCompoundShapeKeyMask", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hknpShape", 2)
	HK_PATCH_DEPENDS("hknpCompoundShape", 2)
	HK_PATCH_DEPENDS("hknpCompositeShape", 0)
	HK_PATCH_DEPENDS("hknpShapeKeyMask", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpCompressedMeshShapeInternalsKeyMask", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hknpShapeKeyMask")
	HK_PATCH_MEMBER_ADDED("shape", TYPE_OBJECT, "hknpCompressedMeshShape", 0)
	HK_PATCH_MEMBER_ADDED("filter", TYPE_ARRAY_INT, HK_NULL, 0)
	HK_PATCH_DEPENDS("hknpCompositeShape", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
	HK_PATCH_DEPENDS("hknpShape", 2)
	HK_PATCH_DEPENDS("hknpCompressedMeshShape", 5)
	HK_PATCH_DEPENDS("hknpShapeKeyMask", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpBallGun", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hknpFirstPersonGun")
	HK_PATCH_MEMBER_ADDED_REAL("bulletRadius", 0.200000f)
	HK_PATCH_MEMBER_ADDED_REAL("bulletVelocity", 40.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("bulletMass", 50.000000f)
	HK_PATCH_MEMBER_ADDED_REAL("damageMultiplier", 50.000000f)
	HK_PATCH_MEMBER_ADDED_INT("maxBulletsInWorld", 100)
	HK_PATCH_MEMBER_ADDED_VEC_4("bulletOffsetFromCenter", 0.000000f,0.000000f,0.000000f,0.000000f)
	HK_PATCH_DEPENDS("hknpFirstPersonGun", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpProjectileGun", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hknpFirstPersonGun")
	HK_PATCH_MEMBER_ADDED_INT("maxProjectiles", 5)
	HK_PATCH_MEMBER_ADDED_REAL("reloadTime", 0.300000f)
	HK_PATCH_DEPENDS("hknpFirstPersonGun", 0)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN(HK_NULL, HK_CLASS_ADDED, "hknpFirstPersonGun", 0)
	HK_PATCH_PARENT_SET(HK_NULL, "hkReferencedObject")
	HK_PATCH_MEMBER_ADDED_CSTRING("name", "")
	HK_PATCH_MEMBER_ADDED_BYTE("keyboardKey", 113)
	HK_PATCH_DEPENDS("hkBaseObject", 0)
	HK_PATCH_DEPENDS("hkReferencedObject", 0)
HK_PATCH_END()

HK_PATCH_BEGIN("hknpMotionProperties", 2, "hknpMotionProperties", 3)
	HK_PATCH_MEMBER_DEFAULT_SET_REAL("gravityFactor", 1.000000f)
	HK_PATCH_MEMBER_DEFAULT_SET_REAL("linearDamping", 0.000000f)
	HK_PATCH_MEMBER_DEFAULT_SET_REAL("angularDamping", 0.000000f)
HK_PATCH_END()

HK_PATCH_BEGIN("hknpTriangleShape", 0, "hknpTriangleShape", 1)
	HK_PATCH_FUNCTION(hknpTriangleShape_0_to_1)
HK_PATCH_END()

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
