/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
#ifndef HKMATH_HEADERCONSTANTDEFINITIONS_H
#define HKMATH_HEADERCONSTANTDEFINITIONS_H

// hkSimdReal_
// Note : do not  use these constants to initialize static variables, as they are themselves static and can be 
// initialized in the wrong order. 
#define hkSimdReal_Minus1 (hkSimdReal::getConstant<HK_QUADREAL_MINUS1>())
#define hkSimdReal_0 (hkSimdReal::getConstant<HK_QUADREAL_0>())
#define hkSimdReal_1 (hkSimdReal::getConstant<HK_QUADREAL_1>())
#define hkSimdReal_2 (hkSimdReal::getConstant<HK_QUADREAL_2>())
#define hkSimdReal_3 (hkSimdReal::getConstant<HK_QUADREAL_3>())
#define hkSimdReal_4 (hkSimdReal::getConstant<HK_QUADREAL_4>())
#define hkSimdReal_5 (hkSimdReal::getConstant<HK_QUADREAL_5>())
#define hkSimdReal_6 (hkSimdReal::getConstant<HK_QUADREAL_6>())
#define hkSimdReal_7 (hkSimdReal::getConstant<HK_QUADREAL_7>())
#define hkSimdReal_8 (hkSimdReal::getConstant<HK_QUADREAL_8>())
#define hkSimdReal_15 (hkSimdReal::getConstant<HK_QUADREAL_15>())
#define hkSimdReal_16 (hkSimdReal::getConstant<HK_QUADREAL_16>())
#define hkSimdReal_255 (hkSimdReal::getConstant<HK_QUADREAL_255>())
#define hkSimdReal_256 (hkSimdReal::getConstant<HK_QUADREAL_256>())

#define hkSimdReal_Inv0 (hkSimdReal::getConstant<HK_QUADREAL_INV_0>())
#define hkSimdReal_Inv1 (hkSimdReal::getConstant<HK_QUADREAL_INV_1>())
#define hkSimdReal_Inv2 (hkSimdReal::getConstant<HK_QUADREAL_INV_2>())
#define hkSimdReal_Inv3 (hkSimdReal::getConstant<HK_QUADREAL_INV_3>())
#define hkSimdReal_Inv4 (hkSimdReal::getConstant<HK_QUADREAL_INV_4>())
#define hkSimdReal_Inv5 (hkSimdReal::getConstant<HK_QUADREAL_INV_5>())
#define hkSimdReal_Inv6 (hkSimdReal::getConstant<HK_QUADREAL_INV_6>())
#define hkSimdReal_Inv7 (hkSimdReal::getConstant<HK_QUADREAL_INV_7>())
#define hkSimdReal_Inv8 (hkSimdReal::getConstant<HK_QUADREAL_INV_8>())
#define hkSimdReal_Inv_15 (hkSimdReal::getConstant<HK_QUADREAL_INV_15>())
#define hkSimdReal_Inv_127 (hkSimdReal::getConstant<HK_QUADREAL_INV_127>())
#define hkSimdReal_Inv_255 (hkSimdReal::getConstant<HK_QUADREAL_INV_255>())

#define hkSimdReal_High (hkSimdReal::getConstant<HK_QUADREAL_HIGH>())
#define hkSimdReal_Max (hkSimdReal::getConstant<HK_QUADREAL_MAX>())
#define hkSimdReal_Min (hkSimdReal::getConstant<HK_QUADREAL_MIN>())
#define hkSimdReal_Eps (hkSimdReal::getConstant<HK_QUADREAL_EPS>())
#define hkSimdReal_EpsSqrd (hkSimdReal::getConstant<HK_QUADREAL_EPS_SQRD>())
#define hkSimdReal_MinusMax (hkSimdReal::getConstant<HK_QUADREAL_MINUS_MAX>())
#define hkSimdReal_MinusMin (hkSimdReal::getConstant<HK_QUADREAL_MINUS_MIN>())

#define hkSimdReal_PackHalf (hkSimdReal::getConstant<HK_QUADREAL_PACK_HALF>())
#define hkSimdReal_Pack16 (hkSimdReal::getConstant<HK_QUADREAL_PACK16_UNIT_VEC>())
#define hkSimdReal_Unpack16 (hkSimdReal::getConstant<HK_QUADREAL_UNPACK16_UNIT_VEC>())

#define hkSimdReal_Pi (hkSimdReal::getConstant<HK_QUADREAL_PI>())
#define hkSimdReal_PiOver2 (hkSimdReal::getConstant<HK_QUADREAL_PI_HALF>())
#define hkSimdReal_PiOver4 (hkSimdReal::getConstant<HK_QUADREAL_PI_QUARTER>())
#define hkSimdReal_4PiOver3 (hkSimdReal::getConstant<HK_QUADREAL_FOUR_PI_THIRD>())
#define hkSimdReal_TwoPi (hkSimdReal::getConstant<HK_QUADREAL_TWO_PI>())
#define hkSimdReal_FourPi (hkSimdReal::getConstant<HK_QUADREAL_FOUR_PI>())

//duplicate of hkSimdReal_Inv2 
#define hkSimdReal_Half (hkSimdReal::getConstant<HK_QUADREAL_INV_2>())

// hkSimdFloat32_
#define hkSimdFloat32_Minus1 (hkSimdFloat32::getConstant<HK_QUADREAL_MINUS1>())
#define hkSimdFloat32_0 (hkSimdFloat32::getConstant<HK_QUADREAL_0>())
#define hkSimdFloat32_1 (hkSimdFloat32::getConstant<HK_QUADREAL_1>())
#define hkSimdFloat32_2 (hkSimdFloat32::getConstant<HK_QUADREAL_2>())
#define hkSimdFloat32_3 (hkSimdFloat32::getConstant<HK_QUADREAL_3>())
#define hkSimdFloat32_4 (hkSimdFloat32::getConstant<HK_QUADREAL_4>())
#define hkSimdFloat32_5 (hkSimdFloat32::getConstant<HK_QUADREAL_5>())
#define hkSimdFloat32_6 (hkSimdFloat32::getConstant<HK_QUADREAL_6>())
#define hkSimdFloat32_7 (hkSimdFloat32::getConstant<HK_QUADREAL_7>())
#define hkSimdFloat32_8 (hkSimdFloat32::getConstant<HK_QUADREAL_8>())
#define hkSimdFloat32_15 (hkSimdFloat32::getConstant<HK_QUADREAL_15>())
#define hkSimdFloat32_16 (hkSimdFloat32::getConstant<HK_QUADREAL_16>())
#define hkSimdFloat32_255 (hkSimdFloat32::getConstant<HK_QUADREAL_255>())
#define hkSimdFloat32_256 (hkSimdFloat32::getConstant<HK_QUADREAL_256>())

#define hkSimdFloat32_Inv0 (hkSimdFloat32::getConstant<HK_QUADREAL_INV_0>())
#define hkSimdFloat32_Inv1 (hkSimdFloat32::getConstant<HK_QUADREAL_INV_1>())
#define hkSimdFloat32_Inv2 (hkSimdFloat32::getConstant<HK_QUADREAL_INV_2>())
#define hkSimdFloat32_Inv3 (hkSimdFloat32::getConstant<HK_QUADREAL_INV_3>())
#define hkSimdFloat32_Inv4 (hkSimdFloat32::getConstant<HK_QUADREAL_INV_4>())
#define hkSimdFloat32_Inv5 (hkSimdFloat32::getConstant<HK_QUADREAL_INV_5>())
#define hkSimdFloat32_Inv6 (hkSimdFloat32::getConstant<HK_QUADREAL_INV_6>())
#define hkSimdFloat32_Inv7 (hkSimdFloat32::getConstant<HK_QUADREAL_INV_7>())
#define hkSimdFloat32_Inv8 (hkSimdFloat32::getConstant<HK_QUADREAL_INV_8>())
#define hkSimdFloat32_Inv_15 (hkSimdFloat32::getConstant<HK_QUADREAL_INV_15>())
#define hkSimdFloat32_Inv_127 (hkSimdFloat32::getConstant<HK_QUADREAL_INV_127>())
#define hkSimdFloat32_Inv_255 (hkSimdFloat32::getConstant<HK_QUADREAL_INV_255>())

#define hkSimdFloat32_High (hkSimdFloat32::getConstant<HK_QUADREAL_HIGH>())
#define hkSimdFloat32_Max (hkSimdFloat32::getConstant<HK_QUADREAL_MAX>())
#define hkSimdFloat32_Min (hkSimdFloat32::getConstant<HK_QUADREAL_MIN>())
#define hkSimdFloat32_Eps (hkSimdFloat32::getConstant<HK_QUADREAL_EPS>())
#define hkSimdFloat32_EpsSqrd (hkSimdFloat32::getConstant<HK_QUADREAL_EPS_SQRD>())
#define hkSimdFloat32_MinusMax (hkSimdFloat32::getConstant<HK_QUADREAL_MINUS_MAX>())
#define hkSimdFloat32_MinusMin (hkSimdFloat32::getConstant<HK_QUADREAL_MINUS_MIN>())

#define hkSimdFloat32_PackHalf (hkSimdFloat32::getConstant<HK_QUADREAL_PACK_HALF>())
#define hkSimdFloat32_Pack16 (hkSimdFloat32::getConstant<HK_QUADREAL_PACK16_UNIT_VEC>())
#define hkSimdFloat32_Unpack16 (hkSimdFloat32::getConstant<HK_QUADREAL_UNPACK16_UNIT_VEC>())

#define hkSimdFloat32_Pi (hkSimdFloat32::getConstant<HK_QUADREAL_PI>())
#define hkSimdFloat32_PiOver2 (hkSimdFloat32::getConstant<HK_QUADREAL_PI_HALF>())
#define hkSimdFloat32_PiOver4 (hkSimdFloat32::getConstant<HK_QUADREAL_PI_QUARTER>())
#define hkSimdFloat32_4PiOver3 (hkSimdFloat32::getConstant<HK_QUADREAL_FOUR_PI_THIRD>())
#define hkSimdFloat32_TwoPi (hkSimdFloat32::getConstant<HK_QUADREAL_TWO_PI>())
#define hkSimdFloat32_FourPi (hkSimdFloat32::getConstant<HK_QUADREAL_FOUR_PI>())

#define hkSimdFloat32_Deg2Rad (hkSimdFloat32::getConstant<HK_QUADREAL_DEG2RAD>())
#define hkSimdFloat32_Rad2Deg (hkSimdFloat32::getConstant<HK_QUADREAL_RAD2DEG>())

//duplicate of hkSimdFloat32_Inv2 
#define hkSimdFloat32_Half (hkSimdFloat32::getConstant<HK_QUADREAL_INV_2>())

// hkSimdDouble64_
#define hkSimdDouble64_Minus1 (hkSimdDouble64::getConstant<HK_QUADREAL_MINUS1>())
#define hkSimdDouble64_0 (hkSimdDouble64::getConstant<HK_QUADREAL_0>())
#define hkSimdDouble64_1 (hkSimdDouble64::getConstant<HK_QUADREAL_1>())
#define hkSimdDouble64_2 (hkSimdDouble64::getConstant<HK_QUADREAL_2>())
#define hkSimdDouble64_3 (hkSimdDouble64::getConstant<HK_QUADREAL_3>())
#define hkSimdDouble64_4 (hkSimdDouble64::getConstant<HK_QUADREAL_4>())
#define hkSimdDouble64_5 (hkSimdDouble64::getConstant<HK_QUADREAL_5>())
#define hkSimdDouble64_6 (hkSimdDouble64::getConstant<HK_QUADREAL_6>())
#define hkSimdDouble64_7 (hkSimdDouble64::getConstant<HK_QUADREAL_7>())
#define hkSimdDouble64_8 (hkSimdDouble64::getConstant<HK_QUADREAL_8>())
#define hkSimdDouble64_15 (hkSimdDouble64::getConstant<HK_QUADREAL_15>())
#define hkSimdDouble64_16 (hkSimdDouble64::getConstant<HK_QUADREAL_16>())
#define hkSimdDouble64_255 (hkSimdDouble64::getConstant<HK_QUADREAL_255>())
#define hkSimdDouble64_256 (hkSimdDouble64::getConstant<HK_QUADREAL_256>())

#define hkSimdDouble64_Inv0 (hkSimdDouble64::getConstant<HK_QUADREAL_INV_0>())
#define hkSimdDouble64_Inv1 (hkSimdDouble64::getConstant<HK_QUADREAL_INV_1>())
#define hkSimdDouble64_Inv2 (hkSimdDouble64::getConstant<HK_QUADREAL_INV_2>())
#define hkSimdDouble64_Inv3 (hkSimdDouble64::getConstant<HK_QUADREAL_INV_3>())
#define hkSimdDouble64_Inv4 (hkSimdDouble64::getConstant<HK_QUADREAL_INV_4>())
#define hkSimdDouble64_Inv5 (hkSimdDouble64::getConstant<HK_QUADREAL_INV_5>())
#define hkSimdDouble64_Inv6 (hkSimdDouble64::getConstant<HK_QUADREAL_INV_6>())
#define hkSimdDouble64_Inv7 (hkSimdDouble64::getConstant<HK_QUADREAL_INV_7>())
#define hkSimdDouble64_Inv8 (hkSimdDouble64::getConstant<HK_QUADREAL_INV_8>())
#define hkSimdDouble64_Inv_15 (hkSimdDouble64::getConstant<HK_QUADREAL_INV_15>())
#define hkSimdDouble64_Inv_127 (hkSimdDouble64::getConstant<HK_QUADREAL_INV_127>())
#define hkSimdDouble64_Inv_255 (hkSimdDouble64::getConstant<HK_QUADREAL_INV_255>())

#define hkSimdDouble64_High (hkSimdDouble64::getConstant<HK_QUADREAL_HIGH>())
#define hkSimdDouble64_Max (hkSimdDouble64::getConstant<HK_QUADREAL_MAX>())
#define hkSimdDouble64_Min (hkSimdDouble64::getConstant<HK_QUADREAL_MIN>())
#define hkSimdDouble64_Eps (hkSimdDouble64::getConstant<HK_QUADREAL_EPS>())
#define hkSimdDouble64_EpsSqrd (hkSimdDouble64::getConstant<HK_QUADREAL_EPS_SQRD>())
#define hkSimdDouble64_MinusMax (hkSimdDouble64::getConstant<HK_QUADREAL_MINUS_MAX>())
#define hkSimdDouble64_MinusMin (hkSimdDouble64::getConstant<HK_QUADREAL_MINUS_MIN>())

#define hkSimdDouble64_PackHalf (hkSimdDouble64::getConstant<HK_QUADREAL_PACK_HALF>())
#define hkSimdDouble64_Pack16 (hkSimdDouble64::getConstant<HK_QUADREAL_PACK16_UNIT_VEC>())
#define hkSimdDouble64_Unpack16 (hkSimdDouble64::getConstant<HK_QUADREAL_UNPACK16_UNIT_VEC>())

#define hkSimdDouble64_Pi (hkSimdDouble64::getConstant<HK_QUADREAL_PI>())
#define hkSimdDouble64_PiOver2 (hkSimdDouble64::getConstant<HK_QUADREAL_PI_HALF>())
#define hkSimdDouble64_PiOver4 (hkSimdDouble64::getConstant<HK_QUADREAL_PI_QUARTER>())
#define hkSimdDouble64_4PiOver3 (hkSimdDouble64::getConstant<HK_QUADREAL_FOUR_PI_THIRD>())
#define hkSimdDouble64_TwoPi (hkSimdDouble64::getConstant<HK_QUADREAL_TWO_PI>())
#define hkSimdDouble64_FourPi (hkSimdDouble64::getConstant<HK_QUADREAL_FOUR_PI>())

#define hkSimdDouble64_Deg2Rad (hkSimdDouble64::getConstant<HK_QUADREAL_DEG2RAD>())
#define hkSimdDouble64_Rad2Deg (hkSimdDouble64::getConstant<HK_QUADREAL_RAD2DEG>())

//duplicate of hkSimdDouble64_Inv2 
#define hkSimdDouble64_Half (hkSimdDouble64::getConstant<HK_QUADREAL_INV_2>())

	/// A list of constants.
	/// \warning Do not change the order of the following constants and keep synchronized with value array: g_vectorConstants[] because algorithms rely on this order.
enum hkVectorConstant
{
	HK_QUADREAL_BEGIN, ///< Start marker, do not use

	HK_QUADREAL_MINUS1,
	HK_QUADREAL_0,
	HK_QUADREAL_1,
	HK_QUADREAL_2,
	HK_QUADREAL_3,
	HK_QUADREAL_4,
	HK_QUADREAL_5,
	HK_QUADREAL_6,
	HK_QUADREAL_7,
	HK_QUADREAL_8,
	HK_QUADREAL_15,
	HK_QUADREAL_16,
	HK_QUADREAL_255,
	HK_QUADREAL_256,
	HK_QUADREAL_2_POW_23,

	HK_QUADREAL_INV_0,	///< 0.0f, 0.0f, 0.0f
	HK_QUADREAL_INV_1,	///< 1 1 1 1
	HK_QUADREAL_INV_2,	///< .5 .5 .5 .5
	HK_QUADREAL_INV_3,	///< 1/3 1/3 1/3 1/3
	HK_QUADREAL_INV_4,
	HK_QUADREAL_INV_5,
	HK_QUADREAL_INV_6,
	HK_QUADREAL_INV_7,
	HK_QUADREAL_INV_8,
	HK_QUADREAL_INV_15,		///< 1/15 x 4
	HK_QUADREAL_INV_127,	///< 1/127 x 4
	HK_QUADREAL_INV_226,	///< 1/226 x 4, Used to unpack AABB.
	HK_QUADREAL_INV_255,	///< 1/255 x 4
	HK_QUADREAL_1000,   ///< The next 4 are also the matrix identity, don't change the order.
	HK_QUADREAL_0100,
	HK_QUADREAL_0010,
	HK_QUADREAL_0001,
	HK_QUADREAL_MAX,
	HK_QUADREAL_HIGH,	///< A high number (~ sqrd(HK_QUADREAL_MAX) )
	HK_QUADREAL_EPS,
	HK_QUADREAL_EPS_SQRD,	///< Eps squared, really really tiny number
	HK_QUADREAL_MIN,	///< The smallest positive number, which is not a denormal
	HK_QUADREAL_MINUS_MAX,
	HK_QUADREAL_MINUS_MIN,
	HK_QUADREAL_m11m11,	///< -1,1,-1,1
	HK_QUADREAL_1m11m1,	///< 1,-1,1,-1
	HK_QUADREAL_1010,   ///< 1,0,1,0
	HK_QUADREAL_1100,   ///< 1,1,0,0
	HK_QUADREAL_0011,   ///< 0,0,1,1
	HK_QUADREAL_1248,   ///< 1,2,4,8
	HK_QUADREAL_8421,   ///< 8,4,2,1
	HK_QUADREAL_PACK_HALF,	///< Used to pack hkHalfs
	HK_QUADREAL_PACK16_UNIT_VEC,	///< Used to compress unit vectors
	HK_QUADREAL_UNPACK16_UNIT_VEC,	///< Used to uncompress unit vectors
	HK_QUADREAL_PI,
	HK_QUADREAL_PI_HALF,
	HK_QUADREAL_PI_QUARTER,
	HK_QUADREAL_FOUR_PI_THIRD,
	HK_QUADREAL_TWO_PI,
	HK_QUADREAL_FOUR_PI,
	HK_QUADREAL_DEG2RAD,
	HK_QUADREAL_RAD2DEG,

	HK_QUADREAL_END ///< End marker, do not use
};

	/// A list of constants.
	/// \warning Do not change the order of the following constants and keep synchronized with value array: g_intVectorConstants[] because algorithms rely on this order.
enum hkIntVectorConstant
{
	HK_QUADINT_BEGIN, ///< Start marker, do not use

	HK_QUADINT_0,
	HK_QUADINT_1,
	HK_QUADINT_2,
	HK_QUADINT_4,
	HK_QUADINT_0123,
	HK_QUADINT_0123_INT24W,	///< lower bits hold 0123, upper bits are set, so that reinterpreting this value as float will give a valid floating point number
	HK_QUADINT_3,
	HK_QUADINT_FFFF,		///< mask used for selecting the lower 16 bit

	// Permutation constants, for Xbox broadcast(i), do not change order!
	HK_QUADINT_PERM_XXXX,
	HK_QUADINT_PERM_YYYY,
	HK_QUADINT_PERM_ZZZZ,
	HK_QUADINT_PERM_WWWW,

	HK_QUADINT_END ///< End marker, do not use
};

// create a custom static constant in code (strict aliasing safe)

#define HK_DEFINE_VECTOR4f_HEX_CONSTANT(name,c0,c1,c2,c3) \
	static HK_ALIGN_FLOAT(const hkUint32 name##Cst[4]) = { c0, c1, c2, c3 }; \
	typedef union { hkUint32 i32[4]; hkFloat32 f32[4]; } name##i2f ; \
	const name##i2f* name = (const name##i2f*)name##Cst;

#define HK_DEFINE_VECTOR4d_HEX_CONSTANT(name,c0,c1,c2,c3) \
	static HK_ALIGN_DOUBLE(const hkUint64 name##Cst[4]) = { c0, c1, c2, c3 }; \
	typedef union { hkUint64 i64[4]; hkDouble64 d64[4]; } name##i2d ; \
	const name##i2d* name = (const name##i2d*)name##Cst;

#endif //HKMATH_HEADERCONSTANTDEFINITIONS_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
