/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

HK_FORCE_INLINE hkInt32 hkaReferencePoseAnimation::getNumBones() const
{
	return m_skeleton->m_bones.getSize();
}

HK_FORCE_INLINE hkInt32 hkaReferencePoseAnimation::getNumFloatSlots() const
{
	return m_skeleton->m_floatSlots.getSize();
}

HK_FORCE_INLINE int hkaReferencePoseAnimation::getSizeInBytes() const
{
	return sizeof( hkaReferencePoseAnimation );
}

HK_FORCE_INLINE int hkaReferencePoseAnimation::getNumOriginalFrames() const
{
	// Reference pose always only has one frame
	return 1;
}

HK_FORCE_INLINE bool hkaReferencePoseAnimation::requiresSkeleton() const
{
	return true;
}

HK_FORCE_INLINE const hkaSkeleton* hkaReferencePoseAnimation::getSkeleton() const
{
	return m_skeleton;
}

HK_FORCE_INLINE void hkaReferencePoseAnimation::setSkeleton( const hkaSkeleton* skeleton )
{
	m_skeleton = skeleton;
}

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
