/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef RENDER_SYSTEM_H
#define RENDER_SYSTEM_H

#include <Common/Base/hkBase.h>

class hkDebugDisplayHandler;
class hkgWindow;
class hkgDisplayWorld;
class hkgSceneDataConverter;
class hkgDisplayHandler;
class hkTextDisplay;
class hkgViewport;
class hkgLight;
class hkgAabb;


/// Stand-alone, simplified version of the demo framework rendering system
class RenderSystem : public hkReferencedObject
{
	public:

		HK_DECLARE_CLASS_ALLOCATOR(HK_MEMORY_CLASS_DEMO);

		RenderSystem() : m_window(HK_NULL), m_displayHandler(HK_NULL) {}
		hkBool init();
		void setupDefaultCameras(const hkVector4& from, const hkVector4& to, const hkVector4& up, const hkReal nearPlane = 1.0f, const hkReal farPlane = 500.0f, bool rightHanded = true) const;
		hkDebugDisplayHandler* getDisplayHandler();		
		bool startFrame();
		void renderFrame();
		void release();
		~RenderSystem();		

	protected:

		void setupLights();
		void setupFixedShadowFrustum(const hkgLight& light, const hkgAabb& areaOfInterest, float extraNear = 0, float extraFar = 0, int numSplits = 0, int preferedUpAxis = -1 );		
		void sendVdbCamera(hkgViewport* v);		
		void tickFrame();

	protected:
		
		hkgWindow* m_window;
		hkgDisplayWorld* m_displayWorld;
		hkgSceneDataConverter* m_sceneConverter;		
		hkgDisplayHandler* m_displayHandler;		
};


#endif // RENDER_SYSTEM_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
