/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_SOUND_SYSTEM_XA2_INC_H
#define HK_SOUND_SYSTEM_XA2_INC_H

#include <Sound/Common/hkgSoundSystem.h>

class hkgSoundBufferXA2;
class hkgSoundSourceXA2;

class hkgSoundSystemXA2 : public hkgSoundSystem
{
public:

	hkgSoundSystemXA2();
	virtual ~hkgSoundSystemXA2();

	// If this returns false, then no need for quit, and the system is not functioning (missing dlls etc)
	virtual bool init();
	virtual void pause(bool paused);
	virtual void recalc();
	virtual void quit();
	virtual void setMasterVolume(hkReal volume);
	virtual int	 getActiveSources();
	virtual void setListener( const hkVector4& pos, const hkVector4& front, const hkVector4& up );
	virtual void setMasterPitchFactor( hkReal pitchFactor );
	virtual hkReal getMasterPitchFactor();

	virtual hkgSoundBuffer* createBuffer();
	virtual hkgSoundSource* createSource( hkBool global );

	// Internal

	inline IXAudio2* getXAudioPtr() { return m_xa; }
	inline IXAudio2MasteringVoice* getMasterVoice() { return m_masterVoice; } 
	inline IXAudio2SubmixVoice* getSubMixVoice(int numChannels) { return (numChannels == 2? m_stereoSubmixVoice : m_monoSubmixVoice); }
#ifndef HKG_SOUND_XAUDIO28_OR_HIGHER
	inline const XAUDIO2_DEVICE_DETAILS& getDeviceDetails() const { return m_deviceDetails; } 
#endif
	void removeBuffer(hkgSoundBufferXA2* b);
	void removeSource(hkgSoundSourceXA2* s);

protected:

	IXAudio2* m_xa;
	IXAudio2MasteringVoice* m_masterVoice;
#ifndef HKG_SOUND_XAUDIO28_OR_HIGHER
	XAUDIO2_DEVICE_DETAILS m_deviceDetails;
#endif
	IUnknown* m_monoReverbEffect;
	IXAudio2SubmixVoice* m_monoSubmixVoice;
	IXAudio2SubmixVoice* m_stereoSubmixVoice;
	X3DAUDIO_HANDLE m_x3DInstance;
	X3DAUDIO_LISTENER m_listener;
	hkReal m_masterPitchFactor;

	extArray< hkgSoundSourceXA2* > m_sources;
	extArray< hkgSoundBufferXA2* > m_buffers;

	HMODULE   m_x3dDll;
};

#endif // HK_SOUND_SYSTEM_XA2_INC_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
