/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_SOUND_SOURCE_XA2_INC_H
#define HK_SOUND_SOURCE_XA2_INC_H

#include <Sound/Common/hkgSoundSource.h>

#define HKG_SOUND_MAX_NUM_XA2_OUTPUTCHANNELS 8 // support up to 7.1
#define HKG_SOUND_MAX_NUM_XA2_INPUTCHANNELS 2

class hkgSoundSourceXA2 : public hkgSoundSource, public IXAudio2VoiceCallback
{
public:
	virtual ~hkgSoundSourceXA2();

	virtual bool attachBuffer( hkgSoundBuffer* buf, bool isLoop = true, float startOffsetInSeconds = 0.f, float loopStartOffsetInSeconds = 0.f );
	virtual bool detachBuffers();	
	virtual void getAttachedBuffers( hkArray<hkgSoundBuffer*>& b );

	virtual void setPosition( const hkVector4& p );
	virtual void setVelocity( const hkVector4& v );
	virtual void setPitch( hkReal pitch);
	virtual void setVolume( hkReal volume);
	virtual void setInnerRadius( hkReal radius);
	virtual void setDistanceScale(hkReal scale);
	virtual void setVelocityScale(hkReal scale);
	
	virtual void start(PlayMode mode = HKG_SOUND_PLAY_LOOP);
	virtual void pause();
	
	virtual void endLoop();
	virtual void stop();

	virtual PlayState	getState() const;
	virtual int			loopCount() const;

	void update();

	inline IXAudio2SourceVoice* getVoice() { return m_voice; }
	inline X3DAUDIO_EMITTER* getEmitter() { return &m_emitter; } 
	inline X3DAUDIO_DSP_SETTINGS* getDspSettings() { return &m_dspSettings; }

	virtual hkBool isGlobal() { return m_global; }

private:
	void __stdcall 	OnVoiceProcessingPassStart(UINT32 BytesRequired)	{}
	void __stdcall	OnVoiceProcessingPassEnd()							{}
	void __stdcall	OnStreamEnd()										{ ++m_loops; }
	void __stdcall	OnBufferStart(void* pBufferContext)					{}
	void __stdcall	OnBufferEnd(void* pBufferContext)					{ m_playState = hkgSoundSource::HKG_SOUND_STOPPED; }
	void __stdcall	OnLoopEnd(void* pBufferContext)						{ ++m_loops;if(m_once) stop(); }
	void __stdcall	OnVoiceError(void* pBufferContext,HRESULT Error)	{}
protected: 

	friend class hkgSoundSystemXA2;
	hkgSoundSourceXA2(hkgSoundSystemXA2* owner, hkBool global=false);
	
	HK_ALIGN16( FLOAT32 m_matrixCoefficients[HKG_SOUND_MAX_NUM_XA2_OUTPUTCHANNELS] );
	HK_ALIGN16( X3DAUDIO_DSP_SETTINGS m_dspSettings );
	HK_ALIGN16( X3DAUDIO_EMITTER m_emitter );
	HK_ALIGN16( X3DAUDIO_CONE m_emitterCone );
	HK_ALIGN16( FLOAT32 m_emitterAzimuths[HKG_SOUND_MAX_NUM_XA2_INPUTCHANNELS] );

	hkgSoundSystemXA2* m_owner;
	IXAudio2SourceVoice* m_voice;
	PlayState m_playState;
	hkArray<hkgSoundBuffer*> m_attachedBuffers;

	int		m_numChannels;
	int		m_loops;
};

#endif // HK_SOUND_SOURCE_XA2_INC_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
