/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_SOUND_BUFFER_XA2_INC_H
#define HK_SOUND_BUFFER_XA2_INC_H

#include <Sound/Common/hkgSoundBuffer.h>

class hkSeekableStreamReader;
#ifdef HK_PLATFORM_XBOX360
typedef hkUint32 FOURCC, *PFOURCC, *LPFOURCC;
#endif

#ifdef HKG_SOUND_XAUDIO28_OR_HIGHER
struct XMA2WAVEFORMATEX
{};
#endif

struct RIFFHEADER
{
	FOURCC fccChunkId;
	hkUint32 dwDataSize;
};

#define HKG_SOUND_RIFFCHUNK_FLAGS_VALID   0x00000001

class hkgSoundRiffChunk
{

public:

	hkgSoundRiffChunk();

	// Initialization
	VOID    init( FOURCC fccChunkId, const hkgSoundRiffChunk* pParentChunk, hkSeekableStreamReader* s);
	
	hkResult open();
	
	inline hkBool isValid() const {	return (m_flags & HKG_SOUND_RIFFCHUNK_FLAGS_VALID) != 0; }
	
	hkResult readData( hkUint32 offset, void* data, hkUint32 dataSize ) const;

	FOURCC getChunkId() const
	{
		return m_fccChunkId;
	}

	hkUint32 getDataSize() const
	{
		return m_dataSize;
	}

protected:
	
	FOURCC m_fccChunkId;       // Chunk identifier
	const hkgSoundRiffChunk* m_parentChunk;     // Parent chunk
	hkSeekableStreamReader* m_stream;
	hkUint32 m_dataOffset;     // Chunk data offset
	hkUint32 m_dataSize;       // Chunk data size
	hkUint32 m_flags;          // Chunk flags

private:

	hkgSoundRiffChunk( const hkgSoundRiffChunk& );
	hkgSoundRiffChunk& operator =( const hkgSoundRiffChunk& );
};

class hkgSoundBufferXA2 : public hkgSoundBuffer
{
public:

	virtual ~hkgSoundBufferXA2();

	virtual hkResult loadFromFile( const char* file );

	virtual hkResult loadWav( hkIstream& wstream );

	virtual hkReal getDuration() const;

	inline hkUint32 getWaveDataSize() const { return m_waveDataSize; }
	inline const hkUint8* getWaveDataPtr() const { return m_waveData; } 

	inline const WAVEFORMATEXTENSIBLE* getFormat() const { return &m_format; }

protected:

	friend class hkgSoundSystemXA2;
	hkgSoundBufferXA2(hkgSoundSystemXA2* owner);

	hkgSoundSystemXA2* m_owner;
	
	hkResult getFormat( WAVEFORMATEXTENSIBLE* pwfxFormat, XMA2WAVEFORMATEX* pXma2Format ) const;
	hkResult readSample( hkUint32 dwPosition, void* pBuffer, hkUint32 dwBufferSize, hkUint32* pdwRead ) const;
	
	hkgSoundRiffChunk m_riffChunk;        // RIFF chunk
	hkgSoundRiffChunk m_formatChunk;      // Format chunk
	hkgSoundRiffChunk m_dataChunk;        // Data chunk
	hkgSoundRiffChunk m_waveSampleChunk;  // Wave Sample chunk
	hkgSoundRiffChunk m_samplerChunk;     // Sampler chunk

	WAVEFORMATEXTENSIBLE m_format;

	hkUint32 m_waveDataSize;
	hkUint8* m_waveData; 

};
#endif // HK_SOUND_BUFFER_XA2_INC_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
