/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_SOUND_EFFECT_INC_H
#define HK_SOUND_EFFECT_INC_H

#include <Sound/Common/hkgSoundSource.h>

class hkgSoundEffect;
typedef void (HK_CALL *HKG_SOUND_EFFECT_END_CALLBACK)( hkgSoundEffect* e, void* userContext );

class hkgSoundEffect : public hkReferencedObject
{
	public:
		
		hkgSoundEffect();
		
		// returns true if can do more, so false == all done, can remove the effect
		virtual bool step(float dt) = 0;

		void setOnEndCallback(HKG_SOUND_EFFECT_END_CALLBACK fn, void* userContext) { m_onEndCallback = fn; m_onEndCallbackCtx = userContext; }
	
	protected:

		void raiseOnEnd();

		HKG_SOUND_EFFECT_END_CALLBACK m_onEndCallback;
		void* m_onEndCallbackCtx; 
};

// Will set the source volume and pitch linearly over time
class hkgSoundFadeEffect : public hkgSoundEffect
{
	public:

		hkgSoundFadeEffect(hkgSoundSource* s, float duration, float endVolume, float endPitch);

		virtual bool step(float dt);
		
		hkRefPtr<hkgSoundSource> m_source;

		float m_timeLeft;
		
		float m_deltaVolume;
		float m_deltaPitch;
		float m_endVolume; 
		float m_endPitch;
};

// Will set the source volume and pitch linearly over time, and perform an extra remove ref on the fromsource when it reaches the endso make sure no other effects are doing stuff with it or it won't be full removed
class hkgSoundCrossFadeEffect : public hkgSoundEffect
{
	public:

		hkgSoundCrossFadeEffect(hkgSoundSource* fromS, hkgSoundSource* toS, float duration, float endVolumeFrom, float endPitchFrom, float endVolumeTo, float endPitchTo);

		virtual bool step(float dt);

		hkRefPtr<hkgSoundSource> m_sourceFrom;
		hkRefPtr<hkgSoundSource> m_sourceTo;

		float m_timeLeft;
		
		float m_deltaVolumeFrom;
		float m_deltaPitchFrom;
		float m_endVolumeFrom; 
		float m_endPitchFrom;

		float m_deltaVolumeTo;
		float m_deltaPitchTo;
		float m_endVolumeTo; 
		float m_endPitchTo;
};

class hkgSoundCallbackOnFinishPlayingEffect : public hkgSoundEffect
{
	public:

		hkgSoundCallbackOnFinishPlayingEffect(hkgSoundSource* s, float delayOnEnd);

		virtual bool step(float dt);
		
		hkRefPtr<hkgSoundSource> m_source;
		float m_delayOnEnd;
};

#endif // HK_SOUND_BUFFER_INC_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
