/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_FUNC_PTRS_OGLES2_H
#define HK_GRAPHICS_FUNC_PTRS_OGLES2_H

// For non-Win32 platforms
#ifndef APIENTRY
#define APIENTRY
#endif
#ifndef APIENTRYP
#define APIENTRYP APIENTRY *
#endif
#ifndef GLAPI
#define GLAPI extern
#endif

// support VBO functions on Win32
#ifndef GL_ARRAY_BUFFER_ARB
#define GL_ARRAY_BUFFER_ARB 0x8892
#endif

#ifndef GL_STATIC_DRAW_ARB
#define GL_STATIC_DRAW_ARB 0x88E4
#endif


#if HKG_IS_REALLY_OES2==1
#define GL_SIZEI_PTR GLsizeiptr
#else
#define GL_SIZEI_PTR GLsizeiptrARB 
#endif

typedef void (APIENTRY * PFNGLBINDBUFFERARBPROC) (GLenum target, GLuint buffer);
typedef void (APIENTRY * PFNGLDELETEBUFFERSARBPROC) (GLsizei n, const GLuint *buffers);
typedef void (APIENTRY * PFNGLGENBUFFERSARBPROC) (GLsizei n, GLuint *buffers);
typedef void (APIENTRY* PFNGLBUFFERDATAARBPROC) (GLenum target, GL_SIZEI_PTR size, const GLvoid *data, GLenum usage);
typedef GLvoid* (APIENTRY* PFNGLMAPBUFFERPROC) (GLenum target, GLenum access);
typedef GLboolean (APIENTRY* PFNGLUNMAPBUFFERPROC) (GLenum target);

typedef void (APIENTRY* PFNGLMULTITEXCOORD4FVARBPROC) (GLenum target, const GLfloat *v);
typedef void (APIENTRY* PFNGLMULTITEXCOORD4FARBPROC) (GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q);
typedef void (APIENTRY* PFNGLACTIVETEXTUREARBPROC) (GLenum texture);
typedef void (APIENTRY* PFNGLCLIENTACTIVETEXTUREARBPROC) (GLenum texture);

extern PFNGLGENBUFFERSARBPROC p_glGenBuffersARB;
extern PFNGLBINDBUFFERARBPROC p_glBindBufferARB;
extern PFNGLBUFFERDATAARBPROC p_glBufferDataARB;
extern PFNGLDELETEBUFFERSARBPROC p_glDeleteBuffersARB;
extern PFNGLMAPBUFFERPROC p_glMapBufferARB;
extern PFNGLUNMAPBUFFERPROC p_glUnmapBufferARB;

extern PFNGLACTIVETEXTUREARBPROC p_glActiveTextureARB;

// GL_ARB_framebuffer_object
typedef GLboolean (APIENTRY * PFNGLISRENDERBUFFEREXTPROC) (GLuint renderbuffer);
typedef void (APIENTRY * PFNGLBINDRENDERBUFFEREXTPROC) (GLenum target, GLuint renderbuffer);
typedef void (APIENTRY * PFNGLDELETERENDERBUFFERSEXTPROC) (GLsizei n, const GLuint *renderbuffers);
typedef void (APIENTRY * PFNGLGENRENDERBUFFERSEXTPROC) (GLsizei n, GLuint *renderbuffers);
typedef void (APIENTRY * PFNGLRENDERBUFFEERSTORAGEEXTPROC) (GLenum target, GLenum internalformat, GLsizei w, GLsizei h);
typedef void (APIENTRY * PFNGLGETRENDERBUFFERPARAMETERIVEXTPROC) (GLenum target, GLenum pname, GLint* params);
typedef GLboolean (APIENTRY * PFNGLISFRAMEBUFFEREXTPROC) ( GLuint framebuffer);
typedef void (APIENTRY * PFNGLBINDFRAMEBUFFEREXTPROC) (GLenum target, GLuint framebuffer);
typedef void (APIENTRY * PFNGLDELETEFRAMEBUFFERSEXTPROC) (GLsizei n, const GLuint *framebuffers);
typedef void (APIENTRY * PFNGLGENFRAMEBUFFERSEXTPROC) (GLsizei n, GLuint *framebuffers);
typedef GLenum (APIENTRY * PFNGLCHECKFRAMEBUFFERSTATUSEXTPROC) (GLenum target);
typedef void (APIENTRY * PFNGLFRAMEBUFFERTEXTURE1DEXTPROC) (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
typedef void (APIENTRY * PFNGLFRAMEBUFFERTEXTURE2DEXTPROC) (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
typedef void (APIENTRY * PFNGLFRAMEBUFFERTEXTURE2DEXTPROC) (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level);
typedef void (APIENTRY * PFNGLFRAMEBUFFERTEXTURE3DEXTPROC) (GLenum target, GLenum attachment, GLenum textarget, GLuint texture, GLint level, GLint zoffset);
typedef void (APIENTRY * PFNGLFRAMEBUFFERRENDERBUFFEREXTPROC) (GLenum target, GLenum attachment, GLenum renderbuffertarget, GLuint renderbuffer);
typedef void (APIENTRY * PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC) (GLenum target, GLenum attachment, GLenum pname, GLint *params);

typedef void (APIENTRY * PFNGLGENERATEMIPMAPEXTPROC) (GLenum target);
typedef void (APIENTRY * PFNGLPOINTPARAMETERFEXTPROC) (GLenum pname, GLfloat param );

extern PFNGLISRENDERBUFFEREXTPROC          p_glIsRenderbufferEXT;
extern PFNGLBINDRENDERBUFFEREXTPROC        p_glBindRenderbufferEXT;
extern PFNGLDELETERENDERBUFFERSEXTPROC     p_glDeleteRenderbuffersEXT;
extern PFNGLGENRENDERBUFFERSEXTPROC        p_glGenRenderbuffersEXT;
extern PFNGLRENDERBUFFEERSTORAGEEXTPROC    p_glRenderbufferStorageEXT;
extern PFNGLGETRENDERBUFFERPARAMETERIVEXTPROC p_glGetRenderbufferParameterivEXT;
extern PFNGLISFRAMEBUFFEREXTPROC           p_glIsFramebufferEXT;
extern PFNGLBINDFRAMEBUFFEREXTPROC         p_glBindFramebufferEXT;
extern PFNGLDELETEFRAMEBUFFERSEXTPROC      p_glDeleteFramebuffersEXT;
extern PFNGLGENFRAMEBUFFERSEXTPROC         p_glGenFramebuffersEXT;
extern PFNGLCHECKFRAMEBUFFERSTATUSEXTPROC  p_glCheckFramebufferStatusEXT;
extern PFNGLFRAMEBUFFERTEXTURE2DEXTPROC    p_glFramebufferTexture2DEXT;
extern PFNGLFRAMEBUFFERRENDERBUFFEREXTPROC p_glFramebufferRenderbufferEXT;
extern PFNGLGETFRAMEBUFFERATTACHMENTPARAMETERIVEXTPROC p_glGetFramebufferAttachmentParameterivEXT;
extern PFNGLGENERATEMIPMAPEXTPROC          p_glGenerateMipmapEXT;

// 3D textures
typedef void (APIENTRY * PFNGLTEXIMAGE3DPROC) (GLenum target, GLint level, GLint internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLenum format, GLenum type, const GLvoid *pixels);
extern PFNGLTEXIMAGE3DPROC p_glTexImage3D;

/* -------------------- GL_EXT_texture_compression_s3tc -------------------- */

#define GL_COMPRESSED_RGB_S3TC_DXT1_EXT  0x83F0
#define GL_COMPRESSED_RGBA_S3TC_DXT1_EXT 0x83F1
#define GL_COMPRESSED_RGBA_S3TC_DXT3_EXT 0x83F2
#define GL_COMPRESSED_RGBA_S3TC_DXT5_EXT 0x83F3

typedef void (APIENTRY * PFNGLCOMPRESSEDTEXIMAGE2DPROC) (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid * data);
extern PFNGLCOMPRESSEDTEXIMAGE2DPROC p_glCompressedTexImage2D;

#ifndef GL_MAX_COLOR_ATTACHMENTS_EXT
#define GL_MAX_COLOR_ATTACHMENTS_EXT GL_MAX_COLOR_ATTACHMENTS_OES
#endif

#ifndef GL_DEPTH_ATTACHMENT_EXT
#define GL_DEPTH_ATTACHMENT_EXT GL_DEPTH_ATTACHMENT
#endif 

#ifndef GL_RENDERBUFFER_EXT
#define GL_RENDERBUFFER_EXT GL_RENDERBUFFER
#define GL_MAX_RENDERBUFFER_SIZE_EXT GL_MAX_RENDERBUFFER_SIZE
#endif

#ifndef GL_FRAMEBUFFER_EXT
#define GL_FRAMEBUFFER_EXT GL_FRAMEBUFFER
#define GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE
#define GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE
//#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL
#endif

//
// OpenGL 2.0
//
typedef void (APIENTRYP PFNGLBLENDEQUATIONSEPARATEPROC) (GLenum modeRGB, GLenum modeAlpha);
typedef void (APIENTRYP PFNGLDRAWBUFFERSPROC) (GLsizei n, const GLenum *bufs);
typedef void (APIENTRYP PFNGLSTENCILOPSEPARATEPROC) (GLenum face, GLenum sfail, GLenum dpfail, GLenum dppass);
typedef void (APIENTRYP PFNGLSTENCILFUNCSEPARATEPROC) (GLenum frontfunc, GLenum backfunc, GLint ref, GLuint mask);
typedef void (APIENTRYP PFNGLSTENCILMASKSEPARATEPROC) (GLenum face, GLuint mask);
typedef void (APIENTRYP PFNGLATTACHSHADERPROC) (GLuint program, GLuint shader);
typedef void (APIENTRYP PFNGLBINDATTRIBLOCATIONPROC) (GLuint program, GLuint index, const GLchar *name);
typedef void (APIENTRYP PFNGLCOMPILESHADERPROC) (GLuint shader);
typedef GLuint (APIENTRYP PFNGLCREATEPROGRAMPROC) (void);
typedef GLuint (APIENTRYP PFNGLCREATESHADERPROC) (GLenum type);
typedef void (APIENTRYP PFNGLDELETEPROGRAMPROC) (GLuint program);
typedef void (APIENTRYP PFNGLDELETESHADERPROC) (GLuint shader);
typedef void (APIENTRYP PFNGLDETACHSHADERPROC) (GLuint program, GLuint shader);
typedef void (APIENTRYP PFNGLDISABLEVERTEXATTRIBARRAYPROC) (GLuint index);
typedef void (APIENTRYP PFNGLENABLEVERTEXATTRIBARRAYPROC) (GLuint index);
typedef void (APIENTRYP PFNGLGETACTIVEATTRIBPROC) (GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLint *size, GLenum *type, GLchar *name);
typedef void (APIENTRYP PFNGLGETACTIVEUNIFORMPROC) (GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLint *size, GLenum *type, GLchar *name);
typedef void (APIENTRYP PFNGLGETATTACHEDSHADERSPROC) (GLuint program, GLsizei maxCount, GLsizei *count, GLuint *obj);
typedef GLint (APIENTRYP PFNGLGETATTRIBLOCATIONPROC) (GLuint program, const GLchar *name);
typedef void (APIENTRYP PFNGLGETPROGRAMIVPROC) (GLuint program, GLenum pname, GLint *params);
typedef void (APIENTRYP PFNGLGETPROGRAMINFOLOGPROC) (GLuint program, GLsizei bufSize, GLsizei *length, GLchar *infoLog);
typedef void (APIENTRYP PFNGLGETSHADERIVPROC) (GLuint shader, GLenum pname, GLint *params);
typedef void (APIENTRYP PFNGLGETSHADERINFOLOGPROC) (GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *infoLog);
typedef void (APIENTRYP PFNGLGETSHADERSOURCEPROC) (GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *source);
typedef GLint (APIENTRYP PFNGLGETUNIFORMLOCATIONPROC) (GLuint program, const GLchar *name);
typedef void (APIENTRYP PFNGLGETUNIFORMFVPROC) (GLuint program, GLint location, GLfloat *params);
typedef void (APIENTRYP PFNGLGETUNIFORMIVPROC) (GLuint program, GLint location, GLint *params);
typedef void (APIENTRYP PFNGLGETVERTEXATTRIBFVPROC) (GLuint index, GLenum pname, GLfloat *params);
typedef void (APIENTRYP PFNGLGETVERTEXATTRIBIVPROC) (GLuint index, GLenum pname, GLint *params);
typedef void (APIENTRYP PFNGLGETVERTEXATTRIBPOINTERVPROC) (GLuint index, GLenum pname, GLvoid* *pointer);
typedef GLboolean (APIENTRYP PFNGLISPROGRAMPROC) (GLuint program);
typedef GLboolean (APIENTRYP PFNGLISSHADERPROC) (GLuint shader);
typedef void (APIENTRYP PFNGLLINKPROGRAMPROC) (GLuint program);
#if defined(HK_PLATFORM_MAC386) || defined(HK_PLATFORM_IOS) || defined(GL_GLEXT_VERSION) && (GL_GLEXT_VERSION >= 85)
typedef void (APIENTRYP PFNGLSHADERSOURCEPROC) (GLuint shader, GLsizei count, const GLchar* const *string, const GLint *length);
#else
typedef void (APIENTRYP PFNGLSHADERSOURCEPROC) (GLuint shader, GLsizei count, const GLchar* *string, const GLint *length);
#endif
typedef void (APIENTRYP PFNGLUSEPROGRAMPROC) (GLuint program);
typedef void (APIENTRYP PFNGLUNIFORM1FPROC) (GLint location, GLfloat v0);
typedef void (APIENTRYP PFNGLUNIFORM2FPROC) (GLint location, GLfloat v0, GLfloat v1);
typedef void (APIENTRYP PFNGLUNIFORM3FPROC) (GLint location, GLfloat v0, GLfloat v1, GLfloat v2);
typedef void (APIENTRYP PFNGLUNIFORM4FPROC) (GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3);
typedef void (APIENTRYP PFNGLUNIFORM1IPROC) (GLint location, GLint v0);
typedef void (APIENTRYP PFNGLUNIFORM2IPROC) (GLint location, GLint v0, GLint v1);
typedef void (APIENTRYP PFNGLUNIFORM3IPROC) (GLint location, GLint v0, GLint v1, GLint v2);
typedef void (APIENTRYP PFNGLUNIFORM4IPROC) (GLint location, GLint v0, GLint v1, GLint v2, GLint v3);
typedef void (APIENTRYP PFNGLUNIFORM1FVPROC) (GLint location, GLsizei count, const GLfloat *value);
typedef void (APIENTRYP PFNGLUNIFORM2FVPROC) (GLint location, GLsizei count, const GLfloat *value);
typedef void (APIENTRYP PFNGLUNIFORM3FVPROC) (GLint location, GLsizei count, const GLfloat *value);
typedef void (APIENTRYP PFNGLUNIFORM4FVPROC) (GLint location, GLsizei count, const GLfloat *value);
typedef void (APIENTRYP PFNGLUNIFORM1IVPROC) (GLint location, GLsizei count, const GLint *value);
typedef void (APIENTRYP PFNGLUNIFORM2IVPROC) (GLint location, GLsizei count, const GLint *value);
typedef void (APIENTRYP PFNGLUNIFORM3IVPROC) (GLint location, GLsizei count, const GLint *value);
typedef void (APIENTRYP PFNGLUNIFORM4IVPROC) (GLint location, GLsizei count, const GLint *value);
typedef void (APIENTRYP PFNGLUNIFORMMATRIX2FVPROC) (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
typedef void (APIENTRYP PFNGLUNIFORMMATRIX3FVPROC) (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
typedef void (APIENTRYP PFNGLUNIFORMMATRIX4FVPROC) (GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
typedef void (APIENTRYP PFNGLVALIDATEPROGRAMPROC) (GLuint program);
typedef void (APIENTRYP PFNGLVERTEXATTRIB1FPROC) (GLuint index, GLfloat x);
typedef void (APIENTRYP PFNGLVERTEXATTRIB1FVPROC) (GLuint index, const GLfloat *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIB2FPROC) (GLuint index, GLfloat x, GLfloat y);
typedef void (APIENTRYP PFNGLVERTEXATTRIB2FVPROC) (GLuint index, const GLfloat *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIB3FPROC) (GLuint index, GLfloat x, GLfloat y, GLfloat z);
typedef void (APIENTRYP PFNGLVERTEXATTRIB3FVPROC) (GLuint index, const GLfloat *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIB4NIVPROC) (GLuint index, const GLint *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIB4FPROC) (GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
typedef void (APIENTRYP PFNGLVERTEXATTRIB4FVPROC) (GLuint index, const GLfloat *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIB4IVPROC) (GLuint index, const GLint *v);
typedef void (APIENTRYP PFNGLVERTEXATTRIBPOINTERPROC) (GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid *pointer);
extern PFNGLBLENDEQUATIONSEPARATEPROC p_glBlendEquationSeparate;
extern PFNGLDRAWBUFFERSPROC p_glDrawBuffers;
extern PFNGLSTENCILOPSEPARATEPROC p_glStencilOpSeparate;
extern PFNGLSTENCILFUNCSEPARATEPROC p_glStencilFuncSeparate;
extern PFNGLSTENCILMASKSEPARATEPROC p_glStencilMaskSeparate;
extern PFNGLATTACHSHADERPROC p_glAttachShader;
extern PFNGLBINDATTRIBLOCATIONPROC p_glBindAttribLocation; 
extern PFNGLCOMPILESHADERPROC p_glCompileShader;
extern PFNGLCREATEPROGRAMPROC p_glCreateProgram;
extern PFNGLCREATESHADERPROC p_glCreateShader;
extern PFNGLDELETEPROGRAMPROC p_glDeleteProgram; 
extern PFNGLDELETESHADERPROC p_glDeleteShader;
extern PFNGLDETACHSHADERPROC p_glDetachShader;
extern PFNGLDISABLEVERTEXATTRIBARRAYPROC p_glDisableVertexAttribArray;
extern PFNGLENABLEVERTEXATTRIBARRAYPROC p_glEnableVertexAttribArray;
extern PFNGLGETACTIVEATTRIBPROC p_glGetActiveAttrib;
extern PFNGLGETACTIVEUNIFORMPROC p_glGetActiveUniform;
extern PFNGLGETATTACHEDSHADERSPROC p_glGetAttachedShaders;
extern PFNGLGETATTRIBLOCATIONPROC p_glGetAttribLocation;
extern PFNGLGETPROGRAMIVPROC p_glGetProgramiv;
extern PFNGLGETPROGRAMINFOLOGPROC p_glGetProgramInfoLog;
extern PFNGLGETSHADERIVPROC p_glGetShaderiv;
extern PFNGLGETSHADERINFOLOGPROC p_glGetShaderInfoLog;
extern PFNGLGETSHADERSOURCEPROC p_glGetShaderSource;
extern PFNGLGETUNIFORMLOCATIONPROC p_glGetUniformLocation;
extern PFNGLGETUNIFORMFVPROC p_glGetUniformfv;
extern PFNGLGETUNIFORMIVPROC p_glGetUniformiv;
extern PFNGLGETVERTEXATTRIBIVPROC p_glGetVertexAttribiv;
extern PFNGLGETVERTEXATTRIBPOINTERVPROC p_glGetVertexAttribPointerv;
extern PFNGLISPROGRAMPROC p_glIsProgram;
extern PFNGLISSHADERPROC p_glIsShader;
extern PFNGLLINKPROGRAMPROC p_glLinkProgram;
extern PFNGLSHADERSOURCEPROC p_glShaderSource;
extern PFNGLUSEPROGRAMPROC p_glUseProgram;
extern PFNGLUNIFORM1FPROC p_glUniform1f;
extern PFNGLUNIFORM2FPROC p_glUniform2f;
extern PFNGLUNIFORM3FPROC p_glUniform3f;
extern PFNGLUNIFORM4FPROC p_glUniform4f;
extern PFNGLUNIFORM1IPROC p_glUniform1i;
extern PFNGLUNIFORM2IPROC p_glUniform2i;
extern PFNGLUNIFORM3IPROC p_glUniform3i;
extern PFNGLUNIFORM4IPROC p_glUniform4i;
extern PFNGLUNIFORM1FVPROC p_glUniform1fv;
extern PFNGLUNIFORM2FVPROC p_glUniform2fv;
extern PFNGLUNIFORM3FVPROC p_glUniform3fv;
extern PFNGLUNIFORM4FVPROC p_glUniform4fv;
extern PFNGLUNIFORM1IVPROC p_glUniform1iv;
extern PFNGLUNIFORM2IVPROC p_glUniform2iv;
extern PFNGLUNIFORM3IVPROC p_glUniform3iv; 
extern PFNGLUNIFORM4IVPROC p_glUniform4iv;
extern PFNGLUNIFORMMATRIX2FVPROC p_glUniformMatrix2fv;
extern PFNGLUNIFORMMATRIX3FVPROC p_glUniformMatrix3fv;
extern PFNGLUNIFORMMATRIX4FVPROC p_glUniformMatrix4fv;
extern PFNGLVALIDATEPROGRAMPROC p_glValidateProgram;
extern PFNGLVERTEXATTRIB1FPROC p_glVertexAttrib1f;
extern PFNGLVERTEXATTRIB1FVPROC p_glVertexAttrib1fv;
extern PFNGLVERTEXATTRIB2FPROC p_glVertexAttrib2f;
extern PFNGLVERTEXATTRIB2FVPROC p_glVertexAttrib2fv;
extern PFNGLVERTEXATTRIB3FPROC p_glVertexAttrib3f;
extern PFNGLVERTEXATTRIB3FVPROC p_glVertexAttrib3fv;
extern PFNGLVERTEXATTRIB4NIVPROC p_glVertexAttrib4Niv;
extern PFNGLVERTEXATTRIB4FPROC p_glVertexAttrib4f;
extern PFNGLVERTEXATTRIB4FVPROC p_glVertexAttrib4fv;
extern PFNGLVERTEXATTRIB4IVPROC p_glVertexAttrib4iv;
extern PFNGLVERTEXATTRIBPOINTERPROC p_glVertexAttribPointer;

#endif //HK_GRAPHICS_FUNC_PTRS_OGLES2_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
