/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_WINDOW_OGLES2_H
#define HK_GRAPHICS_WINDOW_OGLES2_H

#include <Graphics/Common/Window/hkgWindow.h>
#include <Graphics/OglES2/Shared/hkgFunctionPtrsOGLES2.h>

class hkgWindowOGLES2: public hkgWindow
{
	public:


		virtual void* getProcAddress(const char* proc) { return HK_NULL; }

		virtual void cleanup();

			// Set function pointers of supported functions.
			// This will fail on most platforms if a gl window has not been created.
		virtual void setupExtensionFunctions();

			// This will fail on most platforms if a gl window has not been created.
		static hkBool isExtensionSupported(const char* ext);
		
		virtual HKG_SHADOWMAP_SUPPORT getShadowMapSupport();
		virtual void prepareForShadowMap(int maxMaps); // creates depth AND NACL32 NACL64 render target
		virtual void beginShadowMapRender(class hkgDisplayWorld* world, class hkgCamera* camera, class hkgLight* light ); // sets the depth and render target to be the current
		virtual const class hkgCamera* startShadowMap( int ss, bool clearMap ); // returns the light frustum which is being used to render
		virtual void endShadowMap( int ss, bool blurMap );
		virtual int endShadowMapRender(int textureStageForMap, bool shaderDriven); // resets to the normal depth and render target
		virtual void revertShadowMapState(); // resets to the normal texture modes etc
		virtual void cleanupShadowMap(); // releases held targets
		virtual void setShadowMapSize(int size); 
		virtual int getShadowMapSize() const;
		virtual void enableDebugShadowMapView(bool on) const { m_debugShadowMaps = on; } 

		virtual const float* getComputedShadowMatrix(bool includeCameraViewMatrix, int i) const; // get the perspective shadow matrix
		virtual const float* getComputedShadowTextureMatrix(bool includeCameraViewMatrix, int i) const; // get the perspective shadow matrix with the texture lookup and bias baked in
	
		virtual bool supportsRenderTargetLock() { return true; }
		virtual bool lockCurrentRenderTarget(hkgFrameBufferDesc& desc, hkgFrameBufferRect* lockRect);
		virtual bool unlockCurrentRenderTarget();
		
		void displayShadowMap();

		virtual int getVideoMemSizeInMB() const { return 256; } // PC will override this
        virtual void getDisplayAdapterDescription(extStringBuf& description) const;

		hkBool m_supportsHWShadowMaps;
		hkBool m_supportsDepthRenderTargets;
		hkBool m_supportsVSM;
		hkBool m_supportsL32F;
		hkBool m_supports16F;
		hkBool m_supportsLA32F;
		hkBool m_supports32F;
	
		virtual void setDeviceRotation( float degreesClockwise /*0..379*/, bool lock );
		inline bool isDeviceRotationEnabled() { return m_allowDeviceRotation; }
		inline float getDeviceRotation() const { return m_deviceRotation; }
		
		const float* getDeviceRotationMatrix() const;
		void transformDevicePoint( float hkgp[2], const float dp[2]) const;
		
		// iOS etc will return whether it is a iPod Touch, iPhone 3GS etc
		virtual void getPlatformString(hkStringBuf& buffer) const { buffer = "unknown"; }	
		
	protected:

		hkgWindowOGLES2();
		virtual ~hkgWindowOGLES2();

		void initShaderCollection();

		int						m_shadowMapSize;
		HKG_SHADOWMAP_SUPPORT   m_shadowMapSupport;

		HKG_ENABLED_STATE		m_nonShadowState;

		
		int						m_currentShadowTextureStage;
		mutable float			m_shadowTexMatrix[16];
		mutable bool			m_debugShadowMaps;
		hkgShaderEffect*		m_debugShadowMapShaders;
		hkgShaderEffect*		m_blurShadowMapShaders;
		
		GLuint							m_shadowColorTexture;     // float texture
		GLuint							m_shadowColorBlurTexture; // float texture 
		class hkgRenderTargetOGLES2*		m_pShadowZ; // depth texture
		class hkgFrameBufferOGLES2*		m_pShadowFrameBuffer; // attach float color AND NACL32 NACL64 z as the current fbo

		float m_deviceRotation;
		float m_deviceRotationMatrix[16];
		
		bool m_allowDeviceRotation;
	
		unsigned char* m_framebuffer; ///< used for screen dumps	
		int m_framebufferSize;
};


#endif //HK_GRAPHICS_WINDOW_OGLES2_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
