/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */
#ifndef HK_GRAPHICS_SHADER_EFFECT_OGLES2__H
#define HK_GRAPHICS_SHADER_EFFECT_OGLES2__H

#include <Graphics/Common/Shader/hkgShaderEffect.h>
#include <Graphics/Common/Geometry/VertexSet/hkgVertexSetDefines.h>

#define HKG_INVALID_COMPONENT_LOCATION 0xffffffff

class hkgShaderEffectOGLES2 : public hkgShaderEffect
{
public:
	
	inline static hkgShaderEffect* createShaderEffectOGLES2();

	virtual void feedShaders(hkgDisplayContext* ctx, bool onlyFeedDirty, const hkgVertexSet* vertexHints);
	
	virtual const extArray<ShaderInput>* getInputOrder() const ;
	
	virtual void setWKNFloatInputIndex( int i, const float* v, int numV);
	virtual void setWKNFloatInput(HKG_SHADER_INPUT_CONSTANT semantic, int i, const float* v, int numV);
	virtual void setWKNMatFloatInput(HKG_SHADER_MAT_INPUT_CONSTANT semantic, int i, const float* v, int numV);
	virtual void setFloatInputByName( const char* n, const float* v, int numV );
	virtual void uploadConstants();
	virtual bool needsVertexInformation() const ;

	inline GLuint getComponentLocation(HKG_VERTEX_COMPONENT c) const;
  inline GLuint getSamplerLocation(int stage, bool cube) const;
	
	// Internal
	inline GLuint getProgram() const;

protected:

	virtual void bind(hkgDisplayContext* ctx, const hkgVertexSet* vertexSetHint, bool changesEffect);
	virtual void unbind(hkgDisplayContext* ctx);

	hkgShaderEffectOGLES2();
	virtual ~hkgShaderEffectOGLES2();

	void findWellKnownParams();
	void addNormalInput( HKG_SHADER_INPUT_CONSTANT semantic, int components, int locIndex );
	void addMatInput( HKG_SHADER_MAT_INPUT_CONSTANT semantic, int components, int locIndex );

	extArray< GLint > m_knownParams;

	// Similar to normal hkgShader
	extArray<ShaderInput> m_inputOrder;
	HKG_SHADER_INPUT_CONSTANT m_allNormalInputs; 
	HKG_SHADER_MAT_INPUT_CONSTANT m_allMatrixInputs;
	bool m_needsVertexInformation;

	mutable GLuint m_compLoc[ HKG_VERTEX_COMPONENT_NUM ];
  mutable GLint m_sampler2DLoc[ 8 ];
  mutable GLint m_samplerCubeLoc[ 8 ];

	GLuint m_program;
	bool m_linked;
};

#include <Graphics/OglES2/Shared/Shader/hkgShaderEffectOGLES2.inl>

#endif //HK_GRAPHICS_SHADER_EFFECT_OGLES2__H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
