/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_VERTEX_SET_OGLES2_H
#define HK_GRAPHICS_VERTEX_SET_OGLES2_H

#include <Graphics/Common/Geometry/VertexSet/hkgVertexSet.h>

class hkgVertexSetOGLES2: public hkgVertexSet
{
public:

	static hkgVertexSet* createVertexSetOGLES2( hkgDisplayContext* context)
	{
		return new hkgVertexSetOGLES2( context);
	}

	virtual ~hkgVertexSetOGLES2();

	virtual void setDesiredVertexComponentFormat( HKG_VERTEX_COMPONENT component, HKG_VERTEX_STORAGE s);
	virtual void setDesiredVertexComponentLayout( HKG_VERTEX_STORAGE_LAYOUT l);  
	virtual HKG_VERTEX_STORAGE_LAYOUT getVertexComponentLayout( ) const;  

	virtual void setNumVerts(int nv, HKG_VERTEX_FORMAT format, HKG_VERTEX_BUFFER_ACCESS accessFlags = HKG_VERTEX_BUFFER_ACCESS_DEFAULT );

	virtual unsigned char* lock(HKG_LOCK_FLAG f);  
	virtual unsigned char* partialLock(HKG_LOCK_FLAG f, HKG_VERTEX_FORMAT vertexFormatPartsToLock);

	virtual void unlock();

	virtual int getVertexComponentStream( HKG_VERTEX_COMPONENT component ) const;
	virtual int getVertexComponentStreamOffset( HKG_VERTEX_COMPONENT component ) const;

	virtual void setStreams(); 
	virtual void clearStreams();

protected:

	hkgVertexSetOGLES2( hkgDisplayContext* context);

	HKG_VERTEX_FORMAT m_currentLockFormat;

	HKG_VERTEX_STORAGE_LAYOUT m_desiredLayout;
	HKG_VERTEX_STORAGE m_desiredStorageFormats[HKG_VERTEX_COMPONENT_NUM]; // the format of each vert component

	struct BufferInfo
	{
		BufferInfo() : m_localBuffer(HK_NULL),m_vbo(0), m_stride(0), m_aligned(false), m_frequentAccess(false), m_mappedBuffer(HK_NULL), m_localUpdate(false) { }
		unsigned char* m_localBuffer;
	
		GLuint m_vbo;
		GLuint m_stride;
		bool m_aligned;
		bool m_frequentAccess;

		unsigned char* m_mappedBuffer;
		bool m_localUpdate;

	};

	extArray< BufferInfo > m_buffers;	

	int m_componentBufferIndex[HKG_VERTEX_COMPONENT_NUM]; 
	hkUlong	m_vboOffsets[HKG_VERTEX_COMPONENT_NUM];
	GLuint m_vboTexNum[HKG_VERTEX_COMPONENT_NUM];

	GLuint m_tangentsTexCoord; 
	GLuint m_weightsTexCoord;
};

#include <Graphics/OglES2/Shared/Geometry/VertexSet/hkgVertexSetOGLES2.inl>

#endif //HK_GRAPHICS_VERTEX_SET_OGLES2_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
