/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_WINDOW_MANAGER_PC_ES2_H
#define HK_GRAPHICS_WINDOW_MANAGER_PC_ES2_H

#include <Graphics/OglES2/Pc/Window/hkgWindowPCOGLES2.h>
#include <Common/Base/Container/PointerMap/hkPointerMap.h> 
#include <Common/Base/Object/hkSingleton.h>

//
// It is not Havok mem managed as we
// may need to have the manager present after 
// hkBaseSystem:: quit just to tell the wndproc 
// that the havok managed window system has shut down (hkgWindow list is empty)
// It should not be a big mem resource anyway and is only on PC.
// Add, find, and remove use a critical section for the map access
//

class hkgWindowManagerPCOGLES2: public hkgReferencedObject, public hkLocalSingleton<hkgWindowManagerPCOGLES2>
{
public:
	
	// There should be no need to create more than one of these,
	// and that one is created globally.

	hkgWindowManagerPCOGLES2();
	~hkgWindowManagerPCOGLES2();

	// will not reference actual hkgWindow as it 
	// will assume that windows are only added and 
	// removed under hkgWindow dtor and ctor
	bool addWindow( HWND handle, hkgWindowPCOGLES2* w );
	bool setHWND( HWND handle, hkgWindowPCOGLES2* w );

	hkgWindowPCOGLES2* findWindow( HWND handle ) const;
	
	bool removeWindow( HWND handle );
	
protected:

	extPointerMap<void*, hkgWindowPCOGLES2*> m_hwndMap; 
	HANDLE m_hMutex;
};

#endif // HK_GRAPHICS_WINDOW_MANAGER_PC_ES2_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
