/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_OGLES_PRECOMPILE_H
#define HK_GRAPHICS_OGLES_PRECOMPILE_H

#include <Graphics/Common/hkGraphics.h> // the source header for the hkg precompiles

#if defined(WIN32)
#	ifndef _WINDOWS_
#		define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
#		undef _WIN32_WINNT 
#		define _WIN32_WINNT 0x0500	  // xp/2000
#		undef _WIN32_WINDOWS  
#		define _WIN32_WINDOWS 0x0500 // xp/2000
#		if (_MSC_VER >= 1400)
#			define _CRT_SECURE_NO_DEPRECATE 1
#			define _CRT_NONSTDC_NO_DEPRECATE 1
#		endif
#		include <windows.h>
#	endif
#elif defined(HK_PLATFORM_X64)
#	define WIN32_LEAN_AND_MEAN		// Exclude rarely-used stuff from Windows headers
//#	define _WIN32_WINNT 0x0500	  // xp/2000
#	define _WIN32_WINDOWS 0x0500 // xp/2000
#	include <windows.h>

#define GL_ARRAY_BUFFER_ARB 0x8892
#define GL_STATIC_DRAW_ARB 0x88E4

#endif

// OpenGL - latest glext.h available from http://www.opengl.org/registry/api/glext.h, not the old SGI sites
#if defined(HK_PLATFORM_MAC386) || defined(HK_PLATFORM_MACPPC) 
#	include <OpenGL/gl.h>
#	include <OpenGL/glext.h>

#elif defined(HK_PLATFORM_IOS)
//#   include <OpenGLES/EAGL.h>
#	 include <OpenGLES/ES1/gl.h>
#	 include <OpenGLES/ES1/glext.h>

#    define GL_ELEMENT_ARRAY_BUFFER_ARB GL_ELEMENT_ARRAY_BUFFER 
#    define GL_ARRAY_BUFFER_ARB GL_ARRAY_BUFFER
#    define GL_DYNAMIC_DRAW_ARB GL_DYNAMIC_DRAW
#    define GL_ARRAY_BUFFER_ARB GL_ARRAY_BUFFER
#    define GL_STATIC_DRAW_ARB GL_STATIC_DRAW
#    define GL_TEXTURE0_ARB GL_TEXTURE0

#elif defined(HK_PLATFORM_ANDROID)
#	define GL_GLEXT_PROTOTYPES
#	include <jni.h>
#    ifndef HK_ANDROID_PLATFORM_8
#        include <EGL/egl.h>
#    endif
#	include <GLES/gl.h>
#	include <GLES/glext.h>
#	include <GLES/glplatform.h>
#	define ARB(X) X

#elif defined(HK_PLATFORM_TIZEN)
//~      include <gl.h>
//~     include <egl.h>
//~     include <osp/glext.h>
#include <FGraphics.h>
#   include <FGraphicsOpengl.h>
using namespace Tizen::Graphics::Opengl;
#    define ARB(X) X

#else
#	include <GL/gl.h>
#	include <GL/glext.h>
#endif

#if defined(HK_PLATFORM_IOS) || defined(HK_PLATFORM_ANDROID)
#define HKG_IS_REALLY_OES 1
#else
#define HKG_IS_REALLY_OES 0
#endif

#ifndef ARB
#	define ARB(X) X##_ARB
#endif

#endif //HK_GRAPHICS_OGLES_PRECOMPILE_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
