/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_WINDOW_OGLES_H
#define HK_GRAPHICS_WINDOW_OGLES_H

#include <Graphics/Common/Window/hkgWindow.h>

#if defined(HK_PLATFORM_ANDROID) || defined(HK_PLATFORM_IOS) || defined(HK_PLATFORM_TIZEN)
typedef GLsizeiptr GLsizeiptrARB;
#endif

// For non-Win32 platforms
#ifndef APIENTRY
#define APIENTRY
#endif
#ifndef APIENTRYP
#define APIENTRYP APIENTRY *
#endif
#ifndef GLAPI
#define GLAPI extern
#endif


typedef void (APIENTRY * __PFNGLBINDBUFFERARBPROC) (GLenum target, GLuint buffer);
typedef void (APIENTRY * __PFNGLDELETEBUFFERSARBPROC) (GLsizei n, const GLuint *buffers);
typedef void (APIENTRY * __PFNGLGENBUFFERSARBPROC) (GLsizei n, GLuint *buffers);
typedef void (APIENTRY* __PFNGLBUFFERDATAARBPROC) (GLenum target, GLsizeiptrARB size, const GLvoid *data, GLenum usage);
typedef GLvoid* (APIENTRY* __PFNGLMAPBUFFERPROC) (GLenum target, GLenum access);
typedef GLboolean (APIENTRY* __PFNGLUNMAPBUFFERPROC) (GLenum target);

typedef void (APIENTRY* __PFNGLMULTITEXCOORD4FARBPROC) (GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q);
typedef void (APIENTRY* __PFNGLACTIVETEXTUREARBPROC) (GLenum texture);
typedef void (APIENTRY* __PFNGLCLIENTACTIVETEXTUREARBPROC) (GLenum texture);
typedef GLboolean (APIENTRY * __PFNWGLSWAPINTERVALEXT) ( GLuint param );

extern __PFNGLGENBUFFERSARBPROC ___glGenBuffersARB;
extern __PFNGLBINDBUFFERARBPROC ___glBindBufferARB;
extern __PFNGLBUFFERDATAARBPROC ___glBufferDataARB;
extern __PFNGLDELETEBUFFERSARBPROC ___glDeleteBuffersARB;
extern __PFNGLMAPBUFFERPROC ___glMapBufferARB;
extern __PFNGLUNMAPBUFFERPROC ___glUnmapBufferARB;

extern __PFNGLMULTITEXCOORD4FARBPROC ___glMultiTexCoord4fARB;
extern __PFNGLACTIVETEXTUREARBPROC ___glActiveTextureARB;
extern __PFNGLCLIENTACTIVETEXTUREARBPROC ___glClientActiveTextureARB;
extern __PFNWGLSWAPINTERVALEXT ___glSwapIntervalEXT;


/* -------------------- GL_EXT_texture_compression_s3tc -------------------- */

#define GL_COMPRESSED_RGB_S3TC_DXT1_EXT 0x83F0
#define GL_COMPRESSED_RGBA_S3TC_DXT1_EXT 0x83F1
#define GL_COMPRESSED_RGBA_S3TC_DXT3_EXT 0x83F2
#define GL_COMPRESSED_RGBA_S3TC_DXT5_EXT 0x83F3

typedef void (APIENTRY * __PFNGLCOMPRESSEDTEXIMAGE2DPROC) (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLint border, GLsizei imageSize, const GLvoid * data);
typedef void (APIENTRY * __PFNGLCOMPRESSEDTEXIMAGE3DPROC) (GLenum target, GLint level, GLenum internalformat, GLsizei width, GLsizei height, GLsizei depth, GLint border, GLsizei imageSize, const GLvoid * data);
extern __PFNGLCOMPRESSEDTEXIMAGE2DPROC ___glCompressedTexImage2D;
extern __PFNGLCOMPRESSEDTEXIMAGE3DPROC ___glCompressedTexImage3D;


class hkgWindowOGLES : public hkgWindow
{
	public:
		hkgWindowOGLES();
		virtual ~hkgWindowOGLES();

		virtual void cleanup();

		virtual void* getProcAddress(const char* proc) { return HK_NULL; }
		
			// Set function pointers of supported functions.
			// This will fail on most platforms if a gl window has not been created.
		virtual void setupExtensionFunctions();

			// This will fail on most platforms if a gl window has not been created.
		static hkBool isExtensionSupported(const char* ext);
		virtual bool supportsRenderTargetLock() { return true; }
		virtual bool renderTargetReadyPreSwap() { return true; } // most platforms query the render target, not the swapped display buffer. Some the other way around.
		virtual bool lockCurrentRenderTarget(hkgFrameBufferDesc& desc, hkgFrameBufferRect* lockRect);
		virtual bool unlockCurrentRenderTarget();
		
	
		virtual void setDeviceRotation( float degreesClockwise /*0..379*/, bool lock );
		inline bool isDeviceRotationEnabled() { return m_allowDeviceRotation; }
		inline float getDeviceRotation() const { return m_deviceRotation; }
		
		const float* getDeviceRotationMatrix() const;
		void transformDevicePoint( float hkgp[2], const float dp[2]) const;
		
		// iOS etc will return whether it is a iPod Touch, iPhone 3GS etc
		virtual void getPlatformString(hkStringBuf& buffer) const { buffer = "unknown"; }	

	protected:

		float m_deviceRotation;
		float m_deviceRotationMatrix[16];
		bool m_allowDeviceRotation;	

		unsigned char* m_framebuffer; ///< used for screen dumps
		int m_framebufferSize;
};




#endif //HK_GRAPHICS_WINDOW_OGLES_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
