/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */

#ifndef HK_GRAPHICS_VERTEX_SET_OGLES_H
#define HK_GRAPHICS_VERTEX_SET_OGLES_H

#include <Graphics/Common/Geometry/VertexSet/hkgVertexSet.h>

class hkgVertexSetOGLES : public hkgVertexSet
{
public:

	static hkgVertexSet* createVertexSetOGLES(hkgDisplayContext* context)
	{
		return new hkgVertexSetOGLES(context);
	}

	virtual ~hkgVertexSetOGLES();

	virtual void setNumVerts(int nv, HKG_VERTEX_FORMAT vertexFormat, HKG_VERTEX_BUFFER_ACCESS accessFlags = HKG_VERTEX_BUFFER_ACCESS_DEFAULT);

	virtual unsigned char* lock(HKG_LOCK_FLAG f);  
	virtual void unlock();

	virtual int getVertexComponentStream( HKG_VERTEX_COMPONENT component ) const;
	virtual int getVertexComponentStreamOffset( HKG_VERTEX_COMPONENT component ) const;

	virtual void setStreams(); 
	virtual void clearStreams();

protected:

	inline hkgVertexSetOGLES(hkgDisplayContext* context);

	struct Buffers 
	{
		unsigned char*	m_pos; // sys mem buffer
		unsigned char*	m_normal; // sys mem buffer
		unsigned char*	m_weights; // sys mem buffer
		unsigned char*	m_indices; // sys mem buffer
		unsigned char*	m_tex[4]; // sys mem buffer
		unsigned char*	m_tangents[2]; // sys mem buffer
		unsigned char*	m_col; // sys mem buffer
	};

	Buffers			m_buffers;

	GLuint			m_vboPos; // vid mem buffer, if supported
	GLuint			m_vboNormal; // vid mem buffer, if supported
	GLuint			m_vboWeights; // vid mem buffer, if supported
	GLuint			m_vboIndices; // vid mem buffer, if supported
	GLuint			m_vboTex[4]; // vid mem buffer, if supported
	GLuint			m_vboTangents[2]; // vid mem buffer, if supported
	GLuint			m_vboCol; // vid mem buffer, if supported

};

#include <Graphics/OglES/Shared/Geometry/VertexSet/hkgVertexSetOGLES.inl>

#endif //HK_GRAPHICS_VERTEX_SET_OGLES_H

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
