/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


#pragma once

class hkThreadMemory;
class hkFileSystem;
class hkError;

namespace Havok {
namespace Graphics {


	public delegate void hkgErrorReportDelegate( String^ message );
	
	/// If an impl of this interface is found, it will look after the mem sub system etc (Havok base system init and quit)
	/// Normally you would not call init or quit on this directly, use the hkgSystemCLR to look after that for you safely
	public ref class hkgBaseSystemCLR
	{
		public:
			
			// call either init will null or with your (other) base system info for hkg to share
			static void init( );
			static void init(System::IntPtr info);
			
			static bool isInitialized();
			static bool inErrorState();
			static bool ownMemSystem();

			// Will only work if HKG initialized the error handler (ie, if init() was called without an info ptr)
			static void addReportDelegate( Form^ parent, hkgErrorReportDelegate^ errD );
			static void removeReportDelegate( hkgErrorReportDelegate^ errD );

			// IntPtr is a ptr to a hkMemoryInitUtil::SyncInfo struct
			static System::IntPtr getBaseSyncInfoAsStaticPtr(); // a ptr to a plain C struct with the above members. Ret value valid until next call.
			
			static void refreshDebugSymbols();

			static void quit();
	};

	public ref class hkgSystemCLR
	{
	public:
		
		enum struct Renderer // CLR enum
		{
			NONE,
			OPENGLES, // OpenGL ES (fixed function, as used on low end or embedded platforms, so low end iPhone etc)
			OPENGLS, // OpenGL (Shaders Only, the PS3 renderer, used Cg for shaders)
			OPENGLES2, // OpenGL ES Shaders Only, the iPad renderer etc, used GLSL for shaders
			DIRECT3D9, // uses both shaders and the fixed function
			DIRECT3D11  // Available in Vista( with Platform Update) or Win7 only, the DX11 renderer
		};
		
		// If the base system is not initialized already this will do a default init.
		static Renderer init( Renderer preferedRenderer, System::IntPtr baseSystem );
		static System::IntPtr getGraphicsInfoAsStaticPtr();
		static void quit( );
		static Renderer getCurrentRenderer();
		static String^ getRendererAsString(Renderer r);
		static void addSystemReference(Object^ referencedByObject);
		static void removeSystemReference(Object^ referencedByObject);
	};

} // Graphics
} // Havok

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
