/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


#pragma once

class hkgCamera;

#include <Graphics/Managed/Math/hkgMathCLR.h>

namespace Havok {
namespace Graphics {

	public ref class hkgRawStreamCLR : public System::IO::Stream
	{
	
	public:
		hkgRawStreamCLR(unsigned char* origData, int len);
		hkgRawStreamCLR(IntPtr origData, int len); // for managed only access
		~hkgRawStreamCLR();

		// Stream Methods that require implementation.
		virtual int Read( array<unsigned char>^ buffer, int offset, int count ) override;
		virtual void Write( array<unsigned char>^ buffer, int offset, int count ) override;
		virtual __int64 Seek( __int64 offset, System::IO::SeekOrigin origin ) override;
		virtual void SetLength( __int64 value)  override;
		virtual void Flush() override;
		virtual void Close() override;
		virtual IntPtr GetData()
		{
			return (IntPtr)&(m_data[m_pos]);
		}

		// Stream Properties that require implementation.
		property virtual bool CanRead 
		{
			bool get() override { return true; }
		}

		property virtual bool CanWrite 
		{
			bool get() override { return true; }
		}

		property virtual bool CanSeek 
		{
			bool get() override { return true; }
		}

		property virtual __int64 Length 
		{
			__int64 get() override { return m_len; } 
		}

		property virtual __int64 Position 
		{
			__int64 get() override 
			{
				return m_pos; 
			}

			void set(__int64 p ) override 
			{ 
				m_pos = (int)p; 
				if (m_pos < 0 ) 
				{ 
					m_pos = 0; 
				}
				else if (m_pos >= m_len)
				{
					m_pos = m_len - 1;
				}
			}
		}
		
	private:

		unsigned char* m_data;
		int m_len;
		int m_pos;
	};


} // Graphics
} // Havok

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
