/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


#pragma once

using namespace System;
using namespace System::ComponentModel;
using namespace System::Drawing;
using namespace System::Windows::Forms;
using namespace System::Collections::Generic;

#include <Graphics/Common/Window/hkgWindowDefines.h>
#include <Graphics/Common/DisplayContext/hkgDisplayContextDefines.h>

#include <Graphics/Managed/Math/hkgMathCLR.h>
#include <Graphics/Managed/Input/hkgInputCLR.h>

class hkgWindow;

namespace Havok {
namespace Graphics {

	ref class hkgDisplayContextCLR;
	ref class hkgDisplayWorldCLR;
	ref class hkgViewportCLR;
	ref class hkgCameraCLR;
	ref class hkgLightCLR; 
	ref class hkgShaderDefineCLR; 
	ref class hkgPostEffectCLR;

	public ref class hkgWindowCLR
	{
		public:

			enum struct ShadowMapSupport
			{
				NOTKNOWN = HKG_SHADOWMAP_NOTKNOWN,  
				NOSUPPORT = HKG_SHADOWMAP_NOSUPPORT, 
				HARDWARE = HKG_SHADOWMAP_HARDWARE,  
				FLOATMAP = HKG_SHADOWMAP_FLOATMAP, 
				VARIANCESHADOWMAP = HKG_SHADOWMAP_VSM
			};

			enum struct MeshBlendingSupport
			{
				NOTKNOWN = HKG_MESHBLENDING_NOTKNOWN,  
				NOSUPPORT = HKG_MESHBLENDING_NOSUPPORT, 
				HARDWARE = HKG_MESHBLENDING_HARDWARE,   
				SOFTWARE_WORLD = HKG_MESHBLENDING_SOFTWARE_WORLD,
				SOFTWARE_LOCAL = HKG_MESHBLENDING_SOFTWARE_LOCAL
			};

			enum struct ShadowMapMode
			{
				NONE = HKG_SHADOWMAP_MODE_NONE,
				FIXED = HKG_SHADOWMAP_MODE_FIXED,  // for single map 
				PSM = HKG_SHADOWMAP_MODE_PSM, // not really supported
				VSPSM = HKG_SHADOWMAP_MODE_PSVSM // for multiple (parallel split) scene wide maps. Requires VSM in current impl.
			};

			enum struct VelocityMapSupport
			{
				NOTKNOWN = HKG_VELOCITYMAP_NOTKNOWN,
				NOSUPPORT = HKG_VELOCITYMAP_NOSUPPORT,
				FLOAT = HKG_VELOCITYMAP_FLOAT
			};

			enum struct WindowCreateFlags
			{
				//
				// Normal flags
				//

				DEFAULT = HKG_WINDOW_DEFAULT,
				WINDOWED = HKG_WINDOW_WINDOWED,
				FULLSCREEN = HKG_WINDOW_FULLSCREEN,
				PRIMARY_DEVICE = HKG_WINDOW_PRIMARY_DEVICE,
				SECONDARY_DEVICE = HKG_WINDOW_SECONDARY_DEVICE,
				TERTIARY_DEVICE = HKG_WINDOW_TERTIARY_DEVICE,
				QUATERNARY_DEVICE = HKG_WINDOW_QUATERNARY_DEVICE,
				MSAA = HKG_WINDOW_MSAA,
				VSYNC = HKG_WINDOW_VSYNC,

				//
				// Hints
				//

				HINT_VGA = HKG_WINDOW_HINT_VGA,		
				HINT_480i = HKG_WINDOW_HINT_480i,	
				HINT_480p = HKG_WINDOW_HINT_480p,	
				HINT_576i = HKG_WINDOW_HINT_576i,	
				HINT_576p = HKG_WINDOW_HINT_576p,	
				HINT_720i = HKG_WINDOW_HINT_720i,	
				HINT_720p = HKG_WINDOW_HINT_720p,	
				HINT_1080i = HKG_WINDOW_HINT_1080i,	
				HINT_1080p = HKG_WINDOW_HINT_1080p,	

				HINT_MSAAQUALITY = HKG_WINDOW_HINT_MSAAQUALITY,	
				HINT_MSAASAMPLES = HKG_WINDOW_HINT_MSAASAMPLES,
				HINT_MSAAQUALITY_SHIFT = HKG_WINDOW_HINT_MSAAQUALITY_SHIFT, 
				HINT_MSAASAMPLES_SHIFT = HKG_WINDOW_HINT_MSAASAMPLES_SHIFT, 

				HINT_VSYNCINTERVAL = HKG_WINDOW_HINT_VSYNCINTERVAL,
				HINT_VSYNCINTERVAL_SHIFT = HKG_WINDOW_HINT_VSYNCINTERVAL_SHIFT
			};

			hkgWindowCLR( IntPtr windowHandle );
			hkgWindowCLR( IntPtr windowHandle, WindowCreateFlags flags );
			hkgWindowCLR( hkgWindowCLR^ other );
	
			~hkgWindowCLR();

			void hookUpEvents( Control^ ctrl );
			void removeEvents( );

			void setMouseButtonEventMask( hkgMouseCLR::Button acceptButtons );

			void eventMouseMove( Object^ /*sender*/, System::Windows::Forms::MouseEventArgs^ e);
			void eventMouseDown( Object^ /*sender*/, System::Windows::Forms::MouseEventArgs^ e);
			void eventMouseUp( Object^ /*sender*/, System::Windows::Forms::MouseEventArgs^ e);
			void eventMouseWheel( Object^ /*sender*/, System::Windows::Forms::MouseEventArgs^ e);
			void eventKeyDown( Object^ /*sender*/, System::Windows::Forms::KeyEventArgs^ e);
			void eventKeyUp( Object^ /*sender*/, System::Windows::Forms::KeyEventArgs^ e);
			void eventResize( Object^ /*sender*/, System::EventArgs^ e); 
			
			void processMouseMove(int x, int y, bool isVirtual);
			void processMouseWheel(int delta, int x, int y, bool isVirtual);
			void processMouseButton(hkgMouseCLR::Button button, bool state, int x, int y, bool isVirtual);  
			void processKey(hkgKeyboardCLR::Key c, bool state);
			void processPadStickMove( short pad, short stick, float x, float y);
			void processPadButton( short pad, hkgPadCLR::Button button, bool state);
			bool processWindowCommand(unsigned int code, unsigned int id, void* nativeHandle);

			bool updateSize();

			bool updatePos( int x, int y);
			bool setAsCurrent(); 
			
			bool clearBuffers();
			bool swapBuffers();
			
			void stepInput(); 
			void renderToAllViewports( hkgDisplayWorldCLR^ w );

			unsigned int getWidth();
			unsigned int getHeight();
			int getTVDeadZoneH();
			int getTVDeadZoneV();
			bool isFullscreen();
			bool isWidescreen();
			bool hasWidescreenAspect();
			void setClearColor( hkgVector3CLR c );
			hkgVector3CLR getClearColor( );
			
			IntPtr getPlatformHandle(); 

			int addViewport(hkgViewportCLR^ v);
			int getNumViewports();
			hkgViewportCLR^ getViewport(int i);
			int getViewportID(hkgViewportCLR^ v);
			hkgViewportCLR^ getCurrentViewport();
			int getCurrentViewportIndex();
			void setCurrentViewport( int i);
			hkgViewportCLR^ removeViewport(int i); 

			hkgDisplayContextCLR^ getContext();

			hkgViewportCLR^ getWindowOrthoView(); 
			
			hkgMouseCLR^ getMouse();
			hkgKeyboardCLR^ getKeyboard();
			bool hasGamePads();
			hkgPadCLR^ getGamePad(int i);	

			void setMousePosition(int x,int y);
			void showMouseCursor(bool visible);
		

			// XX TODO : User process callback functions as per the c++ version

			void setWantViewportBorders(bool on);
			void setWantViewportThickGrayBorders(bool on);
			void setWantViewportResizeByMouse(bool on);
			
			void setWantDrawMousePointer(bool on);
			bool getWantDrawMousePointer();

			void setWantDrawHavokLogo(bool on);
			bool getWantDrawHavokLogo();

			void setWantVirtualMouse(bool on); 
			bool getWantVirtualMouse(); 

			void setVirtualMousePos(int x, int y);

			void setMouseSpeedOnAllViewports(int pan, int wheelZoom, int buttonZoom, bool absoluteSpeeds);	
			void setPadSpeedOnAllViewports(int pan, int zoom, bool absoluteSpeeds);

			unsigned int vertexShaderMinorVersion();
			unsigned int vertexShaderMajorVersion();
			unsigned int geometryShaderMinorVersion();
			unsigned int geometryShaderMajorVersion();
			unsigned int pixelShaderMinorVersion();
			unsigned int pixelShaderMajorVersion();

			ShadowMapSupport getShadowMapSupport();
			bool shaderSupportGreaterOrEqualTo(int ver);
			void buildCommonShaderDefines(List<hkgShaderDefineCLR^>^ defines);

			void prepareForShadowMap(int maxNumMaps);
			void beginShadowMapRender( hkgDisplayWorldCLR^ world, hkgCameraCLR^ camera, hkgLightCLR^ light );
			hkgCameraCLR^ startShadowMap( int ss, bool clearMap );
			void endShadowMap( int ss );
			int  endShadowMapRender(int textureStageForMap, bool shaderDriven);
			void revertShadowMapState();
			void cleanupShadowMap();
			int  getShadowMapSize();
			const float* getComputedShadowMatrix(bool includeCameraViewMatrix, int mapIndex);
			const float* getComputedShadowTextureMatrix(bool includeCameraViewMatrix, int mapIndex);
			bool saveFrontFrameBufferToBmp(System::Drawing::Bitmap^ bmp, int width, int height);
			bool saveFrontFrameBufferToStream(IntPtr ptr, int width, int height, int pixelSizeBytes);
			
			void setShadowMapMode( ShadowMapMode mode, hkgCameraCLR^ lightCam);
			void setShadowMapSize( int size );
			void setShadowMapSplits( int numSplits );
			
			void enableDebugShadowMapView(bool on); 

			bool supportsOIT();
			bool supportsMRT();
			bool msaaEnabled();
			
			bool supportsPostEffects();
			int getNumPostEffects();
			hkgPostEffectCLR^ getPostEffects(int i);
			void addPostEffect(hkgPostEffectCLR^ e);
			void removePostEffect(hkgPostEffectCLR^ e);
			void removePostEffect(String^ name);
			void applyPostEffects(); 
		
			int getVideoMemSizeInMB();
			int getMaxTextureWidth();
			int getMaxTextureHeight();

			MeshBlendingSupport getMeshBlendingSupport();
			int getMaxBlendMatrices();

			int getMaxTextureBlendStages();
			int getDisplayAdapter();
			void getDisplayAdapterDescription(String^ desc);
			
			VelocityMapSupport getVelocityMapSupport();
			bool requiresVelocityMapPass();
			bool beginVelocityMapRender();
			void endVelocityMapRender();
	
			System::IntPtr getInternalPtr(); 

			bool inViewportResize();
			void doViewportResizeDraw();

			void setFocus();

		internal:
	
			hkgWindowCLR( hkgWindow* toWrap);
			Control^ m_currentCtrl;
			hkgWindow* m_window;
			hkgMouseCLR::Button m_mouseButtonMask;
	};


} // Graphics
} // Havok

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
