/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


#pragma once

#include <Graphics/Common/Window/hkgViewportDefines.h>

class hkgViewport;

#include <Graphics/Managed/Math/hkgMathCLR.h>
#include <Graphics/Managed/Input/hkgInputCLR.h>
#include <Graphics/Managed/DisplayContext/hkgDisplayContextCLR.h>

namespace Havok {
namespace Graphics {

	ref class hkgWindowCLR;
	ref class hkgSkyBoxCLR;
	ref class hkgCameraCLR;
	ref class hkgDisplayWorldCLR;
	ref class hkgViewportPickDataCLR;

	public ref class hkgViewportCLR
	{
	public:

		enum struct ViewportSide
		{
			NONE = HKG_VIEWPORT_SIDE_NONE,	
			TOP	= HKG_VIEWPORT_SIDE_TOP,	
			BOTTOM = HKG_VIEWPORT_SIDE_BOTTOM, 
			LEFT = HKG_VIEWPORT_SIDE_LEFT,	
			RIGHT = HKG_VIEWPORT_SIDE_RIGHT	
		};

		enum struct CameraNavigationMode
		{
			DISABLED = HKG_CAMERA_NAV_DISABLED,
			TRACKBALL = HKG_CAMERA_NAV_TRACKBALL,
			FLY = HKG_CAMERA_NAV_FLY 
		};

		enum struct MouseConvention
		{
			DEFAULT = HKG_MC_DEFAULT,
			MAX = HKG_MC_3DSMAX,
			MAYA = HKG_MC_MAYA
		};

		// Allowed create viewports
		hkgViewportCLR(hkgWindowCLR^ window);
		~hkgViewportCLR();

		void setExtentsAbsolute( int ll_x, int ll_y, int ur_x, int ur_y );
		void setExtentsRelative( float ll_x, float ll_y, float ur_x, float ur_y );

		int getWidth();
		int getHeight();

		void updateExtents();

		void setAsCurrent(hkgDisplayContextCLR^ context); 

		hkgViewportCLR^ copy( hkgWindowCLR^ owner );

		void setCamera( hkgCameraCLR^ cam );
		hkgCameraCLR^ getCamera();

		void setSkyBox( hkgSkyBoxCLR^ skybox );
		hkgSkyBoxCLR^ getSkyBox();

		CameraNavigationMode getNavigationMode();
		void setNavigationMode( CameraNavigationMode m );

		void setWorldUp( hkgVector3CLR d );
		hkgVector3CLR getWorldUp( );
		
		void setInvertLook( bool invert );
		bool getInvertLook();

		bool getAcceptsMouseEvents();
		void setAcceptsMouseEvents(bool a);
		bool getAcceptsPadEvents();
		void setAcceptsPadEvents(bool a);

		hkgDisplayContextCLR::EnabledState getDesiredState();
		void setDesiredState( hkgDisplayContextCLR::EnabledState s);
		hkgDisplayContextCLR::CullFaceMode getDesiredCullFaceMode();
		void setDesiredCullFaceMode( hkgDisplayContextCLR::CullFaceMode m);
		hkgDisplayContextCLR::BlendMode getDesiredBlendMode();
		void setDesiredBlendMode( hkgDisplayContextCLR::BlendMode  m);

		void toggleState(hkgDisplayContextCLR::EnabledState s);

		void getLowerLeftCoord(System::Int32% x, System::Int32% y);
		void getUpperRightCoord(System::Int32% x, System::Int32% y);
		void acceptMouseFocus();
	
		void setMouseConvention (MouseConvention convention);
		MouseConvention getMouseConvention();

		void processMouseMove(int x, int y, int dx, int dy, bool isVirtualMouse);
		void processMouseWheel(int delta, int x, int y, bool isVirtualMouse);
		void processMouseButton(hkgMouseCLR::Button b, bool state, int x, int y, bool isVirtualMouse);  
		void processPadStickMove( int pad, int stick, float x, float y, float dx, float dy);
		void processPadButton( int pad, hkgPadCLR::Button b, bool state);

		bool pick( int x, int y, hkgDisplayWorldCLR^ world, hkgViewportPickDataCLR^ data);
		bool pick( int x, int y, int dx, int dy, hkgDisplayWorldCLR^ world, hkgViewportPickDataCLR^ data);

		bool containsWindowCoord( int wx, int wy);
		ViewportSide isWindowCoordOnBorder( int wx, int wy, unsigned int width);

		hkgWindowCLR^ getOwnerWindow();

		void setMouseSpeed(int pan, int wheelZoom, int buttonZoom, bool absoluteSpeed);
		void getMouseSpeed(int& pan, int& wheelZoom, int& buttonZoom, bool& absoluteSpeed);

		void setFlySpeed(int strafe, int move);
		void getFlySpeed(int& strafe, int& move);

		void setPadSpeed(int pan, int zoom, bool absoluteSpeed);
		void getPadSpeed(int& pan, int& zoom, bool& absoluteSpeed);
		void updateCamera(float dt);

		IntPtr getInternalPtr();

	internal:

		hkgViewportCLR(hkgViewport* toWrap);

		hkgViewport* m_viewport;
	};


} // Graphics
} // Havok

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
