/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


#pragma once

class hkgTexture;
class hkgCubemapTexture;

class hkIstream;
class hkOstream;

#include <Graphics/Common/Texture/hkgTextureDefines.h>
#include <Graphics/Managed/Math/hkgMathCLR.h>

using namespace System::IO;

namespace Havok {
namespace Graphics {

	ref class hkgDisplayContextCLR;
	ref class hkgRawStreamCLR;

	public ref class hkgTextureCLR
	{

	public:

		enum struct TextureDefaults
		{			
			HAVOKLOG0 = HKG_TEXTURE_HAVOKLOGO,	
			FONT = HKG_TEXTURE_FONT,		
			POINTER = HKG_TEXTURE_POINTER,		
			CHECKER = HKG_TEXTURE_CHECKER,		
			PERLINNOISE = HKG_TEXTURE_PERLINNOISE,	
			DIAGONAL = HKG_TEXTURE_DIAGONAL	
		};

		enum struct PixelFormat
		{			
			RGB = HKG_TEXTURE_PIXEL_RGB,     
			RGBA = HKG_TEXTURE_PIXEL_RGBA,    
			BGR = HKG_TEXTURE_PIXEL_BGR,     
			BGRA = HKG_TEXTURE_PIXEL_BGRA,   
			ARGB = HKG_TEXTURE_PIXEL_ARGB,    
			SWIZZLED = HKG_TEXTURE_PIXEL_SWIZZLED
		};

		enum struct UVMode
		{
			CLAMP = HKG_TEXTURE_CLAMP,
			WRAP = HKG_TEXTURE_WRAP	
		};

		enum struct TextureType
		{
			SINGLE = HKG_TEXTURE_SINGLE,
			CUBEMAP = HKG_TEXTURE_CUBEMAP 
		};

		enum struct CoordGen
		{
			NONE = HKG_TEXTURE_COORDGEN_NONE,
			CSNORMAL = HKG_TEXTURE_COORDGEN_CSNORMAL,
			CSPOS = HKG_TEXTURE_COORDGEN_CSPOS,
			CSREFLECTION = HKG_TEXTURE_COORDGEN_CSREFLECTION 
		};

		enum struct Filter
		{
			POINT = HKG_TEXTURE_FILTER_POINT,
			LINEAR = HKG_TEXTURE_FILTER_LINEAR,
			ANISOTROPIC = HKG_TEXTURE_FILTER_ANISOTROPIC 
		};

		hkgTextureCLR(hkgDisplayContextCLR^ ctx);
		~hkgTextureCLR();

		bool loadFromFile(String^ filename, IntPtr hinstance); 
		bool loadFromDDS(Stream^ s);
		bool loadFromPNG(Stream^ s);
		bool loadFromTGA(Stream^ s);
		bool loadFromBMP(Stream^ s);
		bool loadBuiltIn(TextureDefaults d);
		
		bool saveToFile(String^ filename);
		//bool saveToRAW(Stream^ s); 
		//bool saveToPNG(Stream^ s);
		//bool saveToTGA(Stream^ s);

		bool hasData() ;
		void clear(); 
		hkgRawStreamCLR^ getDataPointer(int mipLevel);// miplevel = 0 == first level		
		
		PixelFormat getPixelFormat();
		int getRowByteLength(int mipLevel); 

		hkgRawStreamCLR^ lock(int mipLevel, bool willWriteAllPixels); // miplevel = 0 == first level
		void unlock(int mipLevel); 
	
		hkgRawStreamCLR^ allocateSurface( unsigned int width, unsigned int height, bool alpha );

		unsigned int getWidth();
		unsigned int getHeight();
		unsigned int getBPP();
		bool isTransparent();
		bool hasAlphaChannel();
		void setAutoMipMaps(bool on); 
		void setAutoCompression(bool on); 

		bool isLockable();

		UVMode getTextureWrapModeU();
		UVMode getTextureWrapModeV();
		UVMode getTextureWrapModeW();
		void setTextureWrapModeU(UVMode m);
		void setTextureWrapModeV(UVMode m);
		void setTextureWrapModeW(UVMode m);
		void addAlphaChannel(unsigned char value); // value = 0xff
		void addComputedAlphaChannel(bool invert );
		void flipY(); 
		void setRGB(unsigned char r, unsigned char g, unsigned char b);

		IntPtr getUserData();
		void setUserData(IntPtr d);

		bool realize(bool dynamic);	
		void free();	

		TextureType getMapType();

		void setCoordGen( CoordGen g );
		CoordGen getCoordGen( );

		void setFilterMode( Filter f );
		Filter getFilterMode( );

	internal:

		hkgTextureCLR(hkgTexture* toWrap);
		hkgTexture* m_texture;
	};

	public ref class hkgCubemapTextureCLR : public hkgTextureCLR
	{
		public:

			hkgCubemapTextureCLR(hkgDisplayContextCLR^ ctx);

		internal:
	
			hkgCubemapTextureCLR(hkgCubemapTexture* toWrap);
	};

} // Graphics
} // Havok

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
