/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


#pragma once

#include <Graphics/Common/Texture/SkyBox/hkgSkyBoxDefines.h>

class hkgSkyBox;

#include <Graphics/Managed/Math/hkgMathCLR.h>

namespace Havok {
namespace Graphics {

	ref class hkgTextureCLR;
	ref class hkgDisplayContextCLR;
	ref class hkgCameraCLR;

	public ref class hkgSkyBoxCLR
	{
	public:

		enum struct Face
		{
			UP = HKG_SKYBOX_TEXTURE_UP,    
			DOWN = HKG_SKYBOX_TEXTURE_DOWN,  
			LEFT = HKG_SKYBOX_TEXTURE_LEFT,  
			RIGHT = HKG_SKYBOX_TEXTURE_RIGHT, 
			FRONT = HKG_SKYBOX_TEXTURE_FRONT, 
			BACK = HKG_SKYBOX_TEXTURE_BACK, 

			CUBE = HKG_SKYBOX_TEXTURE_CUBE, 
			CUBE_DIM = HKG_SKYBOX_TEXTURE_CUBE_DIM, 
			CUBE_SIM = HKG_SKYBOX_TEXTURE_CUBE_SIM 
		};

		// Allowed create skyboxes
		hkgSkyBoxCLR();
		~hkgSkyBoxCLR();

		/// Optional as they can be solid color sometimes, use (null,color) then.
		/// To never draw a face, use (null, 0x00******) as alpha is not allowed. 
		void setTexture(Face f, hkgTextureCLR^ t, unsigned int packedColor); 
		hkgTextureCLR^ getTexture(Face f);

		void setUpDirection( hkgVector3CLR up );
		void render( hkgDisplayContextCLR^ context, hkgCameraCLR^ camera );

	internal:

		hkgSkyBoxCLR(hkgSkyBox* toWrap);
		hkgSkyBox* m_skybox;
	};


} // Graphics
} // Havok

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
