/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


#pragma once

#include <Graphics/Common/Shader/hkgShaderLibDefines.h>
#include <Graphics/Common/Texture/hkgTextureDefines.h>

class hkgShaderLib;

#include <Graphics/Managed/Math/hkgMathCLR.h>
#include <Graphics/Managed/DisplayContext/hkgDisplayContextCLR.h>

using namespace System::IO;
using namespace System;
using namespace System::Collections::Generic;

namespace Havok {
namespace Graphics {
	
	ref class hkgShaderEffectCollectionCLR;
		
	public ref class hkgShaderLibTextureStageCLR
	{
	public:
		
		enum struct TextureTypeFlags
		{
			UNKNOWN = HKG_TEXTURE_TYPE_UNKNOWN,	
			DIFFUSE = HKG_TEXTURE_TYPE_DIFFUSE,	
			REFLECTION = HKG_TEXTURE_TYPE_REFLECTION,
			BUMP = HKG_TEXTURE_TYPE_BUMP,		
			NORMAL = HKG_TEXTURE_TYPE_NORMAL,		
			DISPLACEMENT = HKG_TEXTURE_TYPE_DISPLACEMENT,	
			SPECULAR = HKG_TEXTURE_TYPE_SPECULAR,	
			SPECULARANDGLOSS = HKG_TEXTURE_TYPE_SPECULARANDGLOSS,	
			OPACITY = HKG_TEXTURE_TYPE_OPACITY,	
			EMISSIVE = HKG_TEXTURE_TYPE_EMISSIVE,	
			REFRACTION = HKG_TEXTURE_TYPE_REFRACTION,	
			GLOSS = HKG_TEXTURE_TYPE_GLOSS,		
			MASK = HKG_TEXTURE_TYPE_MASK,	
			BLEND = HKG_TEXTURE_TYPE_BLEND,	
			DOMINANTS = HKG_TEXTURE_TYPE_DOMINANTS
		};
		
		TextureTypeFlags m_type; 
		int m_textureCoord; // Texcoord channel used
	};


	public ref class hkgShaderLibCLR
	{
	public:
	
		hkgShaderLibCLR( hkgDisplayContextCLR^ ctx );
		~hkgShaderLibCLR( );

		void addSearchPath( String^ path );
		void clearSearchPaths();

		void clearCache();

		void setAutoLoadShaderTypes( bool instanced, bool skinned );
		void getAutoLoadShaderTypes( bool% instanced, bool% skinned );

		void setMaxBlendMatrices(int m);
		int getMaxBlendMatrices();
		
		enum struct DisplayObjectFlags
		{
			NO_FLAGS = HKG_SHADERLIB_OBJECT_NO_FLAGS,
			SKINNED = HKG_SHADERLIB_OBJECT_SKINNED, // need shader to support h/w skinning
			INSTANCED = HKG_SHADERLIB_OBJECT_INSTANCED // need shader to support h/w instancing
		};

		enum struct ExtraTextureHints
		{
			NO_HINTS = HKG_SHADERLIB_EXTRA_TEXTURE_HINT_NONE,
			LIGHTMAP = HKG_SHADERLIB_EXTRA_TEXTURE_HINT_LIGHTMAP, // one of the diffuse textures is a lightmap
			USE_ALPHA_SHADOWS = HKG_SHADERLIB_EXTRA_TEXTURE_HINT_USE_ALPHA_SHADOWS, // use the shadow shader that has alpha enabled shadow map (slower smap creation)
			USE_DIFFUSE_ONLY = HKG_SHADERLIB_EXTRA_TEXTURE_HINT_USE_DIFFUSE_ONLY // usually used in 'low fi / fast graphics' versions, so laptops faster etc 
		};
	
		enum struct WellKnownShaderType
		{
			DIFFUSE_ONLY_T1 = HKG_SHADERLIB_WELLKNOWN_DIFFUSE_ONLY_T1,
			DIFFUSE_NORMAL_T1 = HKG_SHADERLIB_WELLKNOWN_DIFFUSE_NORMAL_T1,
			DIFFUSE_NORMAL_SPECULAR_T1 = HKG_SHADERLIB_WELLKNOWN_DIFFUSE_NORMAL_SPECULAR_T1, // Most common asset: Diffuse, Normal and Specular maps all share tcoord0
			DIFFUSE_DIFFUSE_NORMAL_SPECULAR_T2 = HKG_SHADERLIB_WELLKNOWN_DIFFUSE_DIFFUSE_NORMAL_SPECULAR_T2, // Second diffuse uses tcoord1, usually a dirt map
			DIFFUSE_LIGHTMAP_NORMAL_SPECULAR_T2 = HKG_SHADERLIB_WELLKNOWN_DIFFUSE_LIGHTMAP_NORMAL_SPECULAR_T2, // Most common prelit scene asset: Diffuse texture, Normal map and Specular share tcoord0, LightMap uses tcoord1. Shadow depends on LightMap luminance 
			DIFFUSE_NORMAL_DISPLACEMENT_SPECULAR_T1 = HKG_SHADERLIB_WELLKNOWN_DIFFUSE_NORMAL_DISPLACEMENT_SPECULAR_T1 // For usual high quality assets: Diffuse texture, normal and specular map for lighting, displacement heightfield for surface detail
		};



			/// Get a shader collection for the given material
			/// Will normal give back at least 3 sets (2 for shadow map passes, and 1 for no shadows) 
			/// Will return NULL if none found that match
			/// Pass 0 for numLights for unlit shaders
		hkgShaderEffectCollectionCLR^ findShader( cli::array<hkgShaderLibTextureStageCLR^>^ sourceMaterialStages, DisplayObjectFlags objectFlags, ExtraTextureHints textureHints, int numLights, String^ debugName );

		hkgShaderEffectCollectionCLR^ findShader( WellKnownShaderType t, DisplayObjectFlags objectFlags, ExtraTextureHints textureHints, int numLights );
		
	internal:
		
		hkgShaderLibCLR(hkgShaderLib* toWrap);
		hkgShaderLib* m_shaderLib;

	};

} // Graphics
} // Havok

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
