/*
 *
 * Confidential Information of Telekinesys Research Limited (t/a Havok). Not for disclosure or distribution without Havok's
 * prior written consent. This software contains code, techniques and know-how which is confidential and proprietary to Havok.
 * Product and Trade Secret source code contains trade secrets of Havok. Havok Software (C) Copyright 1999-2014 Telekinesys Research Limited t/a Havok. All Rights Reserved. Use of this software is subject to the terms of an end user license agreement.
 *
 */


#pragma once

#include <Graphics/Common/Shader/hkgShaderDefines.h>

class hkgShader;
class hkgShaderEffect;
class hkgShaderEffectCollection;

#include <Graphics/Managed/Math/hkgMathCLR.h>
#include <Graphics/Managed/DisplayContext/hkgDisplayContextCLR.h>

using namespace System::IO;
using namespace System;
using namespace System::Collections::Generic;

namespace Havok {
namespace Graphics {

	public ref class hkgShaderDefineCLR
	{
	public:
		String^ m_name;
		String^ m_value;
	};
	
	public ref class hkgShaderCLR
	{
	public:

		enum struct ShaderType
		{
			PIXEL = HKG_PIXEL_SHADER,
			VERTEX = HKG_VERTEX_SHADER,
			GEOMETRY = HKG_GEOMETRY_SHADER
		};

		enum struct RenderStyle
		{
			NOSTYLE = HKG_SHADER_RENDER_NOSTYLE, 
			X1LIGHTS = HKG_SHADER_RENDER_1LIGHTS,
			X2LIGHTS = HKG_SHADER_RENDER_2LIGHTS, 
			X3LIGHTS = HKG_SHADER_RENDER_3LIGHTS, 
			X4LIGHTS = HKG_SHADER_RENDER_4LIGHTS, 
			X5LIGHTS = HKG_SHADER_RENDER_5LIGHTS, 
			X6LIGHTS = HKG_SHADER_RENDER_6LIGHTS, 
			X7LIGHTS = HKG_SHADER_RENDER_7LIGHTS, 
			LIGHT_MASK = HKG_SHADER_RENDER_LIGHT_MASK, 
			MODULATE_TEXTURE0 = HKG_SHADER_RENDER_MODULATE_TEXTURE0,  
			MODULATE_TEXTURE1 = HKG_SHADER_RENDER_MODULATE_TEXTURE1,  
			MODULATE_TEXTURE2 = HKG_SHADER_RENDER_MODULATE_TEXTURE2,  
			MODULATE_TEXTURE3 = HKG_SHADER_RENDER_MODULATE_TEXTURE3,  
			DECAL_TEXTURE0 = HKG_SHADER_RENDER_DECAL_TEXTURE0,	 
			DECAL_TEXTURE1 = HKG_SHADER_RENDER_DECAL_TEXTURE1,	 
			DECAL_TEXTURE2 = HKG_SHADER_RENDER_DECAL_TEXTURE2,	 
			DECAL_TEXTURE3 = HKG_SHADER_RENDER_DECAL_TEXTURE3,	 
			TEXTURE_MASK = HKG_SHADER_RENDER_TEXTURE_MASK,	 
			VERTEX_COLOR = HKG_SHADER_RENDER_VERTEX_COLOR,      
			BLENDING = HKG_SHADER_RENDER_BLENDING,          
			TANGENTS = HKG_SHADER_RENDER_TANGENTS,          
			MATERIAL_HINT_MASK = HKG_SHADER_RENDER_MATERIAL_HINT_MASK, 
			INSTANCING_USING_TCOORDS =  HKG_SHADER_RENDER_INSTANCING_USING_TCOORDS, 
			TO_DEPTHMAP = HKG_SHADER_RENDER_TO_DEPTHMAP,			
			TO_DEPTHMAP_VSM = HKG_SHADER_RENDER_TO_DEPTHMAP_VSM,
			BASED_ON_DEPTHMAP = HKG_SHADER_RENDER_BASED_ON_DEPTHMAP,		
			BASED_ON_DEPTHMAP_HW = HKG_SHADER_RENDER_BASED_ON_DEPTHMAP_HW,
			BASED_ON_DEPTHMAP_VSM = HKG_SHADER_RENDER_BASED_ON_DEPTHMAP_VSM
		};

		hkgShaderCLR(ShaderType t, hkgDisplayContextCLR^ ctx);
		~hkgShaderCLR();

		void setShaderFileName(String^ fname); // not normally required to be called.

		// Note the ret value on these is bound or not, not compiled or not..
		bool realizeCompile(Stream^ stream, String^ entryPoint, RenderStyle style, String^ includePath, array< hkgShaderDefineCLR^ >^ defines );	
		bool realizeCompileFromFile(String^ filename, String^ entryPoint, RenderStyle style, String^ includePath, array< hkgShaderDefineCLR^ >^ defines );

	public: // internal

		void uploadConstants();	
		
		RenderStyle getStyle();
	
		
	internal:
		
		hkgShaderCLR(hkgShader* toWrap);
		hkgShader* m_shader;
	};


	public ref class hkgShaderEffectCLR
	{
	public:
	
		static Dictionary<IntPtr, hkgShaderEffectCLR^>^ managedShaderMapping = gcnew System::Collections::Generic::Dictionary<IntPtr, hkgShaderEffectCLR^>();
		
		hkgShaderEffectCLR();
		~hkgShaderEffectCLR();

		void setFloatInputByName( String^ n, float v );
		void setFloatInputByName( String^ n, hkgVector3CLR v );
		void setFloatInputByName( String^ n, hkgVector4CLR v);
		void setFloatInputByName( String^ n, hkgMatrix4CLR m, int rows); // rows normal 3 or 4 (for 12 or 16 entry xfrom)

		delegate void hkgShaderEffectCLRBindDelegate(hkgShaderEffectCLR^ shaders);
		void setBindCallback(hkgShaderEffectCLRBindDelegate^ bindDelegate);

	internal:
		
		void doManagedCallback();
		hkgShaderEffectCLR(hkgShaderEffect* toWrap);
		hkgShaderEffect* m_shaderEffect;
		hkgShaderEffectCLRBindDelegate^ m_callback;
	};


	public ref class hkgShaderEffectCollectionCLR
	{
	public:

		hkgShaderEffectCollectionCLR();
		~hkgShaderEffectCollectionCLR();

		void addShaderEffect( hkgShaderCLR^ vshader, hkgShaderCLR^ pshader );
		void removeShaderEffect( int i );

		int getNumShaderEffects();
		
	internal:

		hkgShaderEffectCollectionCLR(hkgShaderEffectCollection* toWrap);
		hkgShaderEffectCollection* m_collection;
	};

} // Graphics
} // Havok

/*
 * Havok SDK - NO SOURCE PC DOWNLOAD, BUILD(#20140907)
 * 
 * Confidential Information of Havok.  (C) Copyright 1999-2014
 * Telekinesys Research Limited t/a Havok. All Rights Reserved. The Havok
 * Logo, and the Havok buzzsaw logo are trademarks of Havok.  Title, ownership
 * rights, and intellectual property rights in the Havok software remain in
 * Havok and/or its suppliers.
 * 
 * Use of this software for evaluation purposes is subject to and indicates
 * acceptance of the End User licence Agreement for this product. A copy of
 * the license is included with this software and is also available at www.havok.com/tryhavok.
 * 
 */
